/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.logging.java;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.jena.atlas.logging.java.TextFormatter;

public class ConsoleHandlerStream
extends StreamHandler {
    private static OutputStream protectStdOutput(OutputStream outputStream) {
        if (outputStream == System.err || outputStream == System.out) {
            return new CloseShieldOutputStream(outputStream);
        }
        return outputStream;
    }

    public ConsoleHandlerStream() {
        this(System.out);
    }

    public ConsoleHandlerStream(OutputStream outputStream) {
        super(ConsoleHandlerStream.protectStdOutput(outputStream), new TextFormatter());
        String pEncoding;
        String pFilter;
        LogManager manager = LogManager.getLogManager();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        String cname = this.getClass().getName();
        Level level = Level.INFO;
        String pLevel = ConsoleHandlerStream.getProperty(manager, cname, "level");
        if (pLevel != null) {
            level = Level.parse(pLevel);
        }
        this.setLevel(level);
        String pFormatter = ConsoleHandlerStream.getProperty(manager, cname, "formatter");
        if (pFormatter != null) {
            try {
                Class<?> cls = classLoader.loadClass(pFormatter);
                this.setFormatter((Formatter)cls.newInstance());
            }
            catch (Exception ex) {
                System.err.println("Problems setting the logging formatter");
                ex.printStackTrace(System.err);
            }
        }
        if ((pFilter = ConsoleHandlerStream.getProperty(manager, cname, "filter")) != null) {
            try {
                Class<?> cls = classLoader.loadClass(pFilter);
                this.setFilter((Filter)cls.newInstance());
            }
            catch (Exception ex) {
                System.err.println("Problems setting the logging filter");
                ex.printStackTrace(System.err);
            }
        }
        if ((pEncoding = ConsoleHandlerStream.getProperty(manager, cname, "encoding")) == null) {
            pEncoding = StandardCharsets.UTF_8.name();
        }
        try {
            this.setEncoding(pEncoding);
        }
        catch (Exception e2) {
            System.err.print("Failed to set encoding: " + e2.getMessage());
        }
    }

    private static String getProperty(LogManager manager, String cname, String pname) {
        return manager.getProperty(cname + "." + pname);
    }

    @Override
    public void publish(LogRecord record) {
        super.publish(record);
        this.flush();
    }
}

