/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import org.apache.commons.dbcp2.SwallowedExceptionLogger;
import org.apache.commons.dbcp2.datasources.CPDSConnectionFactory;
import org.apache.commons.dbcp2.datasources.InstanceKeyDataSource;
import org.apache.commons.dbcp2.datasources.InstanceKeyDataSourceFactory;
import org.apache.commons.dbcp2.datasources.PerUserPoolDataSourceFactory;
import org.apache.commons.dbcp2.datasources.PoolKey;
import org.apache.commons.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp2.datasources.PooledConnectionManager;
import org.apache.commons.dbcp2.datasources.UserPassKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class PerUserPoolDataSource
extends InstanceKeyDataSource {
    private static final long serialVersionUID = 7872747993848065028L;
    private static final Log log = LogFactory.getLog(PerUserPoolDataSource.class);
    private Map<String, Boolean> perUserBlockWhenExhausted = null;
    private Map<String, String> perUserEvictionPolicyClassName = null;
    private Map<String, Boolean> perUserLifo = null;
    private Map<String, Integer> perUserMaxIdle = null;
    private Map<String, Integer> perUserMaxTotal = null;
    private Map<String, Long> perUserMaxWaitMillis = null;
    private Map<String, Long> perUserMinEvictableIdleTimeMillis = null;
    private Map<String, Integer> perUserMinIdle = null;
    private Map<String, Integer> perUserNumTestsPerEvictionRun = null;
    private Map<String, Long> perUserSoftMinEvictableIdleTimeMillis = null;
    private Map<String, Boolean> perUserTestOnCreate = null;
    private Map<String, Boolean> perUserTestOnBorrow = null;
    private Map<String, Boolean> perUserTestOnReturn = null;
    private Map<String, Boolean> perUserTestWhileIdle = null;
    private Map<String, Long> perUserTimeBetweenEvictionRunsMillis = null;
    private Map<String, Boolean> perUserDefaultAutoCommit = null;
    private Map<String, Integer> perUserDefaultTransactionIsolation = null;
    private Map<String, Boolean> perUserDefaultReadOnly = null;
    private transient Map<PoolKey, PooledConnectionManager> managers = new HashMap<PoolKey, PooledConnectionManager>();

    @Override
    public void close() {
        for (PooledConnectionManager manager : this.managers.values()) {
            try {
                ((CPDSConnectionFactory)manager).getPool().close();
            }
            catch (Exception exception) {}
        }
        InstanceKeyDataSourceFactory.removeInstance(this.getInstanceKey());
    }

    public boolean getPerUserBlockWhenExhausted(String key) {
        Boolean value = null;
        if (this.perUserBlockWhenExhausted != null) {
            value = this.perUserBlockWhenExhausted.get(key);
        }
        if (value == null) {
            return this.getDefaultBlockWhenExhausted();
        }
        return value;
    }

    public void setPerUserBlockWhenExhausted(String username, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserBlockWhenExhausted == null) {
            this.perUserBlockWhenExhausted = new HashMap<String, Boolean>();
        }
        this.perUserBlockWhenExhausted.put(username, value);
    }

    void setPerUserBlockWhenExhausted(Map<String, Boolean> userDefaultBlockWhenExhausted) {
        this.assertInitializationAllowed();
        if (this.perUserBlockWhenExhausted == null) {
            this.perUserBlockWhenExhausted = new HashMap<String, Boolean>();
        } else {
            this.perUserBlockWhenExhausted.clear();
        }
        this.perUserBlockWhenExhausted.putAll(userDefaultBlockWhenExhausted);
    }

    public String getPerUserEvictionPolicyClassName(String key) {
        String value = null;
        if (this.perUserEvictionPolicyClassName != null) {
            value = this.perUserEvictionPolicyClassName.get(key);
        }
        if (value == null) {
            return this.getDefaultEvictionPolicyClassName();
        }
        return value;
    }

    public void setPerUserEvictionPolicyClassName(String username, String value) {
        this.assertInitializationAllowed();
        if (this.perUserEvictionPolicyClassName == null) {
            this.perUserEvictionPolicyClassName = new HashMap<String, String>();
        }
        this.perUserEvictionPolicyClassName.put(username, value);
    }

    void setPerUserEvictionPolicyClassName(Map<String, String> userDefaultEvictionPolicyClassName) {
        this.assertInitializationAllowed();
        if (this.perUserEvictionPolicyClassName == null) {
            this.perUserEvictionPolicyClassName = new HashMap<String, String>();
        } else {
            this.perUserEvictionPolicyClassName.clear();
        }
        this.perUserEvictionPolicyClassName.putAll(userDefaultEvictionPolicyClassName);
    }

    public boolean getPerUserLifo(String key) {
        Boolean value = null;
        if (this.perUserLifo != null) {
            value = this.perUserLifo.get(key);
        }
        if (value == null) {
            return this.getDefaultLifo();
        }
        return value;
    }

    public void setPerUserLifo(String username, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserLifo == null) {
            this.perUserLifo = new HashMap<String, Boolean>();
        }
        this.perUserLifo.put(username, value);
    }

    void setPerUserLifo(Map<String, Boolean> userDefaultLifo) {
        this.assertInitializationAllowed();
        if (this.perUserLifo == null) {
            this.perUserLifo = new HashMap<String, Boolean>();
        } else {
            this.perUserLifo.clear();
        }
        this.perUserLifo.putAll(userDefaultLifo);
    }

    public int getPerUserMaxIdle(String key) {
        Integer value = null;
        if (this.perUserMaxIdle != null) {
            value = this.perUserMaxIdle.get(key);
        }
        if (value == null) {
            return this.getDefaultMaxIdle();
        }
        return value;
    }

    public void setPerUserMaxIdle(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxIdle == null) {
            this.perUserMaxIdle = new HashMap<String, Integer>();
        }
        this.perUserMaxIdle.put(username, value);
    }

    void setPerUserMaxIdle(Map<String, Integer> userDefaultMaxIdle) {
        this.assertInitializationAllowed();
        if (this.perUserMaxIdle == null) {
            this.perUserMaxIdle = new HashMap<String, Integer>();
        } else {
            this.perUserMaxIdle.clear();
        }
        this.perUserMaxIdle.putAll(userDefaultMaxIdle);
    }

    public int getPerUserMaxTotal(String key) {
        Integer value = null;
        if (this.perUserMaxTotal != null) {
            value = this.perUserMaxTotal.get(key);
        }
        if (value == null) {
            return this.getDefaultMaxTotal();
        }
        return value;
    }

    public void setPerUserMaxTotal(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxTotal == null) {
            this.perUserMaxTotal = new HashMap<String, Integer>();
        }
        this.perUserMaxTotal.put(username, value);
    }

    void setPerUserMaxTotal(Map<String, Integer> userDefaultMaxTotal) {
        this.assertInitializationAllowed();
        if (this.perUserMaxTotal == null) {
            this.perUserMaxTotal = new HashMap<String, Integer>();
        } else {
            this.perUserMaxTotal.clear();
        }
        this.perUserMaxTotal.putAll(userDefaultMaxTotal);
    }

    public long getPerUserMaxWaitMillis(String key) {
        Long value = null;
        if (this.perUserMaxWaitMillis != null) {
            value = this.perUserMaxWaitMillis.get(key);
        }
        if (value == null) {
            return this.getDefaultMaxWaitMillis();
        }
        return value;
    }

    public void setPerUserMaxWaitMillis(String username, Long value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxWaitMillis == null) {
            this.perUserMaxWaitMillis = new HashMap<String, Long>();
        }
        this.perUserMaxWaitMillis.put(username, value);
    }

    void setPerUserMaxWaitMillis(Map<String, Long> userDefaultMaxWaitMillis) {
        this.assertInitializationAllowed();
        if (this.perUserMaxWaitMillis == null) {
            this.perUserMaxWaitMillis = new HashMap<String, Long>();
        } else {
            this.perUserMaxWaitMillis.clear();
        }
        this.perUserMaxWaitMillis.putAll(userDefaultMaxWaitMillis);
    }

    public long getPerUserMinEvictableIdleTimeMillis(String key) {
        Long value = null;
        if (this.perUserMinEvictableIdleTimeMillis != null) {
            value = this.perUserMinEvictableIdleTimeMillis.get(key);
        }
        if (value == null) {
            return this.getDefaultMinEvictableIdleTimeMillis();
        }
        return value;
    }

    public void setPerUserMinEvictableIdleTimeMillis(String username, Long value) {
        this.assertInitializationAllowed();
        if (this.perUserMinEvictableIdleTimeMillis == null) {
            this.perUserMinEvictableIdleTimeMillis = new HashMap<String, Long>();
        }
        this.perUserMinEvictableIdleTimeMillis.put(username, value);
    }

    void setPerUserMinEvictableIdleTimeMillis(Map<String, Long> userDefaultMinEvictableIdleTimeMillis) {
        this.assertInitializationAllowed();
        if (this.perUserMinEvictableIdleTimeMillis == null) {
            this.perUserMinEvictableIdleTimeMillis = new HashMap<String, Long>();
        } else {
            this.perUserMinEvictableIdleTimeMillis.clear();
        }
        this.perUserMinEvictableIdleTimeMillis.putAll(userDefaultMinEvictableIdleTimeMillis);
    }

    public int getPerUserMinIdle(String key) {
        Integer value = null;
        if (this.perUserMinIdle != null) {
            value = this.perUserMinIdle.get(key);
        }
        if (value == null) {
            return this.getDefaultMinIdle();
        }
        return value;
    }

    public void setPerUserMinIdle(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMinIdle == null) {
            this.perUserMinIdle = new HashMap<String, Integer>();
        }
        this.perUserMinIdle.put(username, value);
    }

    void setPerUserMinIdle(Map<String, Integer> userDefaultMinIdle) {
        this.assertInitializationAllowed();
        if (this.perUserMinIdle == null) {
            this.perUserMinIdle = new HashMap<String, Integer>();
        } else {
            this.perUserMinIdle.clear();
        }
        this.perUserMinIdle.putAll(userDefaultMinIdle);
    }

    public int getPerUserNumTestsPerEvictionRun(String key) {
        Integer value = null;
        if (this.perUserNumTestsPerEvictionRun != null) {
            value = this.perUserNumTestsPerEvictionRun.get(key);
        }
        if (value == null) {
            return this.getDefaultNumTestsPerEvictionRun();
        }
        return value;
    }

    public void setPerUserNumTestsPerEvictionRun(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserNumTestsPerEvictionRun == null) {
            this.perUserNumTestsPerEvictionRun = new HashMap<String, Integer>();
        }
        this.perUserNumTestsPerEvictionRun.put(username, value);
    }

    void setPerUserNumTestsPerEvictionRun(Map<String, Integer> userDefaultNumTestsPerEvictionRun) {
        this.assertInitializationAllowed();
        if (this.perUserNumTestsPerEvictionRun == null) {
            this.perUserNumTestsPerEvictionRun = new HashMap<String, Integer>();
        } else {
            this.perUserNumTestsPerEvictionRun.clear();
        }
        this.perUserNumTestsPerEvictionRun.putAll(userDefaultNumTestsPerEvictionRun);
    }

    public long getPerUserSoftMinEvictableIdleTimeMillis(String key) {
        Long value = null;
        if (this.perUserSoftMinEvictableIdleTimeMillis != null) {
            value = this.perUserSoftMinEvictableIdleTimeMillis.get(key);
        }
        if (value == null) {
            return this.getDefaultSoftMinEvictableIdleTimeMillis();
        }
        return value;
    }

    public void setPerUserSoftMinEvictableIdleTimeMillis(String username, Long value) {
        this.assertInitializationAllowed();
        if (this.perUserSoftMinEvictableIdleTimeMillis == null) {
            this.perUserSoftMinEvictableIdleTimeMillis = new HashMap<String, Long>();
        }
        this.perUserSoftMinEvictableIdleTimeMillis.put(username, value);
    }

    void setPerUserSoftMinEvictableIdleTimeMillis(Map<String, Long> userDefaultSoftMinEvictableIdleTimeMillis) {
        this.assertInitializationAllowed();
        if (this.perUserSoftMinEvictableIdleTimeMillis == null) {
            this.perUserSoftMinEvictableIdleTimeMillis = new HashMap<String, Long>();
        } else {
            this.perUserSoftMinEvictableIdleTimeMillis.clear();
        }
        this.perUserSoftMinEvictableIdleTimeMillis.putAll(userDefaultSoftMinEvictableIdleTimeMillis);
    }

    public boolean getPerUserTestOnCreate(String key) {
        Boolean value = null;
        if (this.perUserTestOnCreate != null) {
            value = this.perUserTestOnCreate.get(key);
        }
        if (value == null) {
            return this.getDefaultTestOnCreate();
        }
        return value;
    }

    public void setPerUserTestOnCreate(String username, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnCreate == null) {
            this.perUserTestOnCreate = new HashMap<String, Boolean>();
        }
        this.perUserTestOnCreate.put(username, value);
    }

    void setPerUserTestOnCreate(Map<String, Boolean> userDefaultTestOnCreate) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnCreate == null) {
            this.perUserTestOnCreate = new HashMap<String, Boolean>();
        } else {
            this.perUserTestOnCreate.clear();
        }
        this.perUserTestOnCreate.putAll(userDefaultTestOnCreate);
    }

    public boolean getPerUserTestOnBorrow(String key) {
        Boolean value = null;
        if (this.perUserTestOnBorrow != null) {
            value = this.perUserTestOnBorrow.get(key);
        }
        if (value == null) {
            return this.getDefaultTestOnBorrow();
        }
        return value;
    }

    public void setPerUserTestOnBorrow(String username, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnBorrow == null) {
            this.perUserTestOnBorrow = new HashMap<String, Boolean>();
        }
        this.perUserTestOnBorrow.put(username, value);
    }

    void setPerUserTestOnBorrow(Map<String, Boolean> userDefaultTestOnBorrow) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnBorrow == null) {
            this.perUserTestOnBorrow = new HashMap<String, Boolean>();
        } else {
            this.perUserTestOnBorrow.clear();
        }
        this.perUserTestOnBorrow.putAll(userDefaultTestOnBorrow);
    }

    public boolean getPerUserTestOnReturn(String key) {
        Boolean value = null;
        if (this.perUserTestOnReturn != null) {
            value = this.perUserTestOnReturn.get(key);
        }
        if (value == null) {
            return this.getDefaultTestOnReturn();
        }
        return value;
    }

    public void setPerUserTestOnReturn(String username, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnReturn == null) {
            this.perUserTestOnReturn = new HashMap<String, Boolean>();
        }
        this.perUserTestOnReturn.put(username, value);
    }

    void setPerUserTestOnReturn(Map<String, Boolean> userDefaultTestOnReturn) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnReturn == null) {
            this.perUserTestOnReturn = new HashMap<String, Boolean>();
        } else {
            this.perUserTestOnReturn.clear();
        }
        this.perUserTestOnReturn.putAll(userDefaultTestOnReturn);
    }

    public boolean getPerUserTestWhileIdle(String key) {
        Boolean value = null;
        if (this.perUserTestWhileIdle != null) {
            value = this.perUserTestWhileIdle.get(key);
        }
        if (value == null) {
            return this.getDefaultTestWhileIdle();
        }
        return value;
    }

    public void setPerUserTestWhileIdle(String username, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserTestWhileIdle == null) {
            this.perUserTestWhileIdle = new HashMap<String, Boolean>();
        }
        this.perUserTestWhileIdle.put(username, value);
    }

    void setPerUserTestWhileIdle(Map<String, Boolean> userDefaultTestWhileIdle) {
        this.assertInitializationAllowed();
        if (this.perUserTestWhileIdle == null) {
            this.perUserTestWhileIdle = new HashMap<String, Boolean>();
        } else {
            this.perUserTestWhileIdle.clear();
        }
        this.perUserTestWhileIdle.putAll(userDefaultTestWhileIdle);
    }

    public long getPerUserTimeBetweenEvictionRunsMillis(String key) {
        Long value = null;
        if (this.perUserTimeBetweenEvictionRunsMillis != null) {
            value = this.perUserTimeBetweenEvictionRunsMillis.get(key);
        }
        if (value == null) {
            return this.getDefaultTimeBetweenEvictionRunsMillis();
        }
        return value;
    }

    public void setPerUserTimeBetweenEvictionRunsMillis(String username, Long value) {
        this.assertInitializationAllowed();
        if (this.perUserTimeBetweenEvictionRunsMillis == null) {
            this.perUserTimeBetweenEvictionRunsMillis = new HashMap<String, Long>();
        }
        this.perUserTimeBetweenEvictionRunsMillis.put(username, value);
    }

    void setPerUserTimeBetweenEvictionRunsMillis(Map<String, Long> userDefaultTimeBetweenEvictionRunsMillis) {
        this.assertInitializationAllowed();
        if (this.perUserTimeBetweenEvictionRunsMillis == null) {
            this.perUserTimeBetweenEvictionRunsMillis = new HashMap<String, Long>();
        } else {
            this.perUserTimeBetweenEvictionRunsMillis.clear();
        }
        this.perUserTimeBetweenEvictionRunsMillis.putAll(userDefaultTimeBetweenEvictionRunsMillis);
    }

    public Boolean getPerUserDefaultAutoCommit(String key) {
        Boolean value = null;
        if (this.perUserDefaultAutoCommit != null) {
            value = this.perUserDefaultAutoCommit.get(key);
        }
        return value;
    }

    public void setPerUserDefaultAutoCommit(String username, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultAutoCommit == null) {
            this.perUserDefaultAutoCommit = new HashMap<String, Boolean>();
        }
        this.perUserDefaultAutoCommit.put(username, value);
    }

    void setPerUserDefaultAutoCommit(Map<String, Boolean> userDefaultAutoCommit) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultAutoCommit == null) {
            this.perUserDefaultAutoCommit = new HashMap<String, Boolean>();
        } else {
            this.perUserDefaultAutoCommit.clear();
        }
        this.perUserDefaultAutoCommit.putAll(userDefaultAutoCommit);
    }

    public Boolean getPerUserDefaultReadOnly(String key) {
        Boolean value = null;
        if (this.perUserDefaultReadOnly != null) {
            value = this.perUserDefaultReadOnly.get(key);
        }
        return value;
    }

    public void setPerUserDefaultReadOnly(String username, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultReadOnly == null) {
            this.perUserDefaultReadOnly = new HashMap<String, Boolean>();
        }
        this.perUserDefaultReadOnly.put(username, value);
    }

    void setPerUserDefaultReadOnly(Map<String, Boolean> userDefaultReadOnly) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultReadOnly == null) {
            this.perUserDefaultReadOnly = new HashMap<String, Boolean>();
        } else {
            this.perUserDefaultReadOnly.clear();
        }
        this.perUserDefaultReadOnly.putAll(userDefaultReadOnly);
    }

    public Integer getPerUserDefaultTransactionIsolation(String key) {
        Integer value = null;
        if (this.perUserDefaultTransactionIsolation != null) {
            value = this.perUserDefaultTransactionIsolation.get(key);
        }
        return value;
    }

    public void setPerUserDefaultTransactionIsolation(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultTransactionIsolation == null) {
            this.perUserDefaultTransactionIsolation = new HashMap<String, Integer>();
        }
        this.perUserDefaultTransactionIsolation.put(username, value);
    }

    void setPerUserDefaultTransactionIsolation(Map<String, Integer> userDefaultTransactionIsolation) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultTransactionIsolation == null) {
            this.perUserDefaultTransactionIsolation = new HashMap<String, Integer>();
        } else {
            this.perUserDefaultTransactionIsolation.clear();
        }
        this.perUserDefaultTransactionIsolation.putAll(userDefaultTransactionIsolation);
    }

    public int getNumActive() {
        return this.getNumActive(null);
    }

    public int getNumActive(String username) {
        ObjectPool<PooledConnectionAndInfo> pool = this.getPool(this.getPoolKey(username));
        return pool == null ? 0 : pool.getNumActive();
    }

    public int getNumIdle() {
        return this.getNumIdle(null);
    }

    public int getNumIdle(String username) {
        ObjectPool<PooledConnectionAndInfo> pool = this.getPool(this.getPoolKey(username));
        return pool == null ? 0 : pool.getNumIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PooledConnectionAndInfo getPooledConnectionAndInfo(String username, String password) throws SQLException {
        ObjectPool<PooledConnectionAndInfo> pool;
        PooledConnectionManager manager;
        PoolKey key = this.getPoolKey(username);
        PerUserPoolDataSource perUserPoolDataSource = this;
        synchronized (perUserPoolDataSource) {
            manager = this.managers.get(key);
            if (manager == null) {
                try {
                    this.registerPool(username, password);
                    manager = this.managers.get(key);
                }
                catch (NamingException e) {
                    throw new SQLException("RegisterPool failed", e);
                }
            }
            pool = ((CPDSConnectionFactory)manager).getPool();
        }
        PooledConnectionAndInfo info = null;
        try {
            info = pool.borrowObject();
        }
        catch (NoSuchElementException ex) {
            throw new SQLException("Could not retrieve connection info from pool", ex);
        }
        catch (Exception e) {
            try {
                this.testCPDS(username, password);
            }
            catch (Exception ex) {
                throw new SQLException("Could not retrieve connection info from pool", ex);
            }
            manager.closePool(username);
            PerUserPoolDataSource ex = this;
            synchronized (ex) {
                this.managers.remove(key);
            }
            try {
                this.registerPool(username, password);
                pool = this.getPool(key);
            }
            catch (NamingException ne) {
                throw new SQLException("RegisterPool failed", ne);
            }
            try {
                info = pool.borrowObject();
            }
            catch (Exception ex2) {
                throw new SQLException("Could not retrieve connection info from pool", ex2);
            }
        }
        return info;
    }

    @Override
    protected void setupDefaults(Connection con, String username) throws SQLException {
        Integer userMax;
        Boolean userMax2;
        Boolean userMax3;
        Boolean defaultAutoCommit = this.isDefaultAutoCommit();
        if (username != null && (userMax3 = this.getPerUserDefaultAutoCommit(username)) != null) {
            defaultAutoCommit = userMax3;
        }
        Boolean defaultReadOnly = this.isDefaultReadOnly();
        if (username != null && (userMax2 = this.getPerUserDefaultReadOnly(username)) != null) {
            defaultReadOnly = userMax2;
        }
        int defaultTransactionIsolation = this.getDefaultTransactionIsolation();
        if (username != null && (userMax = this.getPerUserDefaultTransactionIsolation(username)) != null) {
            defaultTransactionIsolation = userMax;
        }
        if (defaultAutoCommit != null && con.getAutoCommit() != defaultAutoCommit.booleanValue()) {
            con.setAutoCommit(defaultAutoCommit);
        }
        if (defaultTransactionIsolation != -1) {
            con.setTransactionIsolation(defaultTransactionIsolation);
        }
        if (defaultReadOnly != null && con.isReadOnly() != defaultReadOnly.booleanValue()) {
            con.setReadOnly(defaultReadOnly);
        }
    }

    @Override
    protected PooledConnectionManager getConnectionManager(UserPassKey upkey) {
        return this.managers.get(this.getPoolKey(upkey.getUsername()));
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), PerUserPoolDataSourceFactory.class.getName(), null);
        ref.add(new StringRefAddr("instanceKey", this.getInstanceKey()));
        return ref;
    }

    private PoolKey getPoolKey(String username) {
        return new PoolKey(this.getDataSourceName(), username);
    }

    private synchronized void registerPool(String username, String password) throws NamingException, SQLException {
        ConnectionPoolDataSource cpds = this.testCPDS(username, password);
        CPDSConnectionFactory factory = new CPDSConnectionFactory(cpds, this.getValidationQuery(), this.getValidationQueryTimeout(), this.isRollbackAfterValidation(), username, password);
        factory.setMaxConnLifetimeMillis(this.getMaxConnLifetimeMillis());
        GenericObjectPool<PooledConnectionAndInfo> pool = new GenericObjectPool<PooledConnectionAndInfo>(factory);
        factory.setPool(pool);
        pool.setBlockWhenExhausted(this.getPerUserBlockWhenExhausted(username));
        pool.setEvictionPolicyClassName(this.getPerUserEvictionPolicyClassName(username));
        pool.setLifo(this.getPerUserLifo(username));
        pool.setMaxIdle(this.getPerUserMaxIdle(username));
        pool.setMaxTotal(this.getPerUserMaxTotal(username));
        pool.setMaxWaitMillis(this.getPerUserMaxWaitMillis(username));
        pool.setMinEvictableIdleTimeMillis(this.getPerUserMinEvictableIdleTimeMillis(username));
        pool.setMinIdle(this.getPerUserMinIdle(username));
        pool.setNumTestsPerEvictionRun(this.getPerUserNumTestsPerEvictionRun(username));
        pool.setSoftMinEvictableIdleTimeMillis(this.getPerUserSoftMinEvictableIdleTimeMillis(username));
        pool.setTestOnCreate(this.getPerUserTestOnCreate(username));
        pool.setTestOnBorrow(this.getPerUserTestOnBorrow(username));
        pool.setTestOnReturn(this.getPerUserTestOnReturn(username));
        pool.setTestWhileIdle(this.getPerUserTestWhileIdle(username));
        pool.setTimeBetweenEvictionRunsMillis(this.getPerUserTimeBetweenEvictionRunsMillis(username));
        pool.setSwallowedExceptionListener(new SwallowedExceptionLogger(log));
        PooledConnectionManager old = this.managers.put(this.getPoolKey(username), factory);
        if (old != null) {
            throw new IllegalStateException("Pool already contains an entry for this user/password: " + username);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
            PerUserPoolDataSource oldDS = (PerUserPoolDataSource)new PerUserPoolDataSourceFactory().getObjectInstance((Object)this.getReference(), (Name)null, (Context)null, (Hashtable)null);
            this.managers = oldDS.managers;
        }
        catch (NamingException e) {
            throw new IOException("NamingException: " + e);
        }
    }

    private ObjectPool<PooledConnectionAndInfo> getPool(PoolKey key) {
        CPDSConnectionFactory mgr = (CPDSConnectionFactory)this.managers.get(key);
        return mgr == null ? null : mgr.getPool();
    }
}

