/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter.nbformat;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.jupyter.nbformat.Output;
import org.apache.zeppelin.jupyter.types.ZeppelinOutputType;
import org.apache.zeppelin.jupyter.zformat.TypeData;

public class Error
extends Output {
    @SerializedName(value="ename")
    private String ename;
    @SerializedName(value="evalue")
    private String evalue;
    @SerializedName(value="traceback")
    private List<String> traceback;

    public String getEname() {
        return this.ename;
    }

    public String getEvalue() {
        return this.evalue;
    }

    public List<String> getTraceback() {
        return this.traceback;
    }

    @Override
    public ZeppelinOutputType getTypeOfZeppelin() {
        return ZeppelinOutputType.TEXT;
    }

    @Override
    public TypeData toZeppelinResult() {
        List<String> text = Error.verifyEndOfLine(Arrays.asList(this.getEname(), this.getEvalue()));
        String result = StringUtils.join(text, (String)"");
        return new TypeData(this.getTypeOfZeppelin().toString(), result);
    }
}

