/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.websocket.Extension;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.eclipse.jetty.websocket.jsr356.JsrExtension;
import org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.eclipse.jetty.websocket.jsr356.server.BasicServerEndpointConfig;
import org.eclipse.jetty.websocket.jsr356.server.JsrHandshakeRequest;
import org.eclipse.jetty.websocket.jsr356.server.JsrHandshakeResponse;
import org.eclipse.jetty.websocket.jsr356.server.PathParamServerEndpointConfig;
import org.eclipse.jetty.websocket.jsr356.server.ServerEndpointMetadata;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;

public class JsrCreator
implements WebSocketCreator {
    public static final String PROP_REMOTE_ADDRESS = "javax.websocket.endpoint.remoteAddress";
    public static final String PROP_LOCAL_ADDRESS = "javax.websocket.endpoint.localAddress";
    public static final String PROP_LOCALES = "javax.websocket.upgrade.locales";
    private static final Logger LOG = Log.getLogger(JsrCreator.class);
    private final WebSocketContainerScope containerScope;
    private final ServerEndpointMetadata metadata;
    private final ExtensionFactory extensionFactory;

    public JsrCreator(WebSocketContainerScope containerScope, ServerEndpointMetadata metadata, ExtensionFactory extensionFactory) {
        this.containerScope = containerScope;
        this.metadata = metadata;
        this.extensionFactory = extensionFactory;
    }

    @Override
    public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
        List<String> requested;
        JsrHandshakeRequest jsrHandshakeRequest = new JsrHandshakeRequest(req);
        JsrHandshakeResponse jsrHandshakeResponse = new JsrHandshakeResponse(resp);
        ServerEndpointConfig config = this.metadata.getConfig();
        config = new BasicServerEndpointConfig(this.containerScope, config);
        Map<String, Object> userProperties = config.getUserProperties();
        userProperties.put(PROP_LOCAL_ADDRESS, req.getLocalSocketAddress());
        userProperties.put(PROP_REMOTE_ADDRESS, req.getRemoteSocketAddress());
        userProperties.put(PROP_LOCALES, Collections.list(req.getLocales()));
        ServerEndpointConfig.Configurator configurator = config.getConfigurator();
        if (!configurator.checkOrigin(req.getOrigin())) {
            block14: {
                try {
                    resp.sendForbidden("Origin mismatch");
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block14;
                    LOG.debug("Unable to send error response", e);
                }
            }
            return null;
        }
        List<String> supported = config.getSubprotocols();
        String subprotocol = configurator.getNegotiatedSubprotocol(supported, requested = req.getSubProtocols());
        if (StringUtil.isNotBlank(subprotocol)) {
            resp.setAcceptedSubProtocol(subprotocol);
        }
        ArrayList<Extension> installedExtensions = new ArrayList<Extension>();
        for (String string : this.extensionFactory.getAvailableExtensions().keySet()) {
            installedExtensions.add(new JsrExtension(string));
        }
        ArrayList<Extension> requestedExts = new ArrayList<Extension>();
        for (ExtensionConfig reqCfg : req.getExtensions()) {
            requestedExts.add(new JsrExtension(reqCfg));
        }
        List<Extension> list = configurator.getNegotiatedExtensions(installedExtensions, requestedExts);
        ArrayList<ExtensionConfig> configs = new ArrayList<ExtensionConfig>();
        if (list != null) {
            for (Extension used : list) {
                ExtensionConfig ecfg = new ExtensionConfig(used.getName());
                for (Extension.Parameter param : used.getParameters()) {
                    ecfg.setParameter(param.getName(), param.getValue());
                }
                configs.add(ecfg);
            }
        }
        resp.setExtensions(configs);
        PathSpec pathSpec = jsrHandshakeRequest.getRequestPathSpec();
        if (pathSpec instanceof UriTemplatePathSpec) {
            UriTemplatePathSpec wspathSpec = (UriTemplatePathSpec)pathSpec;
            String requestPath = req.getRequestPath();
            config = new PathParamServerEndpointConfig(this.containerScope, config, wspathSpec, requestPath);
        } else {
            Map<String, String> pathParams = jsrHandshakeRequest.getPathParams();
            if (pathParams != null) {
                config = new PathParamServerEndpointConfig(this.containerScope, config, pathParams);
            }
        }
        configurator.modifyHandshake(config, jsrHandshakeRequest, jsrHandshakeResponse);
        try {
            Class<?> endpointClass = config.getEndpointClass();
            Object endpoint = config.getConfigurator().getEndpointInstance(endpointClass);
            return new EndpointInstance(endpoint, config, this.metadata);
        }
        catch (InstantiationException e) {
            LOG.warn("Unable to create websocket: " + config.getEndpointClass().getName(), e);
            return null;
        }
    }

    public String toString() {
        return String.format("%s[metadata=%s]", this.getClass().getName(), this.metadata);
    }
}

