/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.submarine.hadoop;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnClient {
    private Logger LOGGER = LoggerFactory.getLogger(YarnClient.class);
    private Configuration hadoopConf = new Configuration();
    private String yarnWebHttpAddr;
    private String principal = "";
    private String keytab = "";
    public static final String YARN_REST_APPATTEMPTS = "appAttempts";
    public static final String YARN_REST_CONTAINER = "container";
    public static final String YARN_REST_APPATTEMPT = "appAttempt";
    public static final String YARN_REST_APPATTEMPTID = "appAttemptId";
    public static final String YARN_REST_EXPOSEDPORTS = "EXPOSEDPORTS";
    public static final String CONTAINER_IP = "CONTAINER_IP";
    public static final String CONTAINER_PORT = "CONTAINER_PORT";
    public static final String HOST_IP = "HOST_IP";
    public static final String HOST_PORT = "HOST_PORT";
    String SERVICE_PATH = "/services/{service_name}";
    private boolean hadoopSecurityEnabled = true;

    public YarnClient(Properties properties) {
        String hadoopAuthType = properties.getProperty("zeppelin.submarine.auth.type", "kerberos");
        if (StringUtils.equals(hadoopAuthType, "simple")) {
            this.hadoopSecurityEnabled = false;
        }
        this.yarnWebHttpAddr = properties.getProperty("yarn.webapp.http.address", "");
        boolean isSecurityEnabled = UserGroupInformation.isSecurityEnabled();
        if (isSecurityEnabled || this.hadoopSecurityEnabled) {
            String krb5conf = properties.getProperty("submarine.hadoop.krb5.conf", "");
            if (StringUtils.isEmpty(krb5conf)) {
                krb5conf = "/etc/krb5.conf";
                System.setProperty("java.security.krb5.conf", krb5conf);
            }
            String keytab = properties.getProperty("SUBMARINE_HADOOP_KEYTAB", "");
            String principal = properties.getProperty("SUBMARINE_HADOOP_PRINCIPAL", "");
            ZeppelinConfiguration zConf = ZeppelinConfiguration.create();
            if (StringUtils.isEmpty(keytab)) {
                keytab = zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_KERBEROS_KEYTAB);
            }
            if (StringUtils.isEmpty(principal)) {
                principal = zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_KERBEROS_PRINCIPAL);
            }
            if (StringUtils.isBlank(keytab) || StringUtils.isBlank(principal)) {
                throw new RuntimeException("keytab and principal can not be empty, keytab: " + keytab + ", principal: " + principal);
            }
            this.principal = principal;
            this.keytab = keytab;
            if (this.LOGGER.isDebugEnabled()) {
                System.setProperty("sun.security.spnego.debug", "true");
                System.setProperty("sun.security.krb5.debug", "true");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteService(String serviceName) {
        String appUrl = this.yarnWebHttpAddr + "/app/v1/services/" + serviceName + "?_=" + System.currentTimeMillis();
        InputStream inputStream = null;
        try {
            HttpResponse response = this.callRestUrl(appUrl, this.principal, HTTP.DELETE);
            inputStream = response.getEntity().getContent();
            String result = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining(System.lineSeparator()));
            if (response.getStatusLine().getStatusCode() != 200) {
                this.LOGGER.warn("Status code " + response.getStatusLine().getStatusCode());
                this.LOGGER.warn("message is :" + Arrays.deepToString(response.getAllHeaders()));
                this.LOGGER.warn("result\uff1a\n" + result);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                this.LOGGER.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getAppServices(String appIdOrName) {
        Map<String, Object> mapStatus = new HashMap<String, Object>();
        String appUrl = this.yarnWebHttpAddr + "/app/v1/services/" + appIdOrName + "?_=" + System.currentTimeMillis();
        InputStream inputStream = null;
        try {
            HttpResponse response = this.callRestUrl(appUrl, this.principal, HTTP.GET);
            inputStream = response.getEntity().getContent();
            String result = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining(System.lineSeparator()));
            if (response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 404) {
                this.LOGGER.warn("Status code " + response.getStatusLine().getStatusCode());
                this.LOGGER.warn("message is :" + Arrays.deepToString(response.getAllHeaders()));
                this.LOGGER.warn("result\uff1a\n" + result);
            }
            mapStatus = this.parseAppServices(result);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                this.LOGGER.error(e.getMessage(), e);
            }
        }
        return mapStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getClusterApps(String appId) {
        Map<String, Object> appAttempts = new HashMap<String, Object>();
        String appUrl = this.yarnWebHttpAddr + "/ws/v1/cluster/apps/" + appId + "?_=" + System.currentTimeMillis();
        InputStream inputStream = null;
        try {
            HttpResponse response = this.callRestUrl(appUrl, this.principal, HTTP.GET);
            inputStream = response.getEntity().getContent();
            String result = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining(System.lineSeparator()));
            if (response.getStatusLine().getStatusCode() != 200) {
                this.LOGGER.warn("Status code " + response.getStatusLine().getStatusCode());
                this.LOGGER.warn("message is :" + Arrays.deepToString(response.getAllHeaders()));
                this.LOGGER.warn("result\uff1a\n" + result);
            }
            Map<String, Object> map = appAttempts = this.parseClusterApps(result);
            return map;
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                this.LOGGER.error(e.getMessage(), e);
            }
        }
        return appAttempts;
    }

    public Map<String, Object> parseClusterApps(String jsonContent) {
        HashMap<String, Object> appAttempts = new HashMap<String, Object>();
        try {
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(jsonContent);
            JsonObject jsonAppAttempts = jsonObject.get("app").getAsJsonObject();
            if (null == jsonAppAttempts) {
                return appAttempts;
            }
            for (Map.Entry<String, JsonElement> entry : jsonAppAttempts.entrySet()) {
                String key = entry.getKey();
                if (null == entry.getValue() || !(entry.getValue() instanceof JsonPrimitive)) continue;
                String value = entry.getValue().getAsString();
                appAttempts.put(key, value);
            }
        }
        catch (JsonIOException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
        catch (JsonSyntaxException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
        return appAttempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getAppAttempts(String appId) {
        List<Map<String, Object>> appAttempts = new ArrayList<Map<String, Object>>();
        String appUrl = this.yarnWebHttpAddr + "/ws/v1/cluster/apps/" + appId + "/appattempts?_=" + System.currentTimeMillis();
        InputStream inputStream = null;
        try {
            HttpResponse response = this.callRestUrl(appUrl, this.principal, HTTP.GET);
            inputStream = response.getEntity().getContent();
            String result = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining(System.lineSeparator()));
            if (response.getStatusLine().getStatusCode() != 200) {
                this.LOGGER.warn("Status code " + response.getStatusLine().getStatusCode());
                this.LOGGER.warn("message is :" + Arrays.deepToString(response.getAllHeaders()));
                this.LOGGER.warn("result\uff1a\n" + result);
            }
            appAttempts = this.parseAppAttempts(result);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                this.LOGGER.error(e.getMessage(), e);
            }
        }
        return appAttempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getAppAttemptsContainers(String appId, String appAttemptId) {
        List<Map<String, Object>> appAttemptsContainers = new ArrayList<Map<String, Object>>();
        String appUrl = this.yarnWebHttpAddr + "/ws/v1/cluster/apps/" + appId + "/appattempts/" + appAttemptId + "/containers?_=" + System.currentTimeMillis();
        InputStream inputStream = null;
        try {
            HttpResponse response = this.callRestUrl(appUrl, this.principal, HTTP.GET);
            inputStream = response.getEntity().getContent();
            String result = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining(System.lineSeparator()));
            if (response.getStatusLine().getStatusCode() != 200) {
                this.LOGGER.warn("Status code " + response.getStatusLine().getStatusCode());
                this.LOGGER.warn("message is :" + Arrays.deepToString(response.getAllHeaders()));
                this.LOGGER.warn("result\uff1a\n" + result);
            }
            appAttemptsContainers = this.parseAppAttemptsContainers(result);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                this.LOGGER.error(e.getMessage(), e);
            }
        }
        return appAttemptsContainers;
    }

    public List<Map<String, Object>> getAppAttemptsContainersExportPorts(String appId) {
        ArrayList<Map<String, Object>> listExportPorts = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> listAppAttempts = this.getAppAttempts(appId);
        for (Map<String, Object> mapAppAttempts : listAppAttempts) {
            String appAttemptId;
            List<Map<String, Object>> exportPorts;
            if (!mapAppAttempts.containsKey(YARN_REST_APPATTEMPTID) || (exportPorts = this.getAppAttemptsContainers(appId, appAttemptId = (String)mapAppAttempts.get(YARN_REST_APPATTEMPTID))).size() <= 0) continue;
            listExportPorts.addAll(exportPorts);
        }
        return listExportPorts;
    }

    private static HttpClient buildSpengoHttpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        Registry authSchemeRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true)).build();
        builder.setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(null, -1, null), new Credentials(){

            public Principal getUserPrincipal() {
                return null;
            }

            public String getPassword() {
                return null;
            }
        });
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").build();
        builder.setDefaultRequestConfig(globalConfig);
        CloseableHttpClient httpClient = builder.build();
        return httpClient;
    }

    public HttpResponse callRestUrl(final String url, String userId, final HTTP operation) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug(String.format("Calling YarnClient %s %s %s", this.principal, this.keytab, url));
        }
        javax.security.auth.login.Configuration config = new javax.security.auth.login.Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap<String, Object>(){
                    {
                        this.put("useTicketCache", "false");
                        this.put("useKeyTab", "true");
                        this.put("keyTab", YarnClient.this.keytab);
                        this.put("refreshKrb5Config", "true");
                        this.put("principal", YarnClient.this.principal);
                        this.put("storeKey", "true");
                        this.put("doNotPrompt", "true");
                        this.put("isInitiator", "true");
                        if (YarnClient.this.LOGGER.isDebugEnabled()) {
                            this.put("debug", "true");
                        }
                    }
                })};
            }
        };
        HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>(1);
        principals.add(new KerberosPrincipal(userId));
        Subject sub = new Subject(false, principals, new HashSet(), new HashSet());
        try {
            LoginContext loginContext = new LoginContext("Krb5Login", sub, null, config);
            loginContext.login();
            Subject serviceSubject = loginContext.getSubject();
            return Subject.doAs(serviceSubject, new PrivilegedAction<HttpResponse>(){
                HttpResponse httpResponse = null;

                @Override
                public HttpResponse run() {
                    try {
                        HttpDelete request = null;
                        switch (operation) {
                            case DELETE: {
                                request = new HttpDelete(url);
                                break;
                            }
                            case POST: {
                                request = new HttpPost(url);
                                break;
                            }
                            default: {
                                request = new HttpGet(url);
                            }
                        }
                        HttpClient spengoClient = YarnClient.buildSpengoHttpClient();
                        this.httpResponse = spengoClient.execute((HttpUriRequest)request);
                        return this.httpResponse;
                    }
                    catch (IOException e) {
                        YarnClient.this.LOGGER.error(e.getMessage(), e);
                        return this.httpResponse;
                    }
                }
            });
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), e);
            return null;
        }
    }

    private Map<String, Object> parseAppServices(String appJson) {
        HashMap<String, Object> mapStatus = new HashMap<String, Object>();
        try {
            String appName;
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(appJson);
            JsonElement elementAppId = jsonObject.get("id");
            JsonElement elementAppState = jsonObject.get("state");
            JsonElement elementAppName = jsonObject.get("name");
            String appId = elementAppId == null ? "" : elementAppId.getAsString();
            String appState = elementAppState == null ? "" : elementAppState.getAsString();
            String string = appName = elementAppName == null ? "" : elementAppName.getAsString();
            if (!StringUtils.isEmpty(appId)) {
                mapStatus.put("YARN_APPLICATION_ID", appId);
            }
            if (!StringUtils.isEmpty(appName)) {
                mapStatus.put("YARN_APPLICATION_NAME", appName);
            }
            if (!StringUtils.isEmpty(appState)) {
                mapStatus.put("YARN_APPLICATION_STATUS", appState);
            }
        }
        catch (JsonIOException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
        catch (JsonSyntaxException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
        return mapStatus;
    }

    public List<Map<String, Object>> parseAppAttempts(String jsonContent) {
        ArrayList<Map<String, Object>> appAttempts = new ArrayList<Map<String, Object>>();
        try {
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(jsonContent);
            JsonObject jsonAppAttempts = jsonObject.get(YARN_REST_APPATTEMPTS).getAsJsonObject();
            if (null == jsonAppAttempts) {
                return appAttempts;
            }
            JsonArray jsonAppAttempt = jsonAppAttempts.get(YARN_REST_APPATTEMPT).getAsJsonArray();
            if (null == jsonAppAttempt) {
                return appAttempts;
            }
            for (int i = 0; i < jsonAppAttempt.size(); ++i) {
                HashMap<String, String> mapAppAttempt = new HashMap<String, String>();
                JsonObject jsonParagraph = jsonAppAttempt.get(i).getAsJsonObject();
                JsonElement jsonElement = jsonParagraph.get("id");
                String id = jsonElement == null ? "" : jsonElement.getAsString();
                mapAppAttempt.put("id", id);
                jsonElement = jsonParagraph.get(YARN_REST_APPATTEMPTID);
                String appAttemptId = jsonElement == null ? "" : jsonElement.getAsString();
                mapAppAttempt.put(YARN_REST_APPATTEMPTID, appAttemptId);
                appAttempts.add(mapAppAttempt);
            }
        }
        catch (JsonIOException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
        catch (JsonSyntaxException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
        return appAttempts;
    }

    public List<Map<String, Object>> parseAppAttemptsContainers(String jsonContent) {
        ArrayList<Map<String, Object>> appContainers = new ArrayList<Map<String, Object>>();
        try {
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(jsonContent);
            JsonArray jsonContainers = jsonObject.get(YARN_REST_CONTAINER).getAsJsonArray();
            for (int i = 0; i < jsonContainers.size(); ++i) {
                String exposedPorts;
                Gson gson;
                Map listExposedPorts;
                String hostIp = "";
                JsonObject jsonContainer = jsonContainers.get(i).getAsJsonObject();
                JsonElement jsonElement = jsonContainer.get("nodeId");
                String nodeId = jsonElement == null ? "" : jsonElement.getAsString();
                String[] nodeIdParts = nodeId.split(":");
                if (nodeIdParts.length == 2) {
                    hostIp = nodeIdParts[0];
                }
                if (null == (listExposedPorts = (Map)(gson = new Gson()).fromJson(exposedPorts = (jsonElement = jsonContainer.get("exposedPorts")) == null ? "" : jsonElement.getAsString(), new TypeToken<Map<String, List<Map<String, String>>>>(){}.getType()))) continue;
                for (Map.Entry entry : listExposedPorts.entrySet()) {
                    String containerPort = (String)entry.getKey();
                    String[] containerPortParts = containerPort.split("/");
                    if (containerPortParts.length != 2) continue;
                    List hostIps = (List)entry.getValue();
                    for (Map hostAttrib : hostIps) {
                        HashMap<String, String> containerExposedPort = new HashMap<String, String>();
                        String hostPort = (String)hostAttrib.get("HostPort");
                        containerExposedPort.put(HOST_IP, hostIp);
                        containerExposedPort.put(HOST_PORT, hostPort);
                        containerExposedPort.put(CONTAINER_PORT, containerPortParts[0]);
                        appContainers.add(containerExposedPort);
                    }
                }
            }
        }
        catch (JsonIOException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
        catch (JsonSyntaxException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
        return appContainers;
    }

    public List<Map<String, Object>> getAppExportPorts(String name) {
        Map<String, Object> mapAppStatus = this.getAppServices(name);
        if (mapAppStatus.containsKey("YARN_APPLICATION_ID") && mapAppStatus.containsKey("YARN_APPLICATION_NAME") && mapAppStatus.containsKey("YARN_APPLICATION_STATUS")) {
            String appId = mapAppStatus.get("YARN_APPLICATION_ID").toString();
            String appStatus = mapAppStatus.get("YARN_APPLICATION_STATUS").toString();
            List<Map<String, Object>> mapAppAttempts = this.getAppAttemptsContainersExportPorts(appId);
            return mapAppAttempts;
        }
        return new ArrayList<Map<String, Object>>(){};
    }

    public static enum HTTP {
        GET,
        POST,
        DELETE;

    }
}

