/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import com.google.common.collect.Lists;
import com.pty4j.WinSize;
import com.pty4j.unix.NativePtyExecutor;
import com.pty4j.unix.PtyExecutor;
import com.pty4j.unix.freebsd.OSFacadeImpl;
import com.pty4j.util.LazyValue;
import com.pty4j.util.PtyUtil;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import jtermios.JTermios;
import jtermios.Termios;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PtyHelpers {
    private static final Logger LOG = Logger.getLogger(PtyHelpers.class);
    public static int ONLCR = 4;
    public static int VINTR = 0;
    public static int VQUIT = 1;
    public static int VERASE = 2;
    public static int VKILL = 3;
    public static int VSUSP = 10;
    public static int VREPRINT = 12;
    public static int VWERASE = 14;
    public static int ECHOCTL = 4096;
    public static int ECHOKE = 16384;
    public static int ECHOK = 4;
    public static int IMAXBEL = 8192;
    public static int HUPCL = 16384;
    public static int IUTF8 = 16384;
    private static final int STDIN_FILENO = 0;
    private static final int STDOUT_FILENO = 1;
    private static final int STDERR_FILENO = 2;
    private static final int SIG_UNBLOCK = 2;
    public static int SIGHUP = 1;
    public static int SIGINT = 2;
    public static int SIGQUIT = 3;
    public static int SIGILL = 4;
    public static int SIGABORT = 6;
    public static int SIGFPE = 8;
    public static int SIGKILL = 9;
    public static int SIGSEGV = 11;
    public static int SIGPIPE = 13;
    public static int SIGALRM = 14;
    public static int SIGTERM = 15;
    public static int SIGCHLD = 20;
    public static int WNOHANG = 1;
    public static int WUNTRACED = 2;
    private static final LazyValue<OSFacade> OS_FACADE_VALUE = new LazyValue<OSFacade>(new Callable<OSFacade>(){

        @Override
        public OSFacade call() {
            if (Platform.isMac()) {
                return new com.pty4j.unix.macosx.OSFacadeImpl();
            }
            if (Platform.isFreeBSD()) {
                return new OSFacadeImpl();
            }
            if (Platform.isOpenBSD()) {
                return new com.pty4j.unix.openbsd.OSFacadeImpl();
            }
            if (Platform.isLinux() || Platform.isAndroid()) {
                return new com.pty4j.unix.linux.OSFacadeImpl();
            }
            if (Platform.isWindows()) {
                throw new IllegalArgumentException("WinPtyProcess should be used on Windows");
            }
            throw new RuntimeException("Pty4J has no support for OS " + System.getProperty("os.name"));
        }
    });
    private static final LazyValue<PtyExecutor> PTY_EXECUTOR_VALUE = new LazyValue<PtyExecutor>(new Callable<PtyExecutor>(){

        @Override
        public PtyExecutor call() throws Exception {
            File lib = PtyUtil.resolveNativeLibrary();
            return new NativePtyExecutor(lib.getAbsolutePath());
        }
    });

    @NotNull
    private static OSFacade getOsFacade() {
        try {
            return OS_FACADE_VALUE.getValue();
        }
        catch (Throwable t2) {
            throw new RuntimeException("Cannot load implementation of " + OSFacade.class, t2);
        }
    }

    @NotNull
    private static PtyExecutor getPtyExecutor() {
        try {
            return PTY_EXECUTOR_VALUE.getValue();
        }
        catch (Throwable t2) {
            throw new RuntimeException("Cannot load native pty executor library", t2);
        }
    }

    public static OSFacade getInstance() {
        return PtyHelpers.getOsFacade();
    }

    public static Termios createTermios() {
        Termios term = new Termios();
        boolean isUTF8 = true;
        term.c_iflag = JTermios.ICRNL | JTermios.IXON | JTermios.IXANY | IMAXBEL | JTermios.BRKINT | (isUTF8 ? IUTF8 : 0);
        term.c_oflag = JTermios.OPOST | ONLCR;
        term.c_cflag = JTermios.CREAD | JTermios.CS8 | HUPCL;
        term.c_lflag = JTermios.ICANON | JTermios.ISIG | JTermios.IEXTEN | JTermios.ECHO | JTermios.ECHOE | ECHOK | ECHOKE | ECHOCTL;
        term.c_cc[JTermios.VEOF] = PtyHelpers.CTRLKEY('D');
        term.c_cc[PtyHelpers.VERASE] = 127;
        term.c_cc[PtyHelpers.VWERASE] = PtyHelpers.CTRLKEY('W');
        term.c_cc[PtyHelpers.VKILL] = PtyHelpers.CTRLKEY('U');
        term.c_cc[PtyHelpers.VREPRINT] = PtyHelpers.CTRLKEY('R');
        term.c_cc[PtyHelpers.VINTR] = PtyHelpers.CTRLKEY('C');
        term.c_cc[PtyHelpers.VQUIT] = 28;
        term.c_cc[PtyHelpers.VSUSP] = PtyHelpers.CTRLKEY('Z');
        term.c_cc[JTermios.VSTART] = PtyHelpers.CTRLKEY('Q');
        term.c_cc[JTermios.VSTOP] = PtyHelpers.CTRLKEY('S');
        term.c_ispeed = JTermios.B38400;
        term.c_ospeed = JTermios.B38400;
        return term;
    }

    private static byte CTRLKEY(char c) {
        return (byte)((byte)c - 65 + 1);
    }

    private static int __sigbits(int __signo) {
        return __signo > 32 ? 0 : 1 << __signo - 1;
    }

    public static int getWinSize(int fd, WinSize ws) {
        return PtyHelpers.getOsFacade().getWinSize(fd, ws);
    }

    public static boolean isProcessAlive(int pid) {
        int[] stat = new int[]{-1};
        int result = PtyHelpers.waitpid(pid, stat, WNOHANG);
        return result == 0 && stat[0] < 0;
    }

    public static int setWinSize(int fd, WinSize ws) {
        return PtyHelpers.getOsFacade().setWinSize(fd, ws);
    }

    public static int signal(int pid, int signal) {
        return PtyHelpers.getOsFacade().kill(pid, signal);
    }

    public static int waitpid(int pid, int[] stat, int options) {
        return PtyHelpers.getOsFacade().waitpid(pid, stat, options);
    }

    public static int errno() {
        return Native.getLastError();
    }

    public static String strerror() {
        return PtyHelpers.getOsFacade().strerror(PtyHelpers.errno());
    }

    private static int execve(String command, String[] argv, String[] env) {
        return PtyHelpers.getOsFacade().execve(command, argv, env);
    }

    public static void chdir(String dirpath) {
        PtyHelpers.getOsFacade().chdir(dirpath);
    }

    private static String[] processArgv(String command, String[] arguments) {
        String[] argv;
        if (arguments == null) {
            argv = new String[]{command};
        } else if (!command.equals(arguments[0])) {
            argv = new String[arguments.length + 1];
            argv[0] = command;
            System.arraycopy(arguments, 0, argv, 1, arguments.length);
        } else {
            argv = Arrays.copyOf(arguments, arguments.length);
        }
        return argv;
    }

    public static int execPty(String full_path, String[] argv, String[] envp, String dirpath, String pts_name, int fdm, String err_pts_name, int err_fdm, boolean console) {
        PtyExecutor executor = PtyHelpers.getPtyExecutor();
        return executor.execPty(full_path, argv, envp, dirpath, pts_name, fdm, err_pts_name, err_fdm, console);
    }

    static {
        try {
            PtyHelpers.getOsFacade();
        }
        catch (Throwable t2) {
            LOG.error(t2.getMessage(), t2.getCause());
        }
        try {
            PtyHelpers.getPtyExecutor();
        }
        catch (Throwable t3) {
            LOG.error(t3.getMessage(), t3.getCause());
        }
    }

    public static class winsize
    extends Structure {
        public short ws_row;
        public short ws_col;
        public short ws_xpixel;
        public short ws_ypixel;

        protected List getFieldOrder() {
            return Lists.newArrayList("ws_row", "ws_col", "ws_xpixel", "ws_ypixel");
        }

        public winsize() {
        }

        public winsize(WinSize ws) {
            this.ws_row = ws.ws_row;
            this.ws_col = ws.ws_col;
            this.ws_xpixel = ws.ws_xpixel;
            this.ws_ypixel = ws.ws_ypixel;
        }

        public void update(WinSize winSize) {
            winSize.ws_col = this.ws_col;
            winSize.ws_row = this.ws_row;
            winSize.ws_xpixel = this.ws_xpixel;
            winSize.ws_ypixel = this.ws_ypixel;
        }
    }

    public static interface OSFacade {
        public int execve(String var1, String[] var2, String[] var3);

        public int getWinSize(int var1, WinSize var2);

        public int kill(int var1, int var2);

        public int setWinSize(int var1, WinSize var2);

        public int waitpid(int var1, int[] var2, int var3);

        public int sigprocmask(int var1, IntByReference var2, IntByReference var3);

        public String strerror(int var1);

        public int getpt();

        public int grantpt(int var1);

        public int unlockpt(int var1);

        public int close(int var1);

        public String ptsname(int var1);

        public int killpg(int var1, int var2);

        public int fork();

        public int pipe(int[] var1);

        public int setsid();

        public void execv(String var1, String[] var2);

        public int getpid();

        public int setpgid(int var1, int var2);

        public void dup2(int var1, int var2);

        public int getppid();

        public void unsetenv(String var1);

        public int login_tty(int var1);

        public void chdir(String var1);
    }
}

