/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.date;

import com.hubspot.jinjava.objects.date.InvalidDateFormatException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class StrftimeFormatter {
    public static final String DEFAULT_DATE_FORMAT = "%H:%M / %d-%m-%Y";
    private static final String[] CONVERSIONS = new String[255];
    private static final String[] NOMINATIVE_CONVERSIONS = new String[255];

    public static String toJavaDateTimeFormat(String strftime) {
        if (!StringUtils.contains((CharSequence)strftime, 37)) {
            return strftime;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < strftime.length(); ++i) {
            char c = strftime.charAt(i);
            if (c == '%') {
                c = strftime.charAt(++i);
                boolean stripLeadingZero = false;
                String[] conversions = CONVERSIONS;
                if (c == '-') {
                    stripLeadingZero = true;
                    c = strftime.charAt(++i);
                }
                if (c == 'O') {
                    c = strftime.charAt(++i);
                    conversions = NOMINATIVE_CONVERSIONS;
                }
                if (stripLeadingZero) {
                    result.append(conversions[c].substring(1));
                    continue;
                }
                result.append(conversions[c]);
                continue;
            }
            if (Character.isLetter(c)) {
                result.append("'");
                while (Character.isLetter(c)) {
                    result.append(c);
                    if (++i < strftime.length()) {
                        c = strftime.charAt(i);
                        continue;
                    }
                    c = '\u0000';
                }
                result.append("'");
                --i;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static DateTimeFormatter formatter(String strftime) {
        return StrftimeFormatter.formatter(strftime, Locale.ENGLISH);
    }

    public static DateTimeFormatter formatter(String strftime, Locale locale) {
        DateTimeFormatter fmt;
        if (strftime == null) {
            strftime = "";
        }
        switch (strftime.toLowerCase()) {
            case "short": {
                fmt = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT);
                break;
            }
            case "medium": {
                fmt = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM);
                break;
            }
            case "long": {
                fmt = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG);
                break;
            }
            case "full": {
                fmt = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL);
                break;
            }
            default: {
                try {
                    fmt = DateTimeFormatter.ofPattern(StrftimeFormatter.toJavaDateTimeFormat(strftime));
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidDateFormatException(strftime, e);
                }
            }
        }
        return fmt.withLocale(locale);
    }

    public static String format(ZonedDateTime d) {
        return StrftimeFormatter.format(d, DEFAULT_DATE_FORMAT);
    }

    public static String format(ZonedDateTime d, Locale locale) {
        return StrftimeFormatter.format(d, DEFAULT_DATE_FORMAT, locale);
    }

    public static String format(ZonedDateTime d, String strftime) {
        return StrftimeFormatter.format(d, strftime, Locale.ENGLISH);
    }

    public static String format(ZonedDateTime d, String strftime, Locale locale) {
        return StrftimeFormatter.formatter(strftime, locale).format(d);
    }

    static {
        StrftimeFormatter.CONVERSIONS[97] = "EEE";
        StrftimeFormatter.CONVERSIONS[65] = "EEEE";
        StrftimeFormatter.CONVERSIONS[98] = "MMM";
        StrftimeFormatter.CONVERSIONS[66] = "MMMM";
        StrftimeFormatter.CONVERSIONS[99] = "EEE MMM dd HH:mm:ss yyyy";
        StrftimeFormatter.CONVERSIONS[100] = "dd";
        StrftimeFormatter.CONVERSIONS[101] = "d";
        StrftimeFormatter.CONVERSIONS[102] = "SSSSSS";
        StrftimeFormatter.CONVERSIONS[72] = "HH";
        StrftimeFormatter.CONVERSIONS[104] = "hh";
        StrftimeFormatter.CONVERSIONS[73] = "hh";
        StrftimeFormatter.CONVERSIONS[106] = "DDD";
        StrftimeFormatter.CONVERSIONS[107] = "H";
        StrftimeFormatter.CONVERSIONS[108] = "h";
        StrftimeFormatter.CONVERSIONS[109] = "MM";
        StrftimeFormatter.CONVERSIONS[77] = "mm";
        StrftimeFormatter.CONVERSIONS[112] = "a";
        StrftimeFormatter.CONVERSIONS[83] = "ss";
        StrftimeFormatter.CONVERSIONS[85] = "ww";
        StrftimeFormatter.CONVERSIONS[119] = "e";
        StrftimeFormatter.CONVERSIONS[87] = "ww";
        StrftimeFormatter.CONVERSIONS[120] = "MM/dd/yy";
        StrftimeFormatter.CONVERSIONS[88] = "HH:mm:ss";
        StrftimeFormatter.CONVERSIONS[121] = "yy";
        StrftimeFormatter.CONVERSIONS[89] = "yyyy";
        StrftimeFormatter.CONVERSIONS[122] = "Z";
        StrftimeFormatter.CONVERSIONS[90] = "ZZZZ";
        StrftimeFormatter.CONVERSIONS[37] = "%";
        StrftimeFormatter.NOMINATIVE_CONVERSIONS[66] = "LLLL";
    }
}

