/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.fn;

import com.google.common.base.Throwables;
import com.hubspot.jinjava.lib.Importable;
import java.lang.reflect.Method;

public class ELFunctionDefinition
implements Importable {
    private String namespace;
    private String localName;
    private Method method;

    public ELFunctionDefinition(String namespace, String localName, Class<?> methodClass, String methodName, Class<?> ... parameterTypes) {
        this.namespace = namespace;
        this.localName = localName;
        this.method = ELFunctionDefinition.resolveMethod(methodClass, methodName, parameterTypes);
    }

    private static Method resolveMethod(Class<?> methodClass, String methodName, Class<?> ... parameterTypes) {
        try {
            Method m4 = methodClass.getDeclaredMethod(methodName, parameterTypes);
            m4.setAccessible(true);
            return m4;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public ELFunctionDefinition(String namespace, String localName, Method method) {
        this.namespace = namespace;
        this.localName = localName;
        this.method = method;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getName() {
        return this.namespace + ":" + this.localName;
    }

    public Method getMethod() {
        return this.method;
    }
}

