/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.datetime.markup.html.form;

import java.util.Date;
import org.apache.wicket.datetime.DateConverter;
import org.apache.wicket.datetime.PatternDateConverter;
import org.apache.wicket.datetime.StyleDateConverter;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.Args;

public class DateTextField
extends TextField<Date>
implements AbstractTextComponent.ITextFormatProvider {
    private static final long serialVersionUID = 1L;
    private final DateConverter converter;

    public static DateTextField forDatePattern(String id, IModel<Date> model, String datePattern) {
        return new DateTextField(id, model, new PatternDateConverter(datePattern, true));
    }

    public static DateTextField forDatePattern(String id, String datePattern) {
        return DateTextField.forDatePattern(id, null, datePattern);
    }

    public static DateTextField forDateStyle(String id, IModel<Date> model, String dateStyle) {
        return new DateTextField(id, model, new StyleDateConverter(dateStyle, true));
    }

    public static DateTextField forDateStyle(String id, String dateStyle) {
        return DateTextField.forDateStyle(id, null, dateStyle);
    }

    public static DateTextField forShortStyle(String id) {
        return DateTextField.forShortStyle(id, null, true);
    }

    public static DateTextField forShortStyle(String id, IModel<Date> model, boolean applyTimeZoneDifference) {
        return new DateTextField(id, model, new StyleDateConverter(applyTimeZoneDifference));
    }

    public static DateTextField withConverter(String id, DateConverter converter) {
        return DateTextField.withConverter(id, null, converter);
    }

    public static DateTextField withConverter(String id, IModel<Date> model, DateConverter converter) {
        return new DateTextField(id, model, converter);
    }

    public DateTextField(String id, IModel<Date> model, DateConverter converter) {
        super(id, model, Date.class);
        Args.notNull((Object)converter, (String)"converter");
        this.converter = converter;
    }

    public DateTextField(String id, DateConverter converter) {
        this(id, null, converter);
    }

    protected IConverter<?> createConverter(Class<?> clazz) {
        if (Date.class.isAssignableFrom(clazz)) {
            return this.converter;
        }
        return null;
    }

    public final String getTextFormat() {
        return this.converter.getDatePattern(this.getLocale());
    }
}

