/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.util.Locale;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.ResourceReferenceRegistry;
import org.apache.wicket.request.resource.ResourceStreamResource;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;
import org.apache.wicket.util.template.PackageTextTemplate;
import org.apache.wicket.util.template.TextTemplate;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;

public class TextTemplateResourceReference
extends ResourceReference
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final TextTemplate textTemplate;
    private final IModel<Map<String, Object>> variablesModel;
    private final ResourceStreamResource resource;

    public TextTemplateResourceReference(Class<?> scope, String fileName, IModel<Map<String, Object>> variablesModel) {
        this(scope, fileName, "text", PackageTextTemplate.DEFAULT_ENCODING, variablesModel);
    }

    public TextTemplateResourceReference(Class<?> scope, String fileName, String contentType, IModel<Map<String, Object>> variablesModel) {
        this(scope, fileName, contentType, PackageTextTemplate.DEFAULT_ENCODING, variablesModel);
    }

    public TextTemplateResourceReference(Class<?> scope, String fileName, String contentType, String encoding, IModel<Map<String, Object>> variablesModel) {
        this(scope, fileName, contentType, encoding, variablesModel, null, null, null);
    }

    public TextTemplateResourceReference(Class<?> scope, String fileName, String contentType, String encoding, IModel<Map<String, Object>> variablesModel, Locale locale, String style, String variation) {
        super(scope, fileName, locale, style, variation);
        this.textTemplate = new PackageTextTemplate(scope, fileName, contentType, encoding);
        this.variablesModel = variablesModel;
        this.resource = new ResourceStreamResource(null){

            @Override
            protected IResourceStream getResourceStream() {
                IModel variables = TextTemplateResourceReference.this.variablesModel;
                String stringValue = TextTemplateResourceReference.this.textTemplate.asString((Map)variables.getObject());
                variables.detach();
                StringResourceStream resourceStream = new StringResourceStream((CharSequence)stringValue, TextTemplateResourceReference.this.textTemplate.getContentType());
                resourceStream.setLastModified(Time.now());
                return resourceStream;
            }
        };
        this.resource.setCacheDuration(Duration.NONE);
        if (Application.exists()) {
            ResourceReferenceRegistry resourceReferenceRegistry = Application.get().getResourceReferenceRegistry();
            resourceReferenceRegistry.unregisterResourceReference(this.getKey());
            resourceReferenceRegistry.registerResourceReference(this);
        }
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }
}

