/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html;

import java.util.List;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.AjaxEditableLabel;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.string.Strings;

public class AjaxEditableChoiceLabel<T>
extends AjaxEditableLabel<T> {
    private static final long serialVersionUID = 1L;
    private IModel<? extends List<? extends T>> choices;
    private IChoiceRenderer<? super T> renderer;

    public AjaxEditableChoiceLabel(String id) {
        super(id);
    }

    public AjaxEditableChoiceLabel(String id, IModel<T> model) {
        super(id, model);
    }

    public AjaxEditableChoiceLabel(String id, List<? extends T> choices) {
        this(id, null, choices);
    }

    public AjaxEditableChoiceLabel(String id, IModel<T> model, IModel<? extends List<? extends T>> choices) {
        super(id, model);
        this.choices = choices;
    }

    public AjaxEditableChoiceLabel(String id, IModel<T> model, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model);
        this.choices = choices;
        this.renderer = renderer;
    }

    public AjaxEditableChoiceLabel(String id, IModel<T> model, List<? extends T> choices) {
        this(id, model, Model.ofList(choices));
    }

    public AjaxEditableChoiceLabel(String id, IModel<T> model, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        this(id, model, Model.ofList(choices), renderer);
    }

    @Override
    protected FormComponent<T> newEditor(MarkupContainer parent, String componentId, IModel<T> model) {
        AbstractReadOnlyModel choiceModel = new AbstractReadOnlyModel<List<? extends T>>(){
            private static final long serialVersionUID = 1L;

            public List<? extends T> getObject() {
                return (List)AjaxEditableChoiceLabel.this.choices.getObject();
            }
        };
        DropDownChoice editor = new DropDownChoice<T>(componentId, model, (IModel)choiceModel, this.renderer){
            private static final long serialVersionUID = 1L;

            protected void onModelChanged() {
                AjaxEditableChoiceLabel.this.onModelChanged();
            }

            protected void onModelChanging() {
                AjaxEditableChoiceLabel.this.onModelChanging();
            }
        };
        editor.setOutputMarkupId(true);
        editor.setVisible(false);
        editor.add(new Behavior[]{new AjaxEditableLabel.EditorAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.setEventNames(new String[]{"change", "blur", "keyup"});
                String dynamicExtraParameters = "var result = [], kc=Wicket.Event.keyCode(attrs.event),evtType=attrs.event.type;if (evtType === 'blur' || (evtType === 'keyup' && kc===27)) {  result.push( { name: 'save', value: false } );}else {  result = Wicket.Form.serializeElement(attrs.c);  result.push( { name: 'save', value: true } );}return result;";
                attributes.getDynamicExtraParameters().add(dynamicExtraParameters);
                String precondition = "var kc=Wicket.Event.keyCode(attrs.event),evtType=attrs.event.type,ret=false;if(evtType==='blur' || evtType==='change' || (evtType==='keyup' && kc===27)) ret = true;return ret;";
                AjaxCallListener ajaxCallListener = new AjaxCallListener();
                ajaxCallListener.onPrecondition((CharSequence)precondition);
                attributes.getAjaxCallListeners().add(ajaxCallListener);
            }
        }});
        return editor;
    }

    protected WebComponent newLabel(MarkupContainer parent, String componentId, IModel<T> model) {
        Label label = new Label(componentId, model){
            private static final long serialVersionUID = 1L;

            public <C> IConverter<C> getConverter(Class<C> type) {
                IConverter c = AjaxEditableChoiceLabel.this.getConverter(type);
                return c != null ? c : super.getConverter(type);
            }

            public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
                String displayValue = this.getDefaultModelObjectAsString();
                if (AjaxEditableChoiceLabel.this.renderer != null) {
                    Class<?> objectClass;
                    Object displayObject = AjaxEditableChoiceLabel.this.renderer.getDisplayValue(AjaxEditableChoiceLabel.this.getModelObject());
                    Class<?> clazz = objectClass = displayObject == null ? null : displayObject.getClass();
                    if (objectClass != null && objectClass != String.class) {
                        IConverter<?> converter = this.getConverter(objectClass);
                        displayValue = converter.convertToString(displayObject, this.getLocale());
                    } else if (displayObject != null) {
                        displayValue = displayObject.toString();
                    }
                }
                if (Strings.isEmpty((CharSequence)displayValue)) {
                    this.replaceComponentTagBody(markupStream, openTag, AjaxEditableChoiceLabel.this.defaultNullLabel());
                } else {
                    this.replaceComponentTagBody(markupStream, openTag, displayValue);
                }
            }
        };
        label.setOutputMarkupId(true);
        label.add(new Behavior[]{new AjaxEditableLabel.LabelAjaxBehavior(this, this.getLabelAjaxEvent())});
        return label;
    }

    @Override
    protected void onModelChanged() {
        super.onModelChanged();
    }

    @Override
    protected void onModelChanging() {
        super.onModelChanging();
    }

    protected void onDetach() {
        if (this.choices != null) {
            this.choices.detach();
        }
        super.onDetach();
    }
}

