/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import org.apache.wicket.protocol.ws.api.WebSocketRequestHandler;
import org.apache.wicket.protocol.ws.api.event.WebSocketBinaryPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketClosedPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketConnectedPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketPushPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketTextPayload;
import org.apache.wicket.protocol.ws.api.message.BinaryMessage;
import org.apache.wicket.protocol.ws.api.message.ClosedMessage;
import org.apache.wicket.protocol.ws.api.message.ConnectedMessage;
import org.apache.wicket.protocol.ws.api.message.IWebSocketPushMessage;
import org.apache.wicket.protocol.ws.api.message.TextMessage;
import org.apache.wicket.request.resource.IResource;

public abstract class WebSocketResource
implements IResource {
    void onPayload(WebSocketPayload<?> payload) {
        WebSocketRequestHandler webSocketHandler = payload.getHandler();
        if (payload instanceof WebSocketTextPayload) {
            WebSocketTextPayload textPayload = (WebSocketTextPayload)payload;
            TextMessage data = textPayload.getMessage();
            this.onMessage(webSocketHandler, data);
        } else if (payload instanceof WebSocketBinaryPayload) {
            WebSocketBinaryPayload binaryPayload = (WebSocketBinaryPayload)payload;
            BinaryMessage binaryData = binaryPayload.getMessage();
            this.onMessage(webSocketHandler, binaryData);
        } else if (payload instanceof WebSocketConnectedPayload) {
            WebSocketConnectedPayload connectedPayload = (WebSocketConnectedPayload)payload;
            ConnectedMessage message = connectedPayload.getMessage();
            this.onConnect(message);
        } else if (payload instanceof WebSocketClosedPayload) {
            WebSocketClosedPayload connectedPayload = (WebSocketClosedPayload)payload;
            ClosedMessage message = connectedPayload.getMessage();
            this.onClose(message);
        } else if (payload instanceof WebSocketPushPayload) {
            WebSocketPushPayload pushPayload = (WebSocketPushPayload)payload;
            IWebSocketPushMessage message = pushPayload.getMessage();
            this.onPush(webSocketHandler, message);
        }
    }

    protected void onPush(WebSocketRequestHandler handler, IWebSocketPushMessage message) {
    }

    protected void onConnect(ConnectedMessage message) {
    }

    protected void onClose(ClosedMessage message) {
    }

    protected void onMessage(WebSocketRequestHandler handler, TextMessage message) {
    }

    protected void onMessage(WebSocketRequestHandler handler, BinaryMessage binaryMessage) {
    }

    public final void respond(IResource.Attributes attributes) {
    }
}

