/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.resource.WebExternalResourceStream;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextRelativeResource
extends AbstractResource
implements IStaticCacheableResource {
    private static final String CACHE_PREFIX = "context-relative:/";
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ContextRelativeResource.class);
    private final String path;
    private boolean cachingEnabled;

    public ContextRelativeResource(String pathRelativeToContextRoot) {
        Args.notNull((Object)pathRelativeToContextRoot, (String)"pathRelativeToContextRoot");
        if (!pathRelativeToContextRoot.startsWith("/")) {
            pathRelativeToContextRoot = "/" + pathRelativeToContextRoot;
        }
        this.path = pathRelativeToContextRoot;
        this.cachingEnabled = true;
    }

    @Override
    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean enabled) {
        this.cachingEnabled = enabled;
    }

    @Override
    public Serializable getCacheKey() {
        return CACHE_PREFIX + this.path;
    }

    @Override
    public IResourceStream getCacheableResourceStream() {
        return new WebExternalResourceStream(this.path);
    }

    @Override
    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse resourceResponse = new AbstractResource.ResourceResponse();
        final WebExternalResourceStream webExternalResourceStream = new WebExternalResourceStream(this.path);
        resourceResponse.setContentType(webExternalResourceStream.getContentType());
        resourceResponse.setLastModified(webExternalResourceStream.lastModifiedTime());
        resourceResponse.setFileName(this.path);
        resourceResponse.setWriteCallback(new AbstractResource.WriteCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeData(IResource.Attributes attributes) throws IOException {
                try {
                    InputStream inputStream = webExternalResourceStream.getInputStream();
                    try {
                        Streams.copy((InputStream)inputStream, (OutputStream)attributes.getResponse().getOutputStream());
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)inputStream);
                    }
                }
                catch (ResourceStreamNotFoundException rsnfx) {
                    throw new WicketRuntimeException(rsnfx);
                }
            }
        });
        return resourceResponse;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContextRelativeResource other = (ContextRelativeResource)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

