/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.jetty;

import java.io.IOException;
import org.apache.wicket.protocol.ws.api.AbstractWebSocketConnection;
import org.apache.wicket.protocol.ws.api.AbstractWebSocketProcessor;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.util.lang.Args;
import org.eclipse.jetty.websocket.WebSocket;

public class JettyWebSocketConnection
extends AbstractWebSocketConnection {
    private WebSocket.Connection connection;

    public JettyWebSocketConnection(WebSocket.Connection connection, AbstractWebSocketProcessor webSocketProcessor) {
        super(webSocketProcessor);
        this.connection = (WebSocket.Connection)Args.notNull((Object)connection, (String)"connection");
    }

    public boolean isOpen() {
        return this.connection.isOpen();
    }

    public void close(int code, String reason) {
        if (this.isOpen()) {
            this.connection.close(code, reason);
        }
    }

    public IWebSocketConnection sendMessage(String message) throws IOException {
        this.checkClosed();
        this.connection.sendMessage(message);
        return this;
    }

    public IWebSocketConnection sendMessage(byte[] message, int offset, int length) throws IOException {
        this.checkClosed();
        this.connection.sendMessage(message, offset, length);
        return this;
    }

    private void checkClosed() {
        if (!this.isOpen()) {
            throw new IllegalStateException("The connection is closed.");
        }
    }
}

