/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.jmx;

import java.io.IOException;
import org.apache.wicket.Application;
import org.apache.wicket.jmx.RequestLoggerMBean;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.WebApplication;

public class RequestLogger
implements RequestLoggerMBean {
    private final Application application;
    private final WebApplication webApplication;

    public RequestLogger(Application application) {
        this.application = application;
        this.webApplication = application instanceof WebApplication ? (WebApplication)application : null;
    }

    @Override
    public Integer getNumberOfCreatedSessions() throws IOException {
        IRequestLogger logger = this.getRequestLogger();
        if (logger != null) {
            return logger.getTotalCreatedSessions();
        }
        return null;
    }

    @Override
    public Integer getNumberOfLiveSessions() throws IOException {
        IRequestLogger logger = this.getRequestLogger();
        if (logger != null) {
            return logger.getLiveSessions().length;
        }
        return null;
    }

    @Override
    public Integer getPeakNumberOfSessions() throws IOException {
        IRequestLogger logger = this.getRequestLogger();
        if (logger != null) {
            return logger.getPeakSessions();
        }
        return null;
    }

    @Override
    public Integer getNumberOfCurrentActiveRequests() throws IOException {
        IRequestLogger logger = this.getRequestLogger();
        if (logger != null) {
            return logger.getCurrentActiveRequestCount();
        }
        return null;
    }

    @Override
    public Integer getPeakNumberOfActiveRequests() throws IOException {
        IRequestLogger logger = this.getRequestLogger();
        if (logger != null) {
            return logger.getPeakActiveRequestCount();
        }
        return null;
    }

    @Override
    public void restart() throws IOException {
        if (this.webApplication != null) {
            this.webApplication.getRequestLoggerSettings().setRequestLoggerEnabled(false);
            this.webApplication.getRequestLogger();
            this.webApplication.getRequestLoggerSettings().setRequestLoggerEnabled(true);
        }
    }

    @Override
    public void stop() throws IOException {
        if (this.webApplication != null) {
            this.webApplication.getRequestLoggerSettings().setRequestLoggerEnabled(false);
        }
    }

    protected IRequestLogger getRequestLogger() {
        if (this.application instanceof WebApplication) {
            return this.application.getRequestLogger();
        }
        return null;
    }
}

