/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.jmx;

import java.io.IOException;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.jmx.ApplicationMBean;

public class Application
implements ApplicationMBean {
    private final org.apache.wicket.Application application;

    public Application(org.apache.wicket.Application application) {
        this.application = application;
    }

    @Override
    public void clearMarkupCache() throws IOException {
        this.application.getMarkupSettings().getMarkupFactory().getMarkupCache().clear();
    }

    @Override
    public String getApplicationClass() throws IOException {
        return this.application.getClass().getName();
    }

    @Override
    public String getConfigurationType() {
        return this.application.getConfigurationType().name();
    }

    @Override
    public String getHomePageClass() throws IOException {
        return this.application.getHomePage().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMarkupCacheSize() throws IOException {
        ThreadContext.setApplication((org.apache.wicket.Application)this.application);
        try {
            int n = this.application.getMarkupSettings().getMarkupFactory().getMarkupCache().size();
            return n;
        }
        finally {
            ThreadContext.detach();
        }
    }

    @Override
    public String getWicketVersion() throws IOException {
        return this.application.getFrameworkSettings().getVersion();
    }

    @Override
    public void clearLocalizerCache() throws IOException {
        this.application.getResourceSettings().getLocalizer().clearCache();
    }
}

