/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table.filter;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.ChoiceFilter;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.FilterForm;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.FilteredPropertyColumn;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class ChoiceFilteredPropertyColumn<T, Y, S>
extends FilteredPropertyColumn<T, S> {
    private static final long serialVersionUID = 1L;
    private final IModel<List<? extends Y>> filterChoices;

    public ChoiceFilteredPropertyColumn(IModel<String> displayModel, S sortProperty, String propertyExpression, IModel<List<? extends Y>> filterChoices) {
        super(displayModel, sortProperty, propertyExpression);
        this.filterChoices = filterChoices;
    }

    public ChoiceFilteredPropertyColumn(IModel<String> displayModel, String propertyExpression, IModel<List<? extends Y>> filterChoices) {
        super(displayModel, propertyExpression);
        this.filterChoices = filterChoices;
    }

    @Override
    public void detach() {
        super.detach();
        if (this.filterChoices != null) {
            this.filterChoices.detach();
        }
    }

    @Override
    public Component getFilter(String componentId, FilterForm<?> form) {
        ChoiceFilter<Y> filter = new ChoiceFilter<Y>(componentId, this.getFilterModel(form), form, this.filterChoices, this.enableAutoSubmit());
        IChoiceRenderer<Y> renderer = this.getChoiceRenderer();
        if (renderer != null) {
            filter.getChoice().setChoiceRenderer(renderer);
        }
        return filter;
    }

    protected IModel<Y> getFilterModel(FilterForm<?> form) {
        return new PropertyModel((Object)form.getDefaultModel(), this.getPropertyExpression());
    }

    protected boolean enableAutoSubmit() {
        return true;
    }

    protected IChoiceRenderer<Y> getChoiceRenderer() {
        return null;
    }

    protected final IModel<List<? extends Y>> getFilterChoices() {
        return this.filterChoices;
    }
}

