/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.atmosphere.tester;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.Page;
import org.apache.wicket.atmosphere.AtmosphereBehavior;
import org.apache.wicket.atmosphere.EventBus;
import org.apache.wicket.atmosphere.tester.TesterAsyncSupport;
import org.apache.wicket.atmosphere.tester.TesterBroadcaster;
import org.apache.wicket.util.tester.WicketTester;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.handler.AtmosphereHandlerAdapter;

class TesterAtmosphereBehavior
extends AtmosphereBehavior {
    private final EventBus eventBus;
    private final WicketTester wicketTester;

    TesterAtmosphereBehavior(WicketTester wicketTester, EventBus eventBus) {
        this.wicketTester = wicketTester;
        this.eventBus = eventBus;
    }

    @Override
    public void onRequest() {
        TesterBroadcaster broadcaster = (TesterBroadcaster)this.eventBus.getBroadcaster();
        AtmosphereResourceImpl atmosphereResource = new AtmosphereResourceImpl();
        AtmosphereRequest atmosphereRequest = AtmosphereRequest.wrap((HttpServletRequest)this.wicketTester.getRequest());
        AtmosphereResponse atmosphereResponse = AtmosphereResponse.wrap((HttpServletResponse)this.wicketTester.getResponse());
        TesterAsyncSupport asyncSupport = new TesterAsyncSupport();
        atmosphereResource.initialize(broadcaster.getApplicationConfig(), (Broadcaster)broadcaster, atmosphereRequest, atmosphereResponse, asyncSupport, (AtmosphereHandler)new AtmosphereHandlerAdapter());
        atmosphereResource.setBroadcaster((Broadcaster)broadcaster);
        broadcaster.addAtmosphereResource((AtmosphereResource)atmosphereResource);
        String uuid = atmosphereResource.uuid();
        Page page = this.getComponent().getPage();
        page.setMetaData(ATMOSPHERE_UUID, (Object)uuid);
        this.eventBus.registerPage(uuid, page);
    }
}

