/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.session;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.session.ISessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionStore
implements ISessionStore {
    private static final Logger log = LoggerFactory.getLogger(HttpSessionStore.class);
    private final Set<ISessionStore.UnboundListener> unboundListeners = new CopyOnWriteArraySet<ISessionStore.UnboundListener>();
    private final Set<ISessionStore.BindListener> bindListeners = new CopyOnWriteArraySet<ISessionStore.BindListener>();

    protected final HttpServletRequest getHttpServletRequest(Request request) {
        Object containerRequest = request.getContainerRequest();
        if (!(containerRequest instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Request must be ServletWebRequest");
        }
        return (HttpServletRequest)containerRequest;
    }

    final HttpSession getHttpSession(Request request, boolean create) {
        return this.getHttpServletRequest(request).getSession(create);
    }

    @Override
    public final void bind(Request request, Session newSession) {
        if (this.getWicketSession(request) != newSession) {
            this.onBind(request, newSession);
            for (ISessionStore.BindListener listener : this.getBindListeners()) {
                listener.bindingSession(request, newSession);
            }
            HttpSession httpSession = this.getHttpSession(request, false);
            if (httpSession != null) {
                String applicationKey = Application.get().getName();
                this.withSession(httpSession.getId(), () -> {
                    httpSession.setAttribute("Wicket:SessionUnbindingListener-" + applicationKey, (Object)new SessionBindingListener(applicationKey, newSession));
                    this.setWicketSession(request, newSession);
                    return null;
                });
            }
        }
    }

    @Override
    public void flushSession(Request request, Session session) {
        if (this.getWicketSession(request) != session) {
            this.bind(request, session);
        } else {
            this.setWicketSession(request, session);
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getSessionId(Request request, boolean create) {
        String id = null;
        HttpSession httpSession = this.getHttpSession(request, false);
        if (httpSession != null) {
            id = httpSession.getId();
        } else if (create) {
            httpSession = this.getHttpSession(request, true);
            id = httpSession.getId();
            IRequestLogger logger = Application.get().getRequestLogger();
            if (logger != null) {
                logger.sessionCreated(id);
            }
        }
        return id;
    }

    @Override
    public final void invalidate(Request request) {
        HttpSession httpSession = this.getHttpSession(request, false);
        if (httpSession != null) {
            this.withSession(httpSession.getId(), () -> {
                httpSession.invalidate();
                return null;
            });
        }
    }

    @Override
    public final Session lookup(Request request) {
        String sessionId = this.getSessionId(request, false);
        if (sessionId != null) {
            return this.getWicketSession(request);
        }
        return null;
    }

    protected Session getWicketSession(Request request) {
        return (Session)((Object)this.getAttribute(request, "session"));
    }

    protected void setWicketSession(Request request, Session session) {
        this.setAttribute(request, "session", (Serializable)((Object)session));
    }

    protected void onBind(Request request, Session newSession) {
    }

    protected void onUnbind(String sessionId) {
    }

    private String getSessionAttributePrefix(Request request) {
        String sessionAttributePrefix = "wicket";
        if (request instanceof WebRequest) {
            sessionAttributePrefix = WebApplication.get().getSessionAttributePrefix((WebRequest)request, null);
        }
        return sessionAttributePrefix;
    }

    @Override
    public final Serializable getAttribute(Request request, String name) {
        HttpSession httpSession = this.getHttpSession(request, false);
        if (httpSession != null) {
            return this.withSession(httpSession.getId(), () -> (Serializable)httpSession.getAttribute(this.getSessionAttributePrefix(request) + name));
        }
        return null;
    }

    @Override
    public final List<String> getAttributeNames(Request request) {
        ArrayList<String> list = new ArrayList<String>();
        HttpSession httpSession = this.getHttpSession(request, false);
        if (httpSession != null) {
            this.withSession(httpSession.getId(), () -> {
                Enumeration names = httpSession.getAttributeNames();
                String prefix = this.getSessionAttributePrefix(request);
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    if (!name.startsWith(prefix)) continue;
                    list.add(name.substring(prefix.length()));
                }
                return null;
            });
        }
        return list;
    }

    @Override
    public final void removeAttribute(Request request, String name) {
        HttpSession httpSession = this.getHttpSession(request, false);
        if (httpSession != null) {
            String attributeName = this.getSessionAttributePrefix(request) + name;
            IRequestLogger logger = Application.get().getRequestLogger();
            this.withSession(httpSession.getId(), () -> {
                Object value;
                if (logger != null && (value = httpSession.getAttribute(attributeName)) != null) {
                    logger.objectRemoved(value);
                }
                httpSession.removeAttribute(attributeName);
                return null;
            });
        }
    }

    @Override
    public final void setAttribute(Request request, String name, Serializable value) {
        HttpSession httpSession = this.getHttpSession(request, false);
        if (httpSession != null) {
            String attributeName = this.getSessionAttributePrefix(request) + name;
            IRequestLogger logger = Application.get().getRequestLogger();
            this.withSession(httpSession.getId(), () -> {
                if (logger != null) {
                    if (httpSession.getAttribute(attributeName) == null) {
                        logger.objectCreated(value);
                    } else {
                        logger.objectUpdated(value);
                    }
                }
                httpSession.setAttribute(attributeName, (Object)value);
                return null;
            });
        }
    }

    @Override
    public final void registerUnboundListener(ISessionStore.UnboundListener listener) {
        this.unboundListeners.add(listener);
    }

    @Override
    public final void unregisterUnboundListener(ISessionStore.UnboundListener listener) {
        this.unboundListeners.remove(listener);
    }

    @Override
    public final Set<ISessionStore.UnboundListener> getUnboundListener() {
        return Collections.unmodifiableSet(this.unboundListeners);
    }

    @Override
    public void registerBindListener(ISessionStore.BindListener listener) {
        this.bindListeners.add(listener);
    }

    @Override
    public void unregisterBindListener(ISessionStore.BindListener listener) {
        this.bindListeners.remove(listener);
    }

    @Override
    public Set<ISessionStore.BindListener> getBindListeners() {
        return Collections.unmodifiableSet(this.bindListeners);
    }

    private <V> V withSession(String sessionId, Callable<V> callable) {
        try {
            return callable.call();
        }
        catch (IllegalStateException isx) {
            log.debug("HTTP session {} is no more valid!", (Object)sessionId, (Object)isx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    protected static final class SessionBindingListener
    implements HttpSessionBindingListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String applicationKey;
        private final Session wicketSession;

        public SessionBindingListener(String applicationKey, Session wicketSession) {
            this.applicationKey = applicationKey;
            this.wicketSession = wicketSession;
        }

        public void valueBound(HttpSessionBindingEvent evg) {
        }

        public void valueUnbound(HttpSessionBindingEvent evt) {
            Application application;
            String sessionId = evt.getSession().getId();
            log.debug("Session unbound: {}", (Object)sessionId);
            if (this.wicketSession != null) {
                this.wicketSession.onInvalidate();
            }
            if ((application = Application.get(this.applicationKey)) == null) {
                log.debug("Wicket application with name '{}' not found.", (Object)this.applicationKey);
                return;
            }
            ISessionStore sessionStore = application.getSessionStore();
            if (sessionStore != null) {
                if (sessionStore instanceof HttpSessionStore) {
                    ((HttpSessionStore)sessionStore).onUnbind(sessionId);
                }
                for (ISessionStore.UnboundListener listener : sessionStore.getUnboundListener()) {
                    listener.sessionUnbound(sessionId);
                }
            }
        }
    }
}

