/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.web.commands;

import java.awt.Desktop;
import java.net.URI;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.web.WebContainerService;

@Command(scope="web", name="launch", description="Start the web application in a browser of the given bundle ID.")
@Service
public class Launch
implements Action {
    @Argument(index=0, name="id", description="The bundle ID to start the browser with", required=true, multiValued=false)
    Long id;
    @Option(name="--base", description="The base URL to browse to, otherwise default localhost:8181 will be used.", required=false)
    String baseUrl = null;
    @Reference
    private WebContainerService webContainerService;

    public void setWebContainerService(WebContainerService webContainerService) {
        this.webContainerService = webContainerService;
    }

    public Object execute() throws Exception {
        Object webContextPath = this.webContainerService.getWebContextPath(this.id);
        if (this.baseUrl == null) {
            this.baseUrl = "http://localhost:8181";
        }
        if (!((String)webContextPath).startsWith("/")) {
            webContextPath = "/" + (String)webContextPath;
        }
        String uri = this.baseUrl + (String)webContextPath;
        Desktop.getDesktop().browse(new URI(uri));
        return null;
    }
}

