/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.unomi.api.services.ScopeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopeValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScopeValidator.class);
    private ScopeService scopeService;

    public ScopeValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, ScopeService scopeService) {
        super(schemaPath, schemaNode, parentSchema, null, validationContext);
        this.scopeService = scopeService;
    }

    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        LOGGER.debug("validate( {}, {}, {})", new Object[]{node, rootNode, at});
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        if (this.scopeService.getScope(node.textValue()) == null) {
            ValidationMessage.Builder builder = new ValidationMessage.Builder();
            builder.customMessage("Unknown scope value at " + at + " for value " + node.textValue()).format(new MessageFormat("Not used pattern. Message format is required"));
            errors.add(builder.build());
        }
        return errors;
    }
}

