/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import java.text.ParseException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoJson;
import org.elasticsearch.common.geo.GeometryFormat;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.utils.StandardValidator;
import org.elasticsearch.geometry.utils.WellKnownText;

public final class GeometryParser {
    private final GeoJson geoJsonParser;
    private final WellKnownText wellKnownTextParser;

    public GeometryParser(boolean rightOrientation, boolean coerce, boolean ignoreZValue) {
        StandardValidator validator = new StandardValidator(ignoreZValue);
        this.geoJsonParser = new GeoJson(rightOrientation, coerce, validator);
        this.wellKnownTextParser = new WellKnownText(coerce, validator);
    }

    public Geometry parse(XContentParser parser) throws IOException, ParseException {
        return this.geometryFormat(parser).fromXContent(parser);
    }

    public GeometryFormat geometryFormat(XContentParser parser) {
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return new GeometryFormat(){

                @Override
                public Geometry fromXContent(XContentParser parser) throws IOException {
                    return null;
                }

                @Override
                public XContentBuilder toXContent(Geometry geometry, XContentBuilder builder, ToXContent.Params params) throws IOException {
                    if (geometry != null) {
                        return GeoJson.toXContent(geometry, builder, params);
                    }
                    return builder.nullValue();
                }
            };
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            return new GeometryFormat(){

                @Override
                public Geometry fromXContent(XContentParser parser) throws IOException {
                    return GeometryParser.this.geoJsonParser.fromXContent(parser);
                }

                @Override
                public XContentBuilder toXContent(Geometry geometry, XContentBuilder builder, ToXContent.Params params) throws IOException {
                    if (geometry != null) {
                        return GeoJson.toXContent(geometry, builder, params);
                    }
                    return builder.nullValue();
                }
            };
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return new GeometryFormat(){

                @Override
                public Geometry fromXContent(XContentParser parser) throws IOException, ParseException {
                    return GeometryParser.this.wellKnownTextParser.fromWKT(parser.text());
                }

                @Override
                public XContentBuilder toXContent(Geometry geometry, XContentBuilder builder, ToXContent.Params params) throws IOException {
                    if (geometry != null) {
                        return builder.value(GeometryParser.this.wellKnownTextParser.toWKT(geometry));
                    }
                    return builder.nullValue();
                }
            };
        }
        throw new ElasticsearchParseException("shape must be an object consisting of type and coordinates", new Object[0]);
    }
}

