/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.cache.spi.entry.StandardCacheEntryImpl;

class Hibernate51CacheEntrySerializer
implements StreamSerializer<CacheEntry> {
    private static final Constructor<StandardCacheEntryImpl> CACHE_ENTRY_CONSTRUCTOR;
    private static final Class<?>[] CONSTRUCTOR_ARG_TYPES;

    Hibernate51CacheEntrySerializer() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getTypeId() {
        return -205;
    }

    @Override
    public CacheEntry read(ObjectDataInput in) throws IOException {
        try {
            if (in.readBoolean()) {
                return Hibernate51CacheEntrySerializer.readReference(in);
            }
            return Hibernate51CacheEntrySerializer.readDisassembled(in);
        }
        catch (Exception e) {
            throw Hibernate51CacheEntrySerializer.rethrow(e);
        }
    }

    @Override
    public void write(ObjectDataOutput out, CacheEntry object) throws IOException {
        try {
            out.writeBoolean(object.isReferenceEntry());
            if (object.isReferenceEntry()) {
                Hibernate51CacheEntrySerializer.writeReference(out, object);
            } else {
                Hibernate51CacheEntrySerializer.writeDisassembled(out, object);
            }
        }
        catch (Exception e) {
            throw Hibernate51CacheEntrySerializer.rethrow(e);
        }
    }

    private static CacheEntry readDisassembled(ObjectDataInput in) throws IOException, IllegalAccessException, InvocationTargetException, InstantiationException {
        int length = in.readInt();
        Serializable[] disassembledState = new Serializable[length];
        for (int i = 0; i < length; ++i) {
            disassembledState[i] = (Serializable)in.readObject();
        }
        String subclass = in.readUTF();
        Object version = in.readObject();
        return (CacheEntry)CACHE_ENTRY_CONSTRUCTOR.newInstance(disassembledState, subclass, version);
    }

    private static CacheEntry readReference(ObjectDataInput in) throws IOException {
        return ((CacheEntryWrapper)in.readObject()).entry;
    }

    private static IOException rethrow(Exception e) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        throw new IOException(e);
    }

    private static void writeDisassembled(ObjectDataOutput out, CacheEntry object) throws IOException {
        Serializable[] disassembledState = object.getDisassembledState();
        out.writeInt(disassembledState.length);
        for (Serializable state : disassembledState) {
            out.writeObject(state);
        }
        out.writeUTF(object.getSubclass());
        out.writeObject(object.getVersion());
    }

    private static void writeReference(ObjectDataOutput out, CacheEntry object) throws IOException {
        out.writeObject(new CacheEntryWrapper(object));
    }

    static {
        CONSTRUCTOR_ARG_TYPES = new Class[]{Serializable[].class, String.class, Object.class};
        try {
            CACHE_ENTRY_CONSTRUCTOR = StandardCacheEntryImpl.class.getDeclaredConstructor(CONSTRUCTOR_ARG_TYPES);
            CACHE_ENTRY_CONSTRUCTOR.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class CacheEntryWrapper
    implements Serializable {
        private final CacheEntry entry;

        private CacheEntryWrapper(CacheEntry entry) {
            this.entry = entry;
        }
    }
}

