/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.healthcheck.provider;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.unomi.api.ClusterNode;
import org.apache.unomi.api.services.ClusterService;
import org.apache.unomi.healthcheck.HealthCheckProvider;
import org.apache.unomi.healthcheck.HealthCheckResponse;
import org.apache.unomi.healthcheck.util.CachedValue;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={HealthCheckProvider.class}, immediate=true)
public class ClusterHealthCheckProvider
implements HealthCheckProvider {
    public static final String NAME = "cluster";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ClusterHealthCheckProvider.class.getName());
    private final CachedValue<HealthCheckResponse> cache = new CachedValue(10L, TimeUnit.SECONDS);
    @Reference(service=ClusterService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, bind="bind", unbind="unbind")
    private volatile ClusterService service;

    public ClusterHealthCheckProvider() {
        LOGGER.info("Building cluster health provider service...");
    }

    public void bind(ClusterService service) {
        this.service = service;
    }

    public void unbind(ClusterService service) {
        this.service = null;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public HealthCheckResponse execute() {
        LOGGER.debug("Health check cluster");
        if (this.cache.isStaled() || this.cache.getValue().isDown() || this.cache.getValue().isError()) {
            this.cache.setValue(this.refresh());
        }
        return this.cache.getValue();
    }

    private HealthCheckResponse refresh() {
        LOGGER.debug("Refresh");
        HealthCheckResponse.Builder builder = new HealthCheckResponse.Builder();
        builder.name(NAME).down();
        try {
            if (this.service != null) {
                builder.up();
                List nodes = this.service.getClusterNodes();
                builder.withData("cluster.size", nodes.size());
                if (nodes.isEmpty()) {
                    builder.down();
                }
                int idx = 1;
                for (ClusterNode node : nodes) {
                    if (!nodes.isEmpty() || node.isMaster()) {
                        builder.live();
                    }
                    builder.withData("cluster.node." + idx + ".uptime", node.getUptime());
                    builder.withData("cluster.node." + idx + ".cpuload", Double.toString(node.getCpuLoad()));
                    builder.withData("cluster.node." + idx + ".loadAverage", Arrays.stream(node.getLoadAverage()).mapToObj(Double::toString).collect(Collectors.joining(",")));
                    builder.withData("cluster.node." + idx + ".public", node.getPublicHostAddress());
                    builder.withData("cluster.node." + idx + ".internal", node.getInternalHostAddress());
                    if (node.isData() || node.isMaster()) {
                        builder.withData("cluster.node." + idx + ".role", (node.isMaster() ? "master" : "") + (node.isData() ? "data" : ""));
                    }
                    ++idx;
                }
            }
        }
        catch (Exception e) {
            builder.error().withData("error", e.getMessage());
            LOGGER.error("Error checking cluster health", (Throwable)e);
        }
        return builder.build();
    }
}

