/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.exception;

import java.util.HashMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.ArrayUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Component(service={ExceptionMapper.class})
public class RuntimeExceptionMapper
implements ExceptionMapper<RuntimeException> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RuntimeExceptionMapper.class.getName());

    public Response toResponse(RuntimeException exception) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("errorMessage", "internalServerError");
        LOGGER.error("Internal server error {}: {} in {} (Set RuntimeExceptionMapper in debug to get the full stacktrace)", new Object[]{exception.getMessage(), exception, ArrayUtils.isEmpty((Object[])exception.getStackTrace()) ? "Stack not available" : exception.getStackTrace()[0]});
        LOGGER.debug("{}", (Object)exception.getMessage(), (Object)exception);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("Content-Type", (Object)"application/json").entity(body).build();
    }
}

