/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.endpoints;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.Scope;
import org.apache.unomi.api.services.ScopeService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/scopes")
@Component(service={ScopeServiceEndPoint.class}, property={"osgi.jaxrs.resource=true"})
public class ScopeServiceEndPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ScopeServiceEndPoint.class.getName());
    @Reference
    private ScopeService scopeService;

    public ScopeServiceEndPoint() {
        LOGGER.info("Initializing scope service endpoint...");
    }

    @WebMethod(exclude=true)
    public void setScopeService(ScopeService scopeService) {
        this.scopeService = scopeService;
    }

    @GET
    @Path(value="/")
    public List<Scope> getScopes() {
        return this.scopeService.getScopes();
    }

    @POST
    @Path(value="/")
    public Response save(Scope scope) {
        this.scopeService.save(scope);
        return Response.ok().build();
    }

    @GET
    @Path(value="/{scopeId}")
    public Scope getScope(@PathParam(value="scopeId") String scopeId) {
        return this.scopeService.getScope(scopeId);
    }

    @DELETE
    @Path(value="/{scopeId}")
    public void delete(@PathParam(value="scopeId") String scopeId) {
        this.scopeService.delete(scopeId);
    }
}

