/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.Resource;
import org.apache.kafka.common.requests.ResourceType;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class KafkaAdminClient
extends AdminClient {
    private static final Logger log = LoggerFactory.getLogger(KafkaAdminClient.class);
    private static final AtomicInteger ADMIN_CLIENT_ID_SEQUENCE = new AtomicInteger(1);
    private static final String JMX_PREFIX = "kafka.admin.client";
    private static final long INVALID_SHUTDOWN_TIME = -1L;
    private final int defaultTimeoutMs;
    private final String clientId;
    private final Time time;
    private final Metadata metadata;
    private final Metrics metrics;
    private final KafkaClient client;
    private final AdminClientRunnable runnable;
    private final Thread thread;
    private final AtomicLong hardShutdownTimeMs = new AtomicLong(-1L);
    private final TimeoutProcessorFactory timeoutProcessorFactory;
    private final int maxRetries;

    static <K, V> List<V> getOrCreateListValue(Map<K, List<V>> map, K key) {
        List<V> list = map.get(key);
        if (list != null) {
            return list;
        }
        list = new LinkedList<V>();
        map.put(key, list);
        return list;
    }

    private static <T> void completeAllExceptionally(Collection<KafkaFutureImpl<T>> futures, Throwable exc) {
        for (KafkaFutureImpl<T> future : futures) {
            future.completeExceptionally(exc);
        }
    }

    static int calcTimeoutMsRemainingAsInt(long now, long deadlineMs) {
        long deltaMs = deadlineMs - now;
        if (deltaMs > Integer.MAX_VALUE) {
            deltaMs = Integer.MAX_VALUE;
        } else if (deltaMs < Integer.MIN_VALUE) {
            deltaMs = Integer.MIN_VALUE;
        }
        return (int)deltaMs;
    }

    static String generateClientId(AdminClientConfig config) {
        String clientId = config.getString("client.id");
        if (!clientId.isEmpty()) {
            return clientId;
        }
        return "adminclient-" + ADMIN_CLIENT_ID_SEQUENCE.getAndIncrement();
    }

    private long calcDeadlineMs(long now, Integer optionTimeoutMs) {
        if (optionTimeoutMs != null) {
            return now + (long)Math.max(0, optionTimeoutMs);
        }
        return now + (long)this.defaultTimeoutMs;
    }

    static String prettyPrintException(Throwable throwable) {
        if (throwable == null) {
            return "Null exception.";
        }
        if (throwable.getMessage() != null) {
            return throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
        }
        return throwable.getClass().getSimpleName();
    }

    static KafkaAdminClient createInternal(AdminClientConfig config, TimeoutProcessorFactory timeoutProcessorFactory) {
        Metrics metrics = null;
        NetworkClient networkClient = null;
        Time time = Time.SYSTEM;
        String clientId = KafkaAdminClient.generateClientId(config);
        ChannelBuilder channelBuilder = null;
        Selector selector = null;
        ApiVersions apiVersions = new ApiVersions();
        try {
            Metadata metadata = new Metadata(config.getLong("retry.backoff.ms"), config.getLong("metadata.max.age.ms"), true);
            List<MetricsReporter> reporters = config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
            Map<String, String> metricTags = Collections.singletonMap("client-id", clientId);
            MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples")).timeWindow(config.getLong("metrics.sample.window.ms"), TimeUnit.MILLISECONDS).recordLevel(Sensor.RecordingLevel.forName(config.getString("metrics.recording.level"))).tags(metricTags);
            reporters.add(new JmxReporter(JMX_PREFIX));
            metrics = new Metrics(metricConfig, reporters, time);
            String metricGrpPrefix = "admin-client";
            channelBuilder = ClientUtils.createChannelBuilder(config);
            selector = new Selector(config.getLong("connections.max.idle.ms"), metrics, time, metricGrpPrefix, channelBuilder);
            networkClient = new NetworkClient((Selectable)selector, metadata, clientId, 1, (long)config.getLong("reconnect.backoff.ms"), (long)config.getLong("reconnect.backoff.max.ms"), (int)config.getInt("send.buffer.bytes"), (int)config.getInt("receive.buffer.bytes"), (int)TimeUnit.HOURS.toMillis(1L), time, true, apiVersions);
            return new KafkaAdminClient(config, clientId, time, metadata, metrics, networkClient, timeoutProcessorFactory);
        }
        catch (Throwable exc) {
            Utils.closeQuietly(metrics, "Metrics");
            Utils.closeQuietly(networkClient, "NetworkClient");
            Utils.closeQuietly(selector, "Selector");
            Utils.closeQuietly(channelBuilder, "ChannelBuilder");
            throw new KafkaException("Failed create new KafkaAdminClient", exc);
        }
    }

    static KafkaAdminClient createInternal(AdminClientConfig config, KafkaClient client, Metadata metadata, Time time) {
        Metrics metrics = null;
        String clientId = KafkaAdminClient.generateClientId(config);
        try {
            metrics = new Metrics(new MetricConfig(), new LinkedList<MetricsReporter>(), time);
            return new KafkaAdminClient(config, clientId, time, metadata, metrics, client, null);
        }
        catch (Throwable exc) {
            Utils.closeQuietly(metrics, "Metrics");
            throw new KafkaException("Failed create new KafkaAdminClient", exc);
        }
    }

    private KafkaAdminClient(AdminClientConfig config, String clientId, Time time, Metadata metadata, Metrics metrics, KafkaClient client, TimeoutProcessorFactory timeoutProcessorFactory) {
        this.defaultTimeoutMs = config.getInt("request.timeout.ms");
        this.clientId = clientId;
        this.time = time;
        this.metadata = metadata;
        List<InetSocketAddress> addresses = ClientUtils.parseAndValidateAddresses(config.getList("bootstrap.servers"));
        this.metadata.update(Cluster.bootstrap(addresses), Collections.emptySet(), time.milliseconds());
        this.metrics = metrics;
        this.client = client;
        this.runnable = new AdminClientRunnable();
        String threadName = "kafka-admin-client-thread" + (clientId.length() > 0 ? " | " + clientId : "");
        this.thread = new KafkaThread(threadName, (Runnable)this.runnable, true);
        this.timeoutProcessorFactory = timeoutProcessorFactory == null ? new TimeoutProcessorFactory() : timeoutProcessorFactory;
        this.maxRetries = config.getInt("retries");
        config.logUnused();
        AppInfoParser.registerAppInfo(JMX_PREFIX, clientId);
        log.debug("Kafka admin client with client id {} created", (Object)this.clientId);
        this.thread.start();
    }

    Time time() {
        return this.time;
    }

    @Override
    public void close(long duration, TimeUnit unit) {
        long newHardShutdownTimeMs;
        block6: {
            long waitTimeMs = unit.toMillis(duration);
            waitTimeMs = Math.min(TimeUnit.DAYS.toMillis(365L), waitTimeMs);
            long now = this.time.milliseconds();
            newHardShutdownTimeMs = now + waitTimeMs;
            long prev = -1L;
            do {
                if (!this.hardShutdownTimeMs.compareAndSet(prev, newHardShutdownTimeMs)) continue;
                if (prev == -1L) {
                    log.debug("{}: initiating close operation.", (Object)this.clientId);
                } else {
                    log.debug("{}: moving hard shutdown time forward.", (Object)this.clientId);
                }
                this.client.wakeup();
                break block6;
            } while ((prev = this.hardShutdownTimeMs.get()) >= newHardShutdownTimeMs);
            log.debug("{}: hard shutdown time is already earlier than requested.", (Object)this.clientId);
            newHardShutdownTimeMs = prev;
        }
        if (log.isDebugEnabled()) {
            long deltaMs = Math.max(0L, newHardShutdownTimeMs - this.time.milliseconds());
            log.debug("{}: waiting for the I/O thread to exit. Hard shutdown in {} ms.", (Object)this.clientId, (Object)deltaMs);
        }
        try {
            this.thread.join();
            AppInfoParser.unregisterAppInfo(JMX_PREFIX, this.clientId);
            log.debug("{}: closed.", (Object)this.clientId);
        }
        catch (InterruptedException e) {
            log.debug("{}: interrupted while joining I/O thread", (Object)this.clientId, (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public CreateTopicsResult createTopics(Collection<NewTopic> newTopics, final CreateTopicsOptions options) {
        final HashMap topicFutures = new HashMap(newTopics.size());
        final HashMap<String, CreateTopicsRequest.TopicDetails> topicsMap = new HashMap<String, CreateTopicsRequest.TopicDetails>(newTopics.size());
        for (NewTopic newTopic : newTopics) {
            if (topicFutures.get(newTopic.name()) != null) continue;
            topicFutures.put(newTopic.name(), new KafkaFutureImpl());
            topicsMap.put(newTopic.name(), newTopic.convertToTopicDetails());
        }
        long now = this.time.milliseconds();
        this.runnable.call(new Call("createTopics", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            @Override
            public AbstractRequest.Builder createRequest(int timeoutMs) {
                return new CreateTopicsRequest.Builder(topicsMap, timeoutMs, options.shouldValidateOnly());
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                KafkaFutureImpl future;
                CreateTopicsResponse response = (CreateTopicsResponse)abstractResponse;
                for (Map.Entry<String, ApiError> entry : response.errors().entrySet()) {
                    future = (KafkaFutureImpl)topicFutures.get(entry.getKey());
                    if (future == null) {
                        log.warn("Server response mentioned unknown topic {}", (Object)entry.getKey());
                        continue;
                    }
                    ApiException exception = entry.getValue().exception();
                    if (exception != null) {
                        future.completeExceptionally(exception);
                        continue;
                    }
                    future.complete(null);
                }
                for (Map.Entry<String, ApiError> entry : topicFutures.entrySet()) {
                    future = (KafkaFutureImpl)((Object)entry.getValue());
                    if (future.isDone()) continue;
                    future.completeExceptionally(new ApiException("The server response did not contain a reference to node " + entry.getKey()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(topicFutures.values(), throwable);
            }
        }, now);
        return new CreateTopicsResult(new HashMap<String, KafkaFuture<Void>>(topicFutures));
    }

    @Override
    public DeleteTopicsResult deleteTopics(final Collection<String> topicNames, DeleteTopicsOptions options) {
        final HashMap topicFutures = new HashMap(topicNames.size());
        for (String topicName : topicNames) {
            if (topicFutures.get(topicName) != null) continue;
            topicFutures.put(topicName, new KafkaFutureImpl());
        }
        long now = this.time.milliseconds();
        this.runnable.call(new Call("deleteTopics", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){

            @Override
            AbstractRequest.Builder createRequest(int timeoutMs) {
                return new DeleteTopicsRequest.Builder(new HashSet<String>(topicNames), timeoutMs);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                KafkaFutureImpl future;
                DeleteTopicsResponse response = (DeleteTopicsResponse)abstractResponse;
                for (Map.Entry<String, Errors> entry : response.errors().entrySet()) {
                    future = (KafkaFutureImpl)topicFutures.get(entry.getKey());
                    if (future == null) {
                        log.warn("Server response mentioned unknown topic {}", (Object)entry.getKey());
                        continue;
                    }
                    ApiException exception = entry.getValue().exception();
                    if (exception != null) {
                        future.completeExceptionally(exception);
                        continue;
                    }
                    future.complete(null);
                }
                for (Map.Entry<String, Errors> entry : topicFutures.entrySet()) {
                    future = (KafkaFutureImpl)((Object)entry.getValue());
                    if (future.isDone()) continue;
                    future.completeExceptionally(new ApiException("The server response did not contain a reference to node " + entry.getKey()));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(topicFutures.values(), throwable);
            }
        }, now);
        return new DeleteTopicsResult(new HashMap<String, KafkaFuture<Void>>(topicFutures));
    }

    @Override
    public ListTopicsResult listTopics(final ListTopicsOptions options) {
        final KafkaFutureImpl<Map<String, TopicListing>> topicListingFuture = new KafkaFutureImpl<Map<String, TopicListing>>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("listTopics", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            AbstractRequest.Builder createRequest(int timeoutMs) {
                return MetadataRequest.Builder.allTopics();
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                MetadataResponse response = (MetadataResponse)abstractResponse;
                Cluster cluster = response.cluster();
                HashMap<String, TopicListing> topicListing = new HashMap<String, TopicListing>();
                for (String topicName : cluster.topics()) {
                    boolean internal = cluster.internalTopics().contains(topicName);
                    if (internal && !options.shouldListInternal()) continue;
                    topicListing.put(topicName, new TopicListing(topicName, internal));
                }
                topicListingFuture.complete(topicListing);
            }

            @Override
            void handleFailure(Throwable throwable) {
                topicListingFuture.completeExceptionally(throwable);
            }
        }, now);
        return new ListTopicsResult(topicListingFuture);
    }

    @Override
    public DescribeTopicsResult describeTopics(Collection<String> topicNames, DescribeTopicsOptions options) {
        final HashMap topicFutures = new HashMap(topicNames.size());
        final ArrayList<String> topicNamesList = new ArrayList<String>();
        for (String topicName : topicNames) {
            if (topicFutures.containsKey(topicName)) continue;
            topicFutures.put(topicName, new KafkaFutureImpl());
            topicNamesList.add(topicName);
        }
        long now = this.time.milliseconds();
        this.runnable.call(new Call("describeTopics", this.calcDeadlineMs(now, options.timeoutMs()), new ControllerNodeProvider()){
            private boolean supportsDisablingTopicCreation;
            {
                super(x0, x1, x2);
                this.supportsDisablingTopicCreation = true;
            }

            @Override
            AbstractRequest.Builder createRequest(int timeoutMs) {
                if (this.supportsDisablingTopicCreation) {
                    return new MetadataRequest.Builder(topicNamesList, false);
                }
                return MetadataRequest.Builder.allTopics();
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                MetadataResponse response = (MetadataResponse)abstractResponse;
                for (Map.Entry entry : topicFutures.entrySet()) {
                    String topicName = (String)entry.getKey();
                    KafkaFutureImpl future = (KafkaFutureImpl)entry.getValue();
                    Errors topicError = response.errors().get(topicName);
                    if (topicError != null) {
                        future.completeExceptionally(topicError.exception());
                        continue;
                    }
                    Cluster cluster = response.cluster();
                    if (!cluster.topics().contains(topicName)) {
                        future.completeExceptionally(new InvalidTopicException("Topic " + topicName + " not found."));
                        continue;
                    }
                    boolean isInternal = cluster.internalTopics().contains(topicName);
                    List<PartitionInfo> partitionInfos = cluster.partitionsForTopic(topicName);
                    ArrayList<TopicPartitionInfo> partitions = new ArrayList<TopicPartitionInfo>(partitionInfos.size());
                    for (PartitionInfo partitionInfo : partitionInfos) {
                        TopicPartitionInfo topicPartitionInfo = new TopicPartitionInfo(partitionInfo.partition(), this.leader(partitionInfo), Arrays.asList(partitionInfo.replicas()), Arrays.asList(partitionInfo.inSyncReplicas()));
                        partitions.add(topicPartitionInfo);
                    }
                    Collections.sort(partitions, new Comparator<TopicPartitionInfo>(){

                        @Override
                        public int compare(TopicPartitionInfo tp1, TopicPartitionInfo tp2) {
                            return Integer.compare(tp1.partition(), tp2.partition());
                        }
                    });
                    TopicDescription topicDescription = new TopicDescription(topicName, isInternal, partitions);
                    future.complete(topicDescription);
                }
            }

            private Node leader(PartitionInfo partitionInfo) {
                if (partitionInfo.leader() == null || partitionInfo.leader().id() == Node.noNode().id()) {
                    return null;
                }
                return partitionInfo.leader();
            }

            @Override
            boolean handleUnsupportedVersionException(UnsupportedVersionException exception) {
                if (this.supportsDisablingTopicCreation) {
                    this.supportsDisablingTopicCreation = false;
                    return true;
                }
                return false;
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(topicFutures.values(), throwable);
            }
        }, now);
        return new DescribeTopicsResult(new HashMap<String, KafkaFuture<TopicDescription>>(topicFutures));
    }

    @Override
    public DescribeClusterResult describeCluster(DescribeClusterOptions options) {
        final KafkaFutureImpl<Collection<Node>> describeClusterFuture = new KafkaFutureImpl<Collection<Node>>();
        final KafkaFutureImpl<Node> controllerFuture = new KafkaFutureImpl<Node>();
        final KafkaFutureImpl<String> clusterIdFuture = new KafkaFutureImpl<String>();
        long now = this.time.milliseconds();
        this.runnable.call(new Call("listNodes", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            AbstractRequest.Builder createRequest(int timeoutMs) {
                return new MetadataRequest.Builder(Collections.emptyList(), true);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                MetadataResponse response = (MetadataResponse)abstractResponse;
                describeClusterFuture.complete(response.brokers());
                controllerFuture.complete(this.controller(response));
                clusterIdFuture.complete(response.clusterId());
            }

            private Node controller(MetadataResponse response) {
                if (response.controller() == null || response.controller().id() == -1) {
                    return null;
                }
                return response.controller();
            }

            @Override
            void handleFailure(Throwable throwable) {
                describeClusterFuture.completeExceptionally(throwable);
                controllerFuture.completeExceptionally(throwable);
                clusterIdFuture.completeExceptionally(throwable);
            }
        }, now);
        return new DescribeClusterResult(describeClusterFuture, controllerFuture, clusterIdFuture);
    }

    @Override
    public DescribeAclsResult describeAcls(final AclBindingFilter filter, DescribeAclsOptions options) {
        long now = this.time.milliseconds();
        final KafkaFutureImpl<Collection<AclBinding>> future = new KafkaFutureImpl<Collection<AclBinding>>();
        this.runnable.call(new Call("describeAcls", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            AbstractRequest.Builder createRequest(int timeoutMs) {
                return new DescribeAclsRequest.Builder(filter);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DescribeAclsResponse response = (DescribeAclsResponse)abstractResponse;
                if (response.error().isFailure()) {
                    future.completeExceptionally(response.error().exception());
                } else {
                    future.complete(response.acls());
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        }, now);
        return new DescribeAclsResult(future);
    }

    @Override
    public CreateAclsResult createAcls(Collection<AclBinding> acls, CreateAclsOptions options) {
        long now = this.time.milliseconds();
        final HashMap futures = new HashMap();
        final ArrayList<CreateAclsRequest.AclCreation> aclCreations = new ArrayList<CreateAclsRequest.AclCreation>();
        for (AclBinding acl : acls) {
            if (futures.get(acl) != null) continue;
            KafkaFutureImpl future = new KafkaFutureImpl();
            futures.put(acl, future);
            String indefinite = acl.toFilter().findIndefiniteField();
            if (indefinite == null) {
                aclCreations.add(new CreateAclsRequest.AclCreation(acl));
                continue;
            }
            future.completeExceptionally(new InvalidRequestException("Invalid ACL creation: " + indefinite));
        }
        this.runnable.call(new Call("createAcls", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            AbstractRequest.Builder createRequest(int timeoutMs) {
                return new CreateAclsRequest.Builder(aclCreations);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                CreateAclsResponse response = (CreateAclsResponse)abstractResponse;
                List<CreateAclsResponse.AclCreationResponse> responses = response.aclCreationResponses();
                Iterator<CreateAclsResponse.AclCreationResponse> iter = responses.iterator();
                for (CreateAclsRequest.AclCreation aclCreation : aclCreations) {
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(aclCreation.acl());
                    if (!iter.hasNext()) {
                        future.completeExceptionally(new UnknownServerException("The broker reported no creation result for the given ACL."));
                        continue;
                    }
                    CreateAclsResponse.AclCreationResponse creation = iter.next();
                    if (creation.error().isFailure()) {
                        future.completeExceptionally(creation.error().exception());
                        continue;
                    }
                    future.complete(null);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        }, now);
        return new CreateAclsResult(new HashMap<AclBinding, KafkaFuture<Void>>(futures));
    }

    @Override
    public DeleteAclsResult deleteAcls(Collection<AclBindingFilter> filters, DeleteAclsOptions options) {
        long now = this.time.milliseconds();
        final HashMap futures = new HashMap();
        final ArrayList<AclBindingFilter> filterList = new ArrayList<AclBindingFilter>();
        for (AclBindingFilter filter : filters) {
            if (futures.get(filter) != null) continue;
            filterList.add(filter);
            futures.put(filter, new KafkaFutureImpl());
        }
        this.runnable.call(new Call("deleteAcls", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            AbstractRequest.Builder createRequest(int timeoutMs) {
                return new DeleteAclsRequest.Builder(filterList);
            }

            @Override
            void handleResponse(AbstractResponse abstractResponse) {
                DeleteAclsResponse response = (DeleteAclsResponse)abstractResponse;
                List<DeleteAclsResponse.AclFilterResponse> responses = response.responses();
                Iterator<DeleteAclsResponse.AclFilterResponse> iter = responses.iterator();
                for (AclBindingFilter filter : filterList) {
                    KafkaFutureImpl future = (KafkaFutureImpl)futures.get(filter);
                    if (!iter.hasNext()) {
                        future.completeExceptionally(new UnknownServerException("The broker reported no deletion result for the given filter."));
                        continue;
                    }
                    DeleteAclsResponse.AclFilterResponse deletion = iter.next();
                    if (deletion.error().isFailure()) {
                        future.completeExceptionally(deletion.error().exception());
                        continue;
                    }
                    ArrayList<DeleteAclsResult.FilterResult> filterResults = new ArrayList<DeleteAclsResult.FilterResult>();
                    for (DeleteAclsResponse.AclDeletionResult deletionResult : deletion.deletions()) {
                        filterResults.add(new DeleteAclsResult.FilterResult(deletionResult.acl(), deletionResult.error().exception()));
                    }
                    future.complete(new DeleteAclsResult.FilterResults(filterResults));
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        }, now);
        return new DeleteAclsResult(new HashMap<AclBindingFilter, KafkaFuture<DeleteAclsResult.FilterResults>>(futures));
    }

    @Override
    public DescribeConfigsResult describeConfigs(Collection<ConfigResource> configResources, DescribeConfigsOptions options) {
        final HashMap unifiedRequestFutures = new HashMap();
        HashMap brokerFutures = new HashMap(configResources.size());
        ArrayList<Resource> brokerResources = new ArrayList<Resource>();
        final ArrayList<Resource> unifiedRequestResources = new ArrayList<Resource>(configResources.size());
        for (ConfigResource resource : configResources) {
            if (resource.type() == ConfigResource.Type.BROKER) {
                brokerFutures.put(resource, new KafkaFutureImpl());
                brokerResources.add(this.configResourceToResource(resource));
                continue;
            }
            unifiedRequestFutures.put(resource, new KafkaFutureImpl());
            unifiedRequestResources.add(this.configResourceToResource(resource));
        }
        long now = this.time.milliseconds();
        if (!unifiedRequestResources.isEmpty()) {
            this.runnable.call(new Call("describeConfigs", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

                @Override
                AbstractRequest.Builder createRequest(int timeoutMs) {
                    return new DescribeConfigsRequest.Builder(unifiedRequestResources);
                }

                @Override
                void handleResponse(AbstractResponse abstractResponse) {
                    DescribeConfigsResponse response = (DescribeConfigsResponse)abstractResponse;
                    for (Map.Entry entry : unifiedRequestFutures.entrySet()) {
                        ConfigResource configResource = (ConfigResource)entry.getKey();
                        KafkaFutureImpl future = (KafkaFutureImpl)entry.getValue();
                        DescribeConfigsResponse.Config config = response.config(KafkaAdminClient.this.configResourceToResource(configResource));
                        if (config == null) {
                            future.completeExceptionally(new UnknownServerException("Malformed broker response: missing config for " + configResource));
                            continue;
                        }
                        if (config.error().isFailure()) {
                            future.completeExceptionally(config.error().exception());
                            continue;
                        }
                        ArrayList<ConfigEntry> configEntries = new ArrayList<ConfigEntry>();
                        for (DescribeConfigsResponse.ConfigEntry configEntry : config.entries()) {
                            configEntries.add(new ConfigEntry(configEntry.name(), configEntry.value(), configEntry.isDefault(), configEntry.isSensitive(), configEntry.isReadOnly()));
                        }
                        future.complete(new Config(configEntries));
                    }
                }

                @Override
                void handleFailure(Throwable throwable) {
                    KafkaAdminClient.completeAllExceptionally(unifiedRequestFutures.values(), throwable);
                }
            }, now);
        }
        for (Map.Entry entry : brokerFutures.entrySet()) {
            final KafkaFutureImpl brokerFuture = (KafkaFutureImpl)entry.getValue();
            final Resource resource = this.configResourceToResource((ConfigResource)entry.getKey());
            int nodeId = Integer.parseInt(resource.name());
            this.runnable.call(new Call("describeBrokerConfigs", this.calcDeadlineMs(now, options.timeoutMs()), new ConstantNodeIdProvider(nodeId)){

                @Override
                AbstractRequest.Builder createRequest(int timeoutMs) {
                    return new DescribeConfigsRequest.Builder(Collections.singleton(resource));
                }

                @Override
                void handleResponse(AbstractResponse abstractResponse) {
                    DescribeConfigsResponse response = (DescribeConfigsResponse)abstractResponse;
                    DescribeConfigsResponse.Config config = response.configs().get(resource);
                    if (config == null) {
                        brokerFuture.completeExceptionally(new UnknownServerException("Malformed broker response: missing config for " + resource));
                        return;
                    }
                    if (config.error().isFailure()) {
                        brokerFuture.completeExceptionally(config.error().exception());
                    } else {
                        ArrayList<ConfigEntry> configEntries = new ArrayList<ConfigEntry>();
                        for (DescribeConfigsResponse.ConfigEntry configEntry : config.entries()) {
                            configEntries.add(new ConfigEntry(configEntry.name(), configEntry.value(), configEntry.isDefault(), configEntry.isSensitive(), configEntry.isReadOnly()));
                        }
                        brokerFuture.complete(new Config(configEntries));
                    }
                }

                @Override
                void handleFailure(Throwable throwable) {
                    brokerFuture.completeExceptionally(throwable);
                }
            }, now);
        }
        HashMap<ConfigResource, KafkaFuture<Config>> allFutures = new HashMap<ConfigResource, KafkaFuture<Config>>();
        allFutures.putAll(brokerFutures);
        allFutures.putAll(unifiedRequestFutures);
        return new DescribeConfigsResult(allFutures);
    }

    private Resource configResourceToResource(ConfigResource configResource) {
        ResourceType resourceType;
        switch (configResource.type()) {
            case TOPIC: {
                resourceType = ResourceType.TOPIC;
                break;
            }
            case BROKER: {
                resourceType = ResourceType.BROKER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected resource type " + (Object)((Object)configResource.type()));
            }
        }
        return new Resource(resourceType, configResource.name());
    }

    @Override
    public AlterConfigsResult alterConfigs(Map<ConfigResource, Config> configs, final AlterConfigsOptions options) {
        final HashMap futures = new HashMap(configs.size());
        for (ConfigResource configResource : configs.keySet()) {
            futures.put(configResource, new KafkaFutureImpl());
        }
        final HashMap<Resource, AlterConfigsRequest.Config> requestMap = new HashMap<Resource, AlterConfigsRequest.Config>(configs.size());
        for (Map.Entry<ConfigResource, Config> entry : configs.entrySet()) {
            ArrayList<AlterConfigsRequest.ConfigEntry> configEntries = new ArrayList<AlterConfigsRequest.ConfigEntry>();
            for (ConfigEntry configEntry : entry.getValue().entries()) {
                configEntries.add(new AlterConfigsRequest.ConfigEntry(configEntry.name(), configEntry.value()));
            }
            ConfigResource resource = entry.getKey();
            requestMap.put(this.configResourceToResource(resource), new AlterConfigsRequest.Config(configEntries));
        }
        long now = this.time.milliseconds();
        this.runnable.call(new Call("alterConfigs", this.calcDeadlineMs(now, options.timeoutMs()), new LeastLoadedNodeProvider()){

            @Override
            public AbstractRequest.Builder createRequest(int timeoutMs) {
                return new AlterConfigsRequest.Builder(requestMap, options.shouldValidateOnly());
            }

            @Override
            public void handleResponse(AbstractResponse abstractResponse) {
                AlterConfigsResponse response = (AlterConfigsResponse)abstractResponse;
                for (Map.Entry entry : futures.entrySet()) {
                    KafkaFutureImpl future = (KafkaFutureImpl)entry.getValue();
                    ApiException exception = response.errors().get(KafkaAdminClient.this.configResourceToResource((ConfigResource)entry.getKey())).exception();
                    if (exception != null) {
                        future.completeExceptionally(exception);
                        continue;
                    }
                    future.complete(null);
                }
            }

            @Override
            void handleFailure(Throwable throwable) {
                KafkaAdminClient.completeAllExceptionally(futures.values(), throwable);
            }
        }, now);
        return new AlterConfigsResult(new HashMap<ConfigResource, KafkaFuture<Void>>(futures));
    }

    private final class AdminClientRunnable
    implements Runnable {
        private List<Call> newCalls = new LinkedList<Call>();

        private AdminClientRunnable() {
        }

        private Integer checkMetadataReady(Integer prevMetadataVersion) {
            if (prevMetadataVersion != null && prevMetadataVersion.intValue() == KafkaAdminClient.this.metadata.version()) {
                return prevMetadataVersion;
            }
            Cluster cluster = KafkaAdminClient.this.metadata.fetch();
            if (cluster.nodes().isEmpty()) {
                log.trace("{}: metadata is not ready yet.  No cluster nodes found.", (Object)KafkaAdminClient.this.clientId);
                return KafkaAdminClient.this.metadata.requestUpdate();
            }
            if (cluster.controller() == null) {
                log.trace("{}: metadata is not ready yet.  No controller found.", (Object)KafkaAdminClient.this.clientId);
                return KafkaAdminClient.this.metadata.requestUpdate();
            }
            if (prevMetadataVersion != null) {
                log.trace("{}: metadata is now ready.", (Object)KafkaAdminClient.this.clientId);
            }
            return null;
        }

        private synchronized void timeoutNewCalls(TimeoutProcessor processor) {
            int numTimedOut = processor.handleTimeouts(this.newCalls, "Timed out waiting for a node assignment.");
            if (numTimedOut > 0) {
                log.debug("{}: timed out {} new calls.", (Object)KafkaAdminClient.this.clientId, (Object)numTimedOut);
            }
        }

        private void timeoutCallsToSend(TimeoutProcessor processor, Map<Node, List<Call>> callsToSend) {
            int numTimedOut = 0;
            for (List<Call> callList : callsToSend.values()) {
                numTimedOut += processor.handleTimeouts(callList, "Timed out waiting to send the call.");
            }
            if (numTimedOut > 0) {
                log.debug("{}: timed out {} call(s) with assigned nodes.", (Object)KafkaAdminClient.this.clientId, (Object)numTimedOut);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void chooseNodesForNewCalls(long now, Map<Node, List<Call>> callsToSend) {
            List<Call> newCallsToAdd = null;
            AdminClientRunnable adminClientRunnable = this;
            synchronized (adminClientRunnable) {
                if (this.newCalls.isEmpty()) {
                    return;
                }
                newCallsToAdd = this.newCalls;
                this.newCalls = new LinkedList<Call>();
            }
            for (Call call : newCallsToAdd) {
                this.chooseNodeForNewCall(now, callsToSend, call);
            }
        }

        private void chooseNodeForNewCall(long now, Map<Node, List<Call>> callsToSend, Call call) {
            Node node = call.nodeProvider.provide();
            if (node == null) {
                call.fail(now, new BrokerNotAvailableException(String.format("Error choosing node for %s: no node found.", call.callName)));
                return;
            }
            log.trace("{}: assigned {} to {}", new Object[]{KafkaAdminClient.this.clientId, call, node});
            KafkaAdminClient.getOrCreateListValue(callsToSend, node).add(call);
        }

        private long sendEligibleCalls(long now, Map<Node, List<Call>> callsToSend, Map<Integer, Call> correlationIdToCalls, Map<String, List<Call>> callsInFlight) {
            long pollTimeout = Long.MAX_VALUE;
            Iterator<Map.Entry<Node, List<Call>>> iter = callsToSend.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Node, List<Call>> entry = iter.next();
                List<Call> calls = entry.getValue();
                if (calls.isEmpty()) {
                    iter.remove();
                    continue;
                }
                Node node = entry.getKey();
                if (!KafkaAdminClient.this.client.ready(node, now)) {
                    long nodeTimeout = KafkaAdminClient.this.client.connectionDelay(node, now);
                    pollTimeout = Math.min(pollTimeout, nodeTimeout);
                    log.trace("{}: client is not ready to send to {}.  Must delay {} ms", new Object[]{KafkaAdminClient.this.clientId, node, nodeTimeout});
                    continue;
                }
                Call call = calls.remove(0);
                int timeoutMs = KafkaAdminClient.calcTimeoutMsRemainingAsInt(now, call.deadlineMs);
                AbstractRequest.Builder requestBuilder = null;
                try {
                    requestBuilder = call.createRequest(timeoutMs);
                }
                catch (Throwable throwable) {
                    call.fail(now, new KafkaException(String.format("Internal error sending %s to %s.", call.callName, node)));
                    continue;
                }
                ClientRequest clientRequest = KafkaAdminClient.this.client.newClientRequest(node.idString(), requestBuilder, now, true);
                log.trace("{}: sending {} to {}. correlationId={}", new Object[]{KafkaAdminClient.this.clientId, requestBuilder, node, clientRequest.correlationId()});
                KafkaAdminClient.this.client.send(clientRequest, now);
                KafkaAdminClient.getOrCreateListValue(callsInFlight, node.idString()).add(call);
                correlationIdToCalls.put(clientRequest.correlationId(), call);
            }
            return pollTimeout;
        }

        private void timeoutCallsInFlight(TimeoutProcessor processor, Map<String, List<Call>> callsInFlight) {
            int numTimedOut = 0;
            for (Map.Entry<String, List<Call>> entry : callsInFlight.entrySet()) {
                List<Call> contexts = entry.getValue();
                if (contexts.isEmpty()) continue;
                String nodeId = entry.getKey();
                Call call = contexts.get(0);
                if (!processor.callHasExpired(call)) continue;
                if (call.aborted) {
                    log.warn("{}: aborted call {} is still in callsInFlight.", (Object)KafkaAdminClient.this.clientId, (Object)call);
                    continue;
                }
                log.debug("{}: Closing connection to {} to time out {}", new Object[]{KafkaAdminClient.this.clientId, nodeId, call});
                call.aborted = true;
                KafkaAdminClient.this.client.disconnect(nodeId);
                ++numTimedOut;
            }
            if (numTimedOut > 0) {
                log.debug("{}: timed out {} call(s) in flight.", (Object)KafkaAdminClient.this.clientId, (Object)numTimedOut);
            }
        }

        private void handleResponses(long now, List<ClientResponse> responses, Map<String, List<Call>> callsInFlight, Map<Integer, Call> correlationIdToCall) {
            for (ClientResponse response : responses) {
                int correlationId = response.requestHeader().correlationId();
                Call call = correlationIdToCall.get(correlationId);
                if (call == null) {
                    log.error("Internal server error on {}: server returned information about unknown correlation ID {}.  requestHeader = {}", new Object[]{response.destination(), correlationId, response.requestHeader()});
                    KafkaAdminClient.this.client.disconnect(response.destination());
                    continue;
                }
                correlationIdToCall.remove(correlationId);
                List<Call> calls = callsInFlight.get(response.destination());
                if (calls == null || !calls.remove(call)) {
                    log.error("Internal server error on {}: ignoring call {} in correlationIdToCall that did not exist in callsInFlight", (Object)response.destination(), (Object)call);
                    continue;
                }
                if (response.versionMismatch() != null) {
                    call.fail(now, response.versionMismatch());
                    continue;
                }
                if (response.wasDisconnected()) {
                    call.fail(now, new DisconnectException(String.format("Cancelled %s request with correlation id %s due to node %s being disconnected", call.callName, correlationId, response.destination())));
                    continue;
                }
                try {
                    call.handleResponse(response.responseBody());
                    if (!log.isTraceEnabled()) continue;
                    log.trace("{}: {} got response {}", new Object[]{KafkaAdminClient.this.clientId, call, response.responseBody()});
                }
                catch (Throwable t) {
                    if (log.isTraceEnabled()) {
                        log.trace("{}: {} handleResponse failed with {}", new Object[]{KafkaAdminClient.this.clientId, call, KafkaAdminClient.prettyPrintException(t)});
                    }
                    call.fail(now, t);
                }
            }
        }

        private synchronized boolean threadShouldExit(long now, long curHardShutdownTimeMs, Map<Node, List<Call>> callsToSend, Map<Integer, Call> correlationIdToCalls) {
            if (this.newCalls.isEmpty() && callsToSend.isEmpty() && correlationIdToCalls.isEmpty()) {
                log.trace("{}: all work has been completed, and the I/O thread is now exiting.", (Object)KafkaAdminClient.this.clientId);
                return true;
            }
            if (now > curHardShutdownTimeMs) {
                log.info("{}: forcing a hard I/O thread shutdown.  Requests in progress will be aborted.", (Object)KafkaAdminClient.this.clientId);
                return true;
            }
            log.debug("{}: hard shutdown in {} ms.", (Object)KafkaAdminClient.this.clientId, (Object)(curHardShutdownTimeMs - now));
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long curHardShutdownTimeMs;
            HashMap<Node, List<Call>> callsToSend = new HashMap<Node, List<Call>>();
            HashMap<String, List<Call>> callsInFlight = new HashMap<String, List<Call>>();
            HashMap<Integer, Call> correlationIdToCalls = new HashMap<Integer, Call>();
            Integer prevMetadataVersion = null;
            long now = KafkaAdminClient.this.time.milliseconds();
            log.trace("{} thread starting", (Object)KafkaAdminClient.this.clientId);
            while ((curHardShutdownTimeMs = KafkaAdminClient.this.hardShutdownTimeMs.get()) == -1L || !this.threadShouldExit(now, curHardShutdownTimeMs, callsToSend, correlationIdToCalls)) {
                TimeoutProcessor timeoutProcessor = KafkaAdminClient.this.timeoutProcessorFactory.create(now);
                this.timeoutNewCalls(timeoutProcessor);
                this.timeoutCallsToSend(timeoutProcessor, callsToSend);
                this.timeoutCallsInFlight(timeoutProcessor, callsInFlight);
                long pollTimeout = Math.min(1200000, timeoutProcessor.nextTimeoutMs());
                if (curHardShutdownTimeMs != -1L) {
                    pollTimeout = Math.min(pollTimeout, curHardShutdownTimeMs - now);
                }
                if ((prevMetadataVersion = this.checkMetadataReady(prevMetadataVersion)) == null) {
                    this.chooseNodesForNewCalls(now, callsToSend);
                    pollTimeout = Math.min(pollTimeout, this.sendEligibleCalls(now, callsToSend, correlationIdToCalls, callsInFlight));
                }
                log.trace("{}: entering KafkaClient#poll(timeout={})", (Object)KafkaAdminClient.this.clientId, (Object)pollTimeout);
                List<ClientResponse> responses = KafkaAdminClient.this.client.poll(pollTimeout, now);
                log.trace("{}: KafkaClient#poll retrieved {} response(s)", (Object)KafkaAdminClient.this.clientId, (Object)responses.size());
                now = KafkaAdminClient.this.time.milliseconds();
                this.handleResponses(now, responses, callsInFlight, correlationIdToCalls);
            }
            int numTimedOut = 0;
            TimeoutProcessor timeoutProcessor = new TimeoutProcessor(Long.MAX_VALUE);
            AdminClientRunnable adminClientRunnable = this;
            synchronized (adminClientRunnable) {
                numTimedOut += timeoutProcessor.handleTimeouts(this.newCalls, "The AdminClient thread has exited.");
                this.newCalls = null;
            }
            if ((numTimedOut += timeoutProcessor.handleTimeouts(correlationIdToCalls.values(), "The AdminClient thread has exited.")) > 0) {
                log.debug("{}: timed out {} remaining operations.", (Object)KafkaAdminClient.this.clientId, (Object)numTimedOut);
            }
            Utils.closeQuietly(KafkaAdminClient.this.client, "KafkaClient");
            Utils.closeQuietly(KafkaAdminClient.this.metrics, "Metrics");
            log.debug("{}: exiting AdminClientRunnable thread.", (Object)KafkaAdminClient.this.clientId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enqueue(Call call, long now) {
            if (log.isDebugEnabled()) {
                log.debug("{}: queueing {} with a timeout {} ms from now.", new Object[]{KafkaAdminClient.this.clientId, call, call.deadlineMs - now});
            }
            boolean accepted = false;
            AdminClientRunnable adminClientRunnable = this;
            synchronized (adminClientRunnable) {
                if (this.newCalls != null) {
                    this.newCalls.add(call);
                    accepted = true;
                }
            }
            if (accepted) {
                KafkaAdminClient.this.client.wakeup();
            } else {
                log.debug("{}: the AdminClient thread has exited.  Timing out {}.", (Object)KafkaAdminClient.this.clientId, (Object)call);
                call.fail(Long.MAX_VALUE, new TimeoutException("The AdminClient thread has exited."));
            }
        }

        void call(Call call, long now) {
            if (KafkaAdminClient.this.hardShutdownTimeMs.get() != -1L) {
                log.debug("{}: the AdminClient is not accepting new calls.  Timing out {}.", (Object)KafkaAdminClient.this.clientId, (Object)call);
                call.fail(Long.MAX_VALUE, new TimeoutException("The AdminClient thread is not accepting new calls."));
            } else {
                this.enqueue(call, now);
            }
        }
    }

    static class TimeoutProcessor {
        private final long now;
        private int nextTimeoutMs;

        TimeoutProcessor(long now) {
            this.now = now;
            this.nextTimeoutMs = Integer.MAX_VALUE;
        }

        int handleTimeouts(Collection<Call> calls, String msg) {
            int numTimedOut = 0;
            Iterator<Call> iter = calls.iterator();
            while (iter.hasNext()) {
                Call call = iter.next();
                int remainingMs = KafkaAdminClient.calcTimeoutMsRemainingAsInt(this.now, call.deadlineMs);
                if (remainingMs < 0) {
                    call.fail(this.now, new TimeoutException(msg));
                    iter.remove();
                    ++numTimedOut;
                    continue;
                }
                this.nextTimeoutMs = Math.min(this.nextTimeoutMs, remainingMs);
            }
            return numTimedOut;
        }

        boolean callHasExpired(Call call) {
            int remainingMs = KafkaAdminClient.calcTimeoutMsRemainingAsInt(this.now, call.deadlineMs);
            if (remainingMs < 0) {
                return true;
            }
            this.nextTimeoutMs = Math.min(this.nextTimeoutMs, remainingMs);
            return false;
        }

        int nextTimeoutMs() {
            return this.nextTimeoutMs;
        }
    }

    static class TimeoutProcessorFactory {
        TimeoutProcessorFactory() {
        }

        TimeoutProcessor create(long now) {
            return new TimeoutProcessor(now);
        }
    }

    abstract class Call {
        private final String callName;
        private final long deadlineMs;
        private final NodeProvider nodeProvider;
        private int tries = 0;
        private boolean aborted = false;

        Call(String callName, long deadlineMs, NodeProvider nodeProvider) {
            this.callName = callName;
            this.deadlineMs = deadlineMs;
            this.nodeProvider = nodeProvider;
        }

        final void fail(long now, Throwable throwable) {
            if (this.aborted) {
                ++this.tries;
                if (log.isDebugEnabled()) {
                    log.debug("{} aborted at {} after {} attempt(s)", new Object[]{this, now, this.tries, new Exception(KafkaAdminClient.prettyPrintException(throwable))});
                }
                this.handleFailure(new TimeoutException("Aborted due to timeout."));
                return;
            }
            if (throwable instanceof UnsupportedVersionException && this.handleUnsupportedVersionException((UnsupportedVersionException)throwable)) {
                log.trace("{} attempting protocol downgrade.", (Object)this);
                KafkaAdminClient.this.runnable.enqueue(this, now);
                return;
            }
            ++this.tries;
            if (KafkaAdminClient.calcTimeoutMsRemainingAsInt(now, this.deadlineMs) < 0) {
                if (log.isDebugEnabled()) {
                    log.debug("{} timed out at {} after {} attempt(s)", new Object[]{this, now, this.tries, new Exception(KafkaAdminClient.prettyPrintException(throwable))});
                }
                this.handleFailure(throwable);
                return;
            }
            if (!(throwable instanceof RetriableException)) {
                if (log.isDebugEnabled()) {
                    log.debug("{} failed with non-retriable exception after {} attempt(s)", new Object[]{this, this.tries, new Exception(KafkaAdminClient.prettyPrintException(throwable))});
                }
                this.handleFailure(throwable);
                return;
            }
            if (this.tries > KafkaAdminClient.this.maxRetries) {
                if (log.isDebugEnabled()) {
                    log.debug("{} failed after {} attempt(s)", new Object[]{this, this.tries, new Exception(KafkaAdminClient.prettyPrintException(throwable))});
                }
                this.handleFailure(throwable);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("{} failed: {}.  Beginning retry #{}", new Object[]{this, KafkaAdminClient.prettyPrintException(throwable), this.tries});
            }
            KafkaAdminClient.this.runnable.enqueue(this, now);
        }

        abstract AbstractRequest.Builder createRequest(int var1);

        abstract void handleResponse(AbstractResponse var1);

        abstract void handleFailure(Throwable var1);

        boolean handleUnsupportedVersionException(UnsupportedVersionException exception) {
            return false;
        }

        public String toString() {
            return "Call(callName=" + this.callName + ", deadlineMs=" + this.deadlineMs + ")";
        }
    }

    private class LeastLoadedNodeProvider
    implements NodeProvider {
        private LeastLoadedNodeProvider() {
        }

        @Override
        public Node provide() {
            return KafkaAdminClient.this.client.leastLoadedNode(KafkaAdminClient.this.time.milliseconds());
        }
    }

    private class ControllerNodeProvider
    implements NodeProvider {
        private ControllerNodeProvider() {
        }

        @Override
        public Node provide() {
            return KafkaAdminClient.this.metadata.fetch().controller();
        }
    }

    private class ConstantNodeIdProvider
    implements NodeProvider {
        private final int nodeId;

        ConstantNodeIdProvider(int nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public Node provide() {
            return KafkaAdminClient.this.metadata.fetch().nodeById(this.nodeId);
        }
    }

    private static interface NodeProvider {
        public Node provide();
    }
}

