/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.bundle.shell;

import java.util.List;
import java.util.Map;
import org.apache.karaf.cellar.bundle.BundleState;
import org.apache.karaf.cellar.bundle.ClusterBundleEvent;
import org.apache.karaf.cellar.bundle.shell.BundleCommandSupport;
import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cluster", name="bundle-stop", description="Stop a bundle in a cluster group")
@Service
public class StopBundleCommand
extends BundleCommandSupport {
    @Reference
    private EventProducer eventProducer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            System.err.println("Cluster event producer is OFF");
            return null;
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            Map clusterBundles = this.clusterManager.getMap("org.apache.karaf.cellar.bundle.map." + this.groupName);
            List<String> bundles = this.selector(this.gatherBundles(true));
            for (String bundle : bundles) {
                BundleState state = (BundleState)clusterBundles.get(bundle);
                if (state == null) {
                    System.err.println("Bundle " + bundle + " not found in cluster group " + this.groupName);
                }
                String location = state.getLocation();
                CellarSupport support = new CellarSupport();
                support.setClusterManager(this.clusterManager);
                support.setGroupManager(this.groupManager);
                support.setConfigurationAdmin(this.configurationAdmin);
                if (!support.isAllowed(group, "bundle", location, EventType.OUTBOUND).booleanValue()) {
                    System.err.println("Bundle location " + location + " is blocked outbound for cluster group " + this.groupName);
                }
                state.setStatus(4);
                clusterBundles.put(bundle, state);
                String[] split = bundle.split("/");
                ClusterBundleEvent event = new ClusterBundleEvent(split[0], split[1], location, null, 4);
                event.setSourceGroup(group);
                event.setSourceNode(this.clusterManager.getNode());
                this.eventProducer.produce((Event)event);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return null;
    }

    public EventProducer getEventProducer() {
        return this.eventProducer;
    }

    public void setEventProducer(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }
}

