/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TrackingFileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackingFileManager.class);

    TrackingFileManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties read(File file) {
        Object object = this.getLock(file);
        synchronized (object) {
            block9: {
                Properties properties;
                FileLock lock = null;
                FileInputStream stream = null;
                try {
                    if (!file.exists()) {
                        Properties properties2 = null;
                        return properties2;
                    }
                    stream = new FileInputStream(file);
                    lock = this.lock(stream.getChannel(), Math.max(1L, file.length()), true);
                    Properties props = new Properties();
                    props.load(stream);
                    properties = props;
                    this.release(lock, file);
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to read tracking file {}", (Object)file, (Object)e);
                    break block9;
                }
                this.close(stream, file);
                return properties;
                finally {
                    this.release(lock, file);
                    this.close(stream, file);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties update(File file, Map<String, String> updates) {
        Properties props = new Properties();
        Object object = this.getLock(file);
        synchronized (object) {
            File directory = file.getParentFile();
            if (!directory.mkdirs() && !directory.exists()) {
                LOGGER.warn("Failed to create parent directories for tracking file {}", (Object)file);
                return props;
            }
            RandomAccessFile raf = null;
            FileLock lock = null;
            try {
                raf = new RandomAccessFile(file, "rw");
                lock = this.lock(raf.getChannel(), Math.max(1L, raf.length()), false);
                if (file.canRead()) {
                    byte[] buffer = new byte[(int)raf.length()];
                    raf.readFully(buffer);
                    ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                    props.load(stream);
                }
                for (Map.Entry<String, String> update : updates.entrySet()) {
                    if (update.getValue() == null) {
                        props.remove(update.getKey());
                        continue;
                    }
                    props.setProperty(update.getKey(), update.getValue());
                }
                ByteArrayOutputStream stream = new ByteArrayOutputStream(2048);
                LOGGER.debug("Writing tracking file {}", (Object)file);
                props.store(stream, "NOTE: This is a Maven Resolver internal implementation file, its format can be changed without prior notice.");
                raf.seek(0L);
                raf.write(stream.toByteArray());
                raf.setLength(raf.getFilePointer());
                this.release(lock, file);
                this.close(raf, file);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to write tracking file {}", (Object)file, (Object)e);
            }
            finally {
                this.release(lock, file);
                this.close(raf, file);
            }
        }
        return props;
    }

    private void release(FileLock lock, File file) {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (IOException e) {
                LOGGER.warn("Error releasing lock for tracking file {}", (Object)file, (Object)e);
            }
        }
    }

    private void close(Closeable closeable, File file) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error closing tracking file {}", (Object)file, (Object)e);
            }
        }
    }

    private Object getLock(File file) {
        try {
            return file.getCanonicalPath().intern();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to canonicalize path {}: {}", (Object)file, (Object)e.getMessage());
            return file.getAbsolutePath().intern();
        }
    }

    private FileLock lock(FileChannel channel, long size, boolean shared) throws IOException {
        FileLock lock = null;
        for (int attempts = 8; attempts >= 0; --attempts) {
            try {
                lock = channel.lock(0L, size, shared);
                break;
            }
            catch (OverlappingFileLockException e) {
                if (attempts <= 0) {
                    throw (IOException)new IOException().initCause(e);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        if (lock == null) {
            throw new IOException("Could not lock file");
        }
        return lock;
    }
}

