/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp.impl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.client.channel.ChannelSubsystem;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.subsystem.sftp.SftpVersionSelector;
import org.apache.sshd.client.subsystem.sftp.impl.AbstractSftpClient;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.subsystem.sftp.SftpConstants;
import org.apache.sshd.common.subsystem.sftp.extensions.ParserUtils;
import org.apache.sshd.common.subsystem.sftp.extensions.VersionsParser;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.NullOutputStream;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemEnvironment;

public class DefaultSftpClient
extends AbstractSftpClient {
    private final ClientSession clientSession;
    private final ChannelSubsystem channel;
    private final Map<Integer, Buffer> messages = new HashMap<Integer, Buffer>();
    private final AtomicInteger cmdId = new AtomicInteger(100);
    private final Buffer receiveBuffer = new ByteArrayBuffer();
    private final AtomicInteger versionHolder = new AtomicInteger(0);
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final NavigableMap<String, byte[]> extensions = new TreeMap<String, byte[]>(String.CASE_INSENSITIVE_ORDER);
    private final NavigableMap<String, byte[]> exposedExtensions = Collections.unmodifiableNavigableMap(this.extensions);
    private Charset nameDecodingCharset = DEFAULT_NAME_DECODING_CHARSET;

    public DefaultSftpClient(ClientSession clientSession, SftpVersionSelector initialVersionSelector) throws IOException {
        this.nameDecodingCharset = PropertyResolverUtils.getCharset((PropertyResolver)clientSession, (String)"sftp-name-decoding-charset", (Charset)DEFAULT_NAME_DECODING_CHARSET);
        this.clientSession = Objects.requireNonNull(clientSession, "No client session");
        this.channel = this.createSftpChannelSubsystem(clientSession);
        ((ConnectionService)clientSession.getService(ConnectionService.class)).registerChannel((Channel)this.channel);
        long initializationTimeout = clientSession.getLongProperty("sftp-channel-open-timeout", DEFAULT_CHANNEL_OPEN_TIMEOUT);
        this.channel.open().verify(initializationTimeout);
        this.channel.onClose(() -> {
            Map<Integer, Buffer> map = this.messages;
            synchronized (map) {
                this.closing.set(true);
                this.messages.notifyAll();
            }
            if (this.versionHolder.get() <= 0) {
                this.log.warn("onClose({}) closed before version negotiated", (Object)this.channel);
            }
        });
        try {
            this.init(clientSession, initialVersionSelector, initializationTimeout);
        }
        catch (IOException | RuntimeException e) {
            this.channel.close(true);
            throw e;
        }
    }

    @Override
    public int getVersion() {
        return this.versionHolder.get();
    }

    public ClientSession getClientSession() {
        return this.clientSession;
    }

    public ClientChannel getClientChannel() {
        return this.channel;
    }

    @Override
    public NavigableMap<String, byte[]> getServerExtensions() {
        return this.exposedExtensions;
    }

    @Override
    public Charset getNameDecodingCharset() {
        return this.nameDecodingCharset;
    }

    @Override
    public void setNameDecodingCharset(Charset nameDecodingCharset) {
        this.nameDecodingCharset = Objects.requireNonNull(nameDecodingCharset, "No charset provided");
    }

    @Override
    public boolean isClosing() {
        return this.closing.get();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() throws IOException {
        if (this.isOpen()) {
            this.channel.close(false);
        }
    }

    protected int data(byte[] buf, int start, int len) throws IOException {
        ByteArrayBuffer incoming = new ByteArrayBuffer(buf, start, len);
        if (this.receiveBuffer.available() > 0) {
            this.receiveBuffer.putBuffer((Readable)incoming);
            incoming = this.receiveBuffer;
        }
        int rpos = incoming.rpos();
        boolean traceEnabled = this.log.isTraceEnabled();
        int count = 1;
        while (this.receive((Buffer)incoming)) {
            if (traceEnabled) {
                this.log.trace("data({}) Processed {} data messages", (Object)this.getClientChannel(), (Object)count);
            }
            ++count;
        }
        int read = incoming.rpos() - rpos;
        this.receiveBuffer.compact();
        if (this.receiveBuffer != incoming && incoming.available() > 0) {
            this.receiveBuffer.putBuffer((Readable)incoming);
        }
        return read;
    }

    protected boolean receive(Buffer incoming) throws IOException {
        int rpos = incoming.rpos();
        int wpos = incoming.wpos();
        ClientSession session = this.getClientSession();
        session.resetIdleTimeout();
        if (wpos - rpos > 4) {
            int length = incoming.getInt();
            if (length < 5) {
                throw new IOException("Illegal sftp packet length: " + length);
            }
            if (length > 262144) {
                throw new StreamCorruptedException("Illogical sftp packet length: " + length);
            }
            if (wpos - rpos >= length + 4) {
                incoming.rpos(rpos);
                incoming.wpos(rpos + 4 + length);
                this.process(incoming);
                incoming.rpos(rpos + 4 + length);
                incoming.wpos(wpos);
                return true;
            }
        }
        incoming.rpos(rpos);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(Buffer incoming) throws IOException {
        ByteArrayBuffer buffer = new ByteArrayBuffer(incoming.available() + 64, false);
        buffer.putBuffer((Readable)incoming);
        int rpos = buffer.rpos();
        int length = buffer.getInt();
        int type = buffer.getUByte();
        Integer id = buffer.getInt();
        buffer.rpos(rpos);
        if (this.log.isTraceEnabled()) {
            this.log.trace("process({}) id={}, type={}, len={}", new Object[]{this.getClientChannel(), id, SftpConstants.getCommandMessageName(type), length});
        }
        Map<Integer, Buffer> map = this.messages;
        synchronized (map) {
            this.messages.put(id, (Buffer)buffer);
            this.messages.notifyAll();
        }
    }

    @Override
    public int send(int cmd, Buffer buffer) throws IOException {
        ByteArrayBuffer buf;
        int id = this.cmdId.incrementAndGet();
        int len = buffer.available();
        if (this.log.isTraceEnabled()) {
            this.log.trace("send({}) cmd={}, len={}, id={}", new Object[]{this.getClientChannel(), SftpConstants.getCommandMessageName(cmd), len, id});
        }
        int hdr = 9;
        if (buffer.rpos() >= hdr) {
            int wpos = buffer.wpos();
            int s = buffer.rpos() - hdr;
            buffer.rpos(s);
            buffer.wpos(s);
            buffer.putInt((long)(5 + len));
            buffer.putByte((byte)(cmd & 0xFF));
            buffer.putInt((long)id);
            buffer.wpos(wpos);
            buf = buffer;
        } else {
            buf = new ByteArrayBuffer(hdr + len);
            buf.putInt((long)(5 + len));
            buf.putByte((byte)(cmd & 0xFF));
            buf.putInt((long)id);
            buf.putBuffer((Readable)buffer);
        }
        IoOutputStream asyncIn = this.channel.getAsyncIn();
        IoWriteFuture writeFuture = asyncIn.writePacket((Buffer)buf);
        writeFuture.verify();
        return id;
    }

    @Override
    public Buffer receive(int id) throws IOException {
        ClientSession session = this.getClientSession();
        long idleTimeout = PropertyResolverUtils.getLongProperty((PropertyResolver)session, (String)"idle-timeout", (long)FactoryManager.DEFAULT_IDLE_TIMEOUT);
        if (idleTimeout <= 0L) {
            idleTimeout = FactoryManager.DEFAULT_IDLE_TIMEOUT;
        }
        boolean traceEnabled = this.log.isTraceEnabled();
        int count = 1;
        while (true) {
            if (this.isClosing() || !this.isOpen()) {
                throw new SshException("Channel is being closed");
            }
            long rcvStart = System.nanoTime();
            Buffer buffer = this.receive(id, idleTimeout);
            long rcvEnd = System.nanoTime();
            if (buffer != null) {
                return buffer;
            }
            long rcvDuration = TimeUnit.NANOSECONDS.toMillis(rcvEnd - rcvStart);
            idleTimeout = rcvDuration <= 0L ? --idleTimeout : (idleTimeout -= rcvDuration);
            if (idleTimeout <= 0L) {
                throw new SshException("Timeout expired while waiting for id=" + id);
            }
            if (traceEnabled) {
                this.log.trace("receive({}) check iteration #{} for id={} remain time={}", new Object[]{this, count, id, idleTimeout});
            }
            ++count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer receive(int id, long idleTimeout) throws IOException {
        Map<Integer, Buffer> map = this.messages;
        synchronized (map) {
            Buffer buffer = this.messages.remove(id);
            if (buffer != null) {
                return buffer;
            }
            if (idleTimeout > 0L) {
                try {
                    this.messages.wait(idleTimeout);
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException("Interrupted while waiting for messages").initCause(e);
                }
            }
        }
        return null;
    }

    protected void init(ClientSession session, SftpVersionSelector initialVersionSelector, long initializationTimeout) throws IOException {
        int initialVersion = initialVersionSelector == null ? 6 : initialVersionSelector.selectVersion(session, true, 6, SftpSubsystemEnvironment.SUPPORTED_SFTP_VERSIONS);
        ValidateUtils.checkState((boolean)SftpSubsystemEnvironment.SUPPORTED_SFTP_VERSIONS.contains(initialVersion), (String)"Unsupported initial version selected: %d", (long)initialVersion);
        ByteArrayBuffer buf = new ByteArrayBuffer(10);
        buf.putInt(5L);
        buf.putByte((byte)1);
        buf.putInt((long)initialVersion);
        boolean traceEnabled = this.log.isTraceEnabled();
        IoOutputStream asyncIn = this.channel.getAsyncIn();
        ClientChannel clientChannel = this.getClientChannel();
        if (traceEnabled) {
            this.log.trace("init({}) send SSH_FXP_INIT - initial version={}", (Object)clientChannel, (Object)initialVersion);
        }
        IoWriteFuture writeFuture = asyncIn.writePacket((Buffer)buf);
        writeFuture.verify();
        if (traceEnabled) {
            this.log.trace("init({}) wait for SSH_FXP_INIT respose (timeout={})", (Object)clientChannel, (Object)initializationTimeout);
        }
        Buffer buffer = this.waitForInitResponse(initializationTimeout);
        this.handleInitResponse(buffer);
    }

    protected void handleInitResponse(Buffer buffer) throws IOException {
        boolean traceEnabled = this.log.isTraceEnabled();
        ClientChannel clientChannel = this.getClientChannel();
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (traceEnabled) {
            this.log.trace("handleInitResponse({}) id={} type={} len={}", new Object[]{clientChannel, id, SftpConstants.getCommandMessageName(type), length});
        }
        if (type == 2) {
            if (id < 3 || id > 6) {
                throw new SshException("Unsupported sftp version " + id);
            }
            this.versionHolder.set(id);
            if (traceEnabled) {
                this.log.trace("handleInitResponse({}) version={}", (Object)clientChannel, (Object)this.versionHolder);
            }
            while (buffer.available() > 0) {
                String name = buffer.getString();
                byte[] data = buffer.getBytes();
                if (traceEnabled) {
                    this.log.trace("handleInitResponse({}) added extension={}", (Object)clientChannel, (Object)name);
                }
                this.extensions.put(name, data);
            }
        } else if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (traceEnabled) {
                this.log.trace("handleInitResponse({})[id={}] - status: {} [{}] {}", new Object[]{clientChannel, id, SftpConstants.getStatusName(substatus), lang, msg});
            }
            this.throwStatusException(1, id, substatus, msg, lang);
        } else {
            IOException err = this.handleUnexpectedPacket(1, 2, id, type, length, buffer);
            if (err != null) {
                throw err;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buffer waitForInitResponse(long initializationTimeout) throws IOException {
        ValidateUtils.checkTrue((initializationTimeout > 0L ? 1 : 0) != 0, (String)"Invalid initialization timeout: %d", (long)initializationTimeout);
        Map<Integer, Buffer> map = this.messages;
        synchronized (map) {
            long remainingTimeout = initializationTimeout;
            while (remainingTimeout > 0L && this.messages.isEmpty() && !this.isClosing() && this.isOpen()) {
                try {
                    long sleepStart = System.nanoTime();
                    this.messages.wait(remainingTimeout);
                    long sleepEnd = System.nanoTime();
                    long sleepDuration = sleepEnd - sleepStart;
                    long sleepMillis = TimeUnit.NANOSECONDS.toMillis(sleepDuration);
                    if (sleepMillis < 1L) {
                        --remainingTimeout;
                        continue;
                    }
                    remainingTimeout -= sleepMillis;
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException("Interrupted init() while " + remainingTimeout + " msec. remaining").initCause(e);
                }
            }
            if (this.isClosing() || !this.isOpen()) {
                throw new EOFException("Closing while await init message");
            }
            if (this.messages.isEmpty()) {
                throw new SocketTimeoutException("No incoming initialization response received within " + initializationTimeout + " msec.");
            }
            Set<Integer> ids = this.messages.keySet();
            Iterator iter = ids.iterator();
            Integer reqId = (Integer)iter.next();
            return this.messages.remove(reqId);
        }
    }

    public int negotiateVersion(SftpVersionSelector selector) throws IOException {
        boolean debugEnabled = this.log.isDebugEnabled();
        ClientChannel clientChannel = this.getClientChannel();
        int current = this.getVersion();
        if (selector == null) {
            if (debugEnabled) {
                this.log.debug("negotiateVersion({}) no selector to override current={}", (Object)clientChannel, (Object)current);
            }
            return current;
        }
        Map<String, Object> parsed = this.getParsedServerExtensions();
        Set<String> extensions = ParserUtils.supportedExtensions(parsed);
        List<Integer> availableVersions = Collections.emptyList();
        if (GenericUtils.size(extensions) > 0 && extensions.contains("version-select")) {
            VersionsParser.Versions vers = GenericUtils.isEmpty(parsed) ? null : (VersionsParser.Versions)parsed.get("versions");
            availableVersions = vers == null ? Collections.singletonList(current) : vers.resolveAvailableVersions(current);
        } else {
            availableVersions = Collections.singletonList(current);
        }
        ClientSession session = this.getClientSession();
        int selected = selector.selectVersion(session, false, current, availableVersions);
        if (debugEnabled) {
            this.log.debug("negotiateVersion({}) current={} {} -> {}", new Object[]{clientChannel, current, availableVersions, selected});
        }
        if (selected == current) {
            return current;
        }
        if (!availableVersions.contains(selected)) {
            throw new StreamCorruptedException("Selected version (" + selected + ") not part of available: " + availableVersions);
        }
        String verVal = String.valueOf(selected);
        ByteArrayBuffer buffer = new ByteArrayBuffer(4 + "version-select".length() + 4 + verVal.length() + 8, false);
        buffer.putString("version-select");
        buffer.putString(verVal);
        this.checkCommandStatus(200, (Buffer)buffer);
        this.versionHolder.set(selected);
        return selected;
    }

    protected ChannelSubsystem createSftpChannelSubsystem(ClientSession clientSession) {
        return new SftpChannelSubsystem();
    }

    protected class SftpChannelSubsystem
    extends ChannelSubsystem {
        protected SftpChannelSubsystem() {
            super("sftp");
        }

        protected void doOpen() throws IOException {
            String systemName = this.getSubsystem();
            Session session = this.getSession();
            boolean wantReply = this.getBooleanProperty("channel-subsystem-want-reply", true);
            Buffer buffer = session.createBuffer((byte)98, "subsystem".length() + systemName.length() + 32);
            buffer.putInt((long)this.getRecipient());
            buffer.putString("subsystem");
            buffer.putBoolean(wantReply);
            buffer.putString(systemName);
            this.addPendingRequest("subsystem", wantReply);
            this.writePacket(buffer);
            this.asyncIn = this.createAsyncInput(session);
            this.setOut(this.createStdOutputStream(session));
            this.setErr(this.createErrOutputStream(session));
        }

        protected ChannelAsyncOutputStream createAsyncInput(final Session session) {
            return new ChannelAsyncOutputStream((Channel)this, 94){

                protected CloseFuture doCloseGracefully() {
                    try {
                        SftpChannelSubsystem.this.sendEof();
                    }
                    catch (IOException e) {
                        session.exceptionCaught((Throwable)e);
                    }
                    return super.doCloseGracefully();
                }

                protected Buffer createSendBuffer(Buffer buffer, Channel channel, long length) {
                    if (buffer.rpos() >= 9 && length == (long)buffer.available()) {
                        int rpos = buffer.rpos();
                        int wpos = buffer.wpos();
                        buffer.rpos(rpos - 9);
                        buffer.wpos(rpos - 8);
                        buffer.putInt((long)channel.getRecipient());
                        buffer.putInt(length);
                        buffer.wpos(wpos);
                        ByteArrayBuffer buf = new ByteArrayBuffer(buffer.array(), buffer.rpos(), buffer.available());
                        buffer.rpos(buffer.wpos());
                        return buf;
                    }
                    return super.createSendBuffer(buffer, channel, length);
                }
            };
        }

        protected OutputStream createStdOutputStream(Session session) {
            return new OutputStream(){
                private final byte[] singleByte = new byte[1];

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(int b) throws IOException {
                    byte[] byArray = this.singleByte;
                    synchronized (this.singleByte) {
                        this.singleByte[0] = (byte)b;
                        this.write(this.singleByte);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    DefaultSftpClient.this.data(b, off, len);
                }
            };
        }

        protected OutputStream createErrOutputStream(Session session) {
            return new NullOutputStream();
        }
    }
}

