/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.script.FieldScript;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.elasticsearch.search.internal.SearchContext;

public final class ScriptFieldsFetchSubPhase
implements FetchSubPhase {
    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) throws IOException {
        if (!context.hasScriptFields()) {
            return;
        }
        hits = (SearchHit[])hits.clone();
        Arrays.sort(hits, Comparator.comparingInt(SearchHit::docId));
        int lastReaderId = -1;
        FieldScript[] leafScripts = null;
        List<ScriptFieldsContext.ScriptField> scriptFields = context.scriptFields().fields();
        IndexReader reader = context.searcher().getIndexReader();
        for (SearchHit hit : hits) {
            int readerId = ReaderUtil.subIndex((int)hit.docId(), (List)reader.leaves());
            LeafReaderContext leafReaderContext = (LeafReaderContext)reader.leaves().get(readerId);
            if (readerId != lastReaderId) {
                leafScripts = this.createLeafScripts(leafReaderContext, scriptFields);
                lastReaderId = readerId;
            }
            int docId = hit.docId() - leafReaderContext.docBase;
            for (int i = 0; i < leafScripts.length; ++i) {
                Object value;
                leafScripts[i].setDocument(docId);
                try {
                    value = leafScripts[i].execute();
                    CollectionUtils.ensureNoSelfReferences(value, "ScriptFieldsFetchSubPhase leaf script " + i);
                }
                catch (RuntimeException e) {
                    if (scriptFields.get(i).ignoreException()) continue;
                    throw e;
                }
                if (hit.fieldsOrNull() == null) {
                    hit.fields(new HashMap<String, DocumentField>(2));
                }
                String scriptFieldName = scriptFields.get(i).name();
                DocumentField hitField = hit.getFields().get(scriptFieldName);
                if (hitField != null) continue;
                List<Object> values = value instanceof Collection ? new ArrayList<Object>((Collection)value) : Collections.singletonList(value);
                hitField = new DocumentField(scriptFieldName, values);
                hit.getFields().put(scriptFieldName, hitField);
            }
        }
    }

    private FieldScript[] createLeafScripts(LeafReaderContext context, List<ScriptFieldsContext.ScriptField> scriptFields) {
        FieldScript[] scripts = new FieldScript[scriptFields.size()];
        for (int i = 0; i < scripts.length; ++i) {
            try {
                scripts[i] = scriptFields.get(i).script().newInstance(context);
                continue;
            }
            catch (IOException e1) {
                throw new IllegalStateException("Failed to load script " + scriptFields.get(i).name(), e1);
            }
        }
        return scripts;
    }
}

