/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.NormsFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;

public final class KeywordFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "keyword";
    private int ignoreAbove;

    protected KeywordFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, int ignoreAbove, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        assert (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) <= 0);
        this.ignoreAbove = ignoreAbove;
    }

    int ignoreAbove() {
        return this.ignoreAbove;
    }

    @Override
    protected KeywordFieldMapper clone() {
        return (KeywordFieldMapper)super.clone();
    }

    @Override
    public KeywordFieldType fieldType() {
        return (KeywordFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        XContentParser parser;
        String value = context.externalValueSet() ? context.externalValue().toString() : ((parser = context.parser()).currentToken() == XContentParser.Token.VALUE_NULL ? this.fieldType().nullValueAsString() : parser.textOrNull());
        if (value == null || value.length() > this.ignoreAbove) {
            return;
        }
        NamedAnalyzer normalizer = this.fieldType().normalizer();
        if (normalizer != null) {
            try (TokenStream ts = normalizer.tokenStream(this.name(), value);){
                CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
                ts.reset();
                if (!ts.incrementToken()) {
                    throw new IllegalStateException("The normalization token stream is expected to produce exactly 1 token, but got 0 for analyzer " + (Object)((Object)normalizer) + " and input \"" + value + "\"");
                }
                String newValue = termAtt.toString();
                if (ts.incrementToken()) {
                    throw new IllegalStateException("The normalization token stream is expected to produce exactly 1 token, but got 2+ for analyzer " + (Object)((Object)normalizer) + " and input \"" + value + "\"");
                }
                ts.end();
                value = newValue;
            }
        }
        BytesRef binaryValue = new BytesRef((CharSequence)value);
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            Field field = new Field(this.fieldType().name(), binaryValue, (IndexableFieldType)this.fieldType());
            fields.add((IndexableField)field);
            if (!this.fieldType().hasDocValues() && this.fieldType().omitNorms()) {
                this.createFieldNamesField(context, fields);
            }
        }
        if (this.fieldType().hasDocValues()) {
            fields.add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), binaryValue));
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
        super.doMerge(mergeWith);
        this.ignoreAbove = ((KeywordFieldMapper)mergeWith).ignoreAbove;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", this.fieldType().nullValue());
        }
        if (includeDefaults || this.ignoreAbove != Integer.MAX_VALUE) {
            builder.field("ignore_above", this.ignoreAbove);
        }
        if (this.fieldType().normalizer() != null) {
            builder.field("normalizer", this.fieldType().normalizer().name());
        } else if (includeDefaults) {
            builder.nullField("normalizer");
        }
        if (includeDefaults || this.fieldType().splitQueriesOnWhitespace) {
            builder.field("split_queries_on_whitespace", this.fieldType().splitQueriesOnWhitespace);
        }
    }

    public static final class KeywordFieldType
    extends StringFieldType {
        private NamedAnalyzer normalizer = null;
        private boolean splitQueriesOnWhitespace;

        public KeywordFieldType() {
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        protected KeywordFieldType(KeywordFieldType ref) {
            super(ref);
            this.normalizer = ref.normalizer;
            this.splitQueriesOnWhitespace = ref.splitQueriesOnWhitespace;
        }

        @Override
        public KeywordFieldType clone() {
            return new KeywordFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            KeywordFieldType other = (KeywordFieldType)((Object)o);
            return Objects.equals((Object)this.normalizer, (Object)other.normalizer) && this.splitQueriesOnWhitespace == other.splitQueriesOnWhitespace;
        }

        @Override
        public void checkCompatibility(MappedFieldType otherFT, List<String> conflicts) {
            super.checkCompatibility(otherFT, conflicts);
            KeywordFieldType other = (KeywordFieldType)otherFT;
            if (!Objects.equals((Object)this.normalizer, (Object)other.normalizer)) {
                conflicts.add("mapper [" + this.name() + "] has different [normalizer]");
            }
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + Objects.hash(new Object[]{this.normalizer, this.splitQueriesOnWhitespace});
        }

        @Override
        public String typeName() {
            return KeywordFieldMapper.CONTENT_TYPE;
        }

        private NamedAnalyzer normalizer() {
            return this.normalizer;
        }

        public void setNormalizer(NamedAnalyzer normalizer) {
            this.checkIfFrozen();
            this.normalizer = normalizer;
            this.setIndexAnalyzer(normalizer);
        }

        public boolean splitQueriesOnWhitespace() {
            return this.splitQueriesOnWhitespace;
        }

        public void setSplitQueriesOnWhitespace(boolean splitQueriesOnWhitespace) {
            this.checkIfFrozen();
            this.splitQueriesOnWhitespace = splitQueriesOnWhitespace;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            if (this.omitNorms()) {
                return new TermQuery(new Term("_field_names", this.name()));
            }
            return new NormsFieldExistsQuery(this.name());
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new DocValuesIndexFieldData.Builder();
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        @Override
        protected BytesRef indexedValueForSearch(Object value) {
            if (this.searchAnalyzer() == Lucene.KEYWORD_ANALYZER) {
                return super.indexedValueForSearch(value);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return this.searchAnalyzer().normalize(this.name(), value.toString());
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(propNode.toString());
                    iterator.remove();
                    continue;
                }
                if (propName.equals("ignore_above")) {
                    builder.ignoreAbove(XContentMapValues.nodeIntegerValue(propNode, -1));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("norms")) {
                    TypeParsers.parseNorms(builder, name, propNode);
                    iterator.remove();
                    continue;
                }
                if (propName.equals("eager_global_ordinals")) {
                    builder.eagerGlobalOrdinals(XContentMapValues.nodeBooleanValue(propNode, "eager_global_ordinals"));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("normalizer")) {
                    if (propNode != null) {
                        builder.normalizer(parserContext.getIndexAnalyzers(), propNode.toString());
                    }
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("split_queries_on_whitespace")) continue;
                builder.splitQueriesOnWhitespace(XContentMapValues.nodeBooleanValue(propNode, "split_queries_on_whitespace"));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, KeywordFieldMapper> {
        protected String nullValue = Defaults.NULL_VALUE;
        protected int ignoreAbove = Integer.MAX_VALUE;
        private IndexAnalyzers indexAnalyzers;
        private String normalizerName;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        @Override
        public KeywordFieldType fieldType() {
            return (KeywordFieldType)super.fieldType();
        }

        public Builder ignoreAbove(int ignoreAbove) {
            if (ignoreAbove < 0) {
                throw new IllegalArgumentException("[ignore_above] must be positive, got " + ignoreAbove);
            }
            this.ignoreAbove = ignoreAbove;
            return this;
        }

        @Override
        public Builder indexOptions(IndexOptions indexOptions) {
            if (indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS) > 0) {
                throw new IllegalArgumentException("The [keyword] field does not support positions, got [index_options]=" + FieldMapper.indexOptionToString(indexOptions));
            }
            return (Builder)super.indexOptions(indexOptions);
        }

        public Builder eagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
            this.fieldType().setEagerGlobalOrdinals(eagerGlobalOrdinals);
            return (Builder)this.builder;
        }

        public Builder splitQueriesOnWhitespace(boolean splitQueriesOnWhitespace) {
            this.fieldType().setSplitQueriesOnWhitespace(splitQueriesOnWhitespace);
            return (Builder)this.builder;
        }

        public Builder normalizer(IndexAnalyzers indexAnalyzers, String name) {
            this.indexAnalyzers = indexAnalyzers;
            this.normalizerName = name;
            return (Builder)this.builder;
        }

        @Override
        public KeywordFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            if (this.normalizerName != null) {
                NamedAnalyzer normalizer = this.indexAnalyzers.getNormalizer(this.normalizerName);
                if (normalizer == null) {
                    throw new MapperParsingException("normalizer [" + this.normalizerName + "] not found for field [" + this.name + "]");
                }
                this.fieldType().setNormalizer(normalizer);
                NamedAnalyzer searchAnalyzer = this.fieldType().splitQueriesOnWhitespace ? this.indexAnalyzers.getWhitespaceNormalizer(this.normalizerName) : normalizer;
                this.fieldType().setSearchAnalyzer(searchAnalyzer);
            } else if (this.fieldType().splitQueriesOnWhitespace) {
                this.fieldType().setSearchAnalyzer(new NamedAnalyzer("whitespace", AnalyzerScope.INDEX, (Analyzer)new WhitespaceAnalyzer()));
            }
            return new KeywordFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreAbove, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new KeywordFieldType();
        public static final String NULL_VALUE;
        public static final int IGNORE_ABOVE = Integer.MAX_VALUE;

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
            NULL_VALUE = null;
        }
    }
}

