/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.shell;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.shell.completer.AllNodeCompleter;
import org.apache.karaf.cellar.shell.ClusterCommandSupport;
import org.apache.karaf.cellar.utils.ping.Ping;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cluster", name="node-ping", description="Ping a cluster node")
@Service
public class NodePingCommand
extends ClusterCommandSupport {
    private static Long TIMEOUT = 10000L;
    @Argument(index=0, name="node", description="The ID or alias of the node to ping", required=true, multiValued=false)
    @Completion(value=AllNodeCompleter.class)
    String nodeIdOrAlias;
    @Argument(index=1, name="iterations", description="The number of iterations to perform", required=false, multiValued=false)
    Integer iterations = 10;
    @Argument(index=2, name="interval", description="The time in millis to wait between iteration", required=false, multiValued=false)
    Long interval = 1000L;

    protected Object doExecute() throws Exception {
        Node node = this.clusterManager.findNodeByIdOrAlias(this.nodeIdOrAlias);
        if (node == null) {
            System.out.println("Cluster node " + this.nodeIdOrAlias + " doesn't exist");
            return null;
        }
        String nodeName = node.getAlias();
        if (nodeName == null) {
            nodeName = node.getId();
        }
        System.out.println("PING " + nodeName);
        try {
            for (int i = 1; i <= this.iterations; ++i) {
                Long start = System.currentTimeMillis();
                Ping ping = new Ping(this.clusterManager.generateId());
                ping.setTimeout(this.timeout * 1000L);
                ping.setDestination(new HashSet<Node>(Arrays.asList(node)));
                this.executionContext.execute((org.apache.karaf.cellar.core.command.Command)ping);
                Long stop = System.currentTimeMillis();
                Long delay = stop - start;
                if (delay >= TIMEOUT) {
                    System.err.println(String.format("TIMEOUT %s %s", i, nodeName));
                } else {
                    System.out.println(String.format("from %s: req=%s time=%s ms", i, nodeName, delay));
                }
                Thread.sleep(this.interval);
            }
        }
        catch (InterruptedException i) {
        }
        catch (Exception e) {
            throw e;
        }
        return null;
    }
}

