/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.validator.ValidatorKey;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Validator;
import org.apache.camel.spi.ValidatorRegistry;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.CompoundIterator;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.LRUCacheFactory;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class DefaultValidatorRegistry
extends AbstractMap<ValidatorKey, Validator>
implements ValidatorRegistry<ValidatorKey> {
    private static final long serialVersionUID = 1L;
    private Map<ValidatorKey, Validator> dynamicMap;
    private Map<ValidatorKey, Validator> staticMap;
    private final CamelContext context;
    private int maxCacheSize;

    public DefaultValidatorRegistry(CamelContext context) throws Exception {
        this(context, new ArrayList<ValidatorDefinition>());
    }

    public DefaultValidatorRegistry(CamelContext context, List<ValidatorDefinition> definitions) throws Exception {
        this.maxCacheSize = CamelContextHelper.getMaximumValidatorCacheSize(context);
        this.dynamicMap = LRUCacheFactory.newLRUCache(this.maxCacheSize, this.maxCacheSize, false);
        this.staticMap = new ConcurrentHashMap<ValidatorKey, Validator>();
        this.context = context;
        for (ValidatorDefinition def : definitions) {
            Validator validator = def.createValidator(context);
            context.addService(validator);
            this.put(new ValidatorKey(new DataType(def.getType())), validator);
        }
    }

    @Override
    public Validator resolveValidator(ValidatorKey key) {
        Validator answer = this.get(key);
        if (answer == null && ObjectHelper.isNotEmpty(key.getType().getName())) {
            answer = this.get(new ValidatorKey(new DataType(key.getType().getModel())));
        }
        return answer;
    }

    @Override
    public void start() throws Exception {
        if (this.dynamicMap instanceof LRUCache) {
            ((LRUCache)this.dynamicMap).resetStatistics();
        }
    }

    @Override
    public Validator get(Object o) {
        Validator answer = this.staticMap.get(o);
        if (answer == null) {
            answer = this.dynamicMap.get(o);
        }
        return answer;
    }

    @Override
    public Validator put(ValidatorKey key, Validator validator) {
        Validator answer = this.staticMap.remove(key);
        if (answer != null) {
            this.staticMap.put(key, validator);
            return answer;
        }
        answer = this.dynamicMap.remove(key);
        if (answer != null) {
            this.dynamicMap.put(key, validator);
            return answer;
        }
        answer = this.context.isSetupRoutes() || this.context.isStartingRoutes() ? this.staticMap.put(key, validator) : this.dynamicMap.put(key, validator);
        return answer;
    }

    @Override
    public boolean containsKey(Object o) {
        return this.staticMap.containsKey(o) || this.dynamicMap.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.staticMap.containsValue(o) || this.dynamicMap.containsValue(o);
    }

    @Override
    public int staticSize() {
        return this.staticMap.size();
    }

    @Override
    public int dynamicSize() {
        return this.dynamicMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.staticMap.isEmpty() && this.dynamicMap.isEmpty();
    }

    @Override
    public Validator remove(Object o) {
        Validator answer = this.staticMap.remove(o);
        if (answer == null) {
            answer = this.dynamicMap.remove(o);
        }
        return answer;
    }

    @Override
    public void clear() {
        this.staticMap.clear();
        this.dynamicMap.clear();
    }

    @Override
    public Set<Map.Entry<ValidatorKey, Validator>> entrySet() {
        return new AbstractSet<Map.Entry<ValidatorKey, Validator>>(){

            @Override
            public Iterator<Map.Entry<ValidatorKey, Validator>> iterator() {
                return new CompoundIterator<Map.Entry<ValidatorKey, Validator>>(Arrays.asList(DefaultValidatorRegistry.this.staticMap.entrySet().iterator(), DefaultValidatorRegistry.this.dynamicMap.entrySet().iterator()));
            }

            @Override
            public int size() {
                return DefaultValidatorRegistry.this.staticMap.size() + DefaultValidatorRegistry.this.dynamicMap.size();
            }
        };
    }

    @Override
    public int getMaximumCacheSize() {
        return this.maxCacheSize;
    }

    @Override
    public void purge() {
        this.dynamicMap.clear();
    }

    @Override
    public void cleanUp() {
        if (this.dynamicMap instanceof LRUCache) {
            ((LRUCache)this.dynamicMap).cleanUp();
        }
    }

    @Override
    public boolean isStatic(DataType type) {
        return this.staticMap.containsKey(new ValidatorKey(type));
    }

    @Override
    public boolean isDynamic(DataType type) {
        return super.containsKey(new ValidatorKey(type));
    }

    @Override
    public void stop() throws Exception {
        ServiceHelper.stopServices(this.staticMap.values());
        ServiceHelper.stopServices(this.dynamicMap.values());
        this.purge();
    }

    @Override
    public String toString() {
        return "ValidatorRegistry for " + this.context.getName() + ", capacity: " + this.maxCacheSize;
    }
}

