/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.LoopProcessor;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;

@Metadata(label="eip,routing")
@XmlRootElement(name="loop")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LoopDefinition
extends ExpressionNode {
    @XmlAttribute
    private Boolean copy;
    @XmlAttribute
    private Boolean doWhile;

    public LoopDefinition() {
    }

    public LoopDefinition(Expression expression) {
        super(expression);
    }

    public LoopDefinition(Predicate predicate) {
        super(predicate);
        this.setDoWhile(true);
    }

    public LoopDefinition(ExpressionDefinition expression) {
        super(expression);
    }

    public LoopDefinition copy() {
        this.setCopy(true);
        return this;
    }

    public Boolean getCopy() {
        return this.copy;
    }

    public Boolean getDoWhile() {
        return this.doWhile;
    }

    public void setDoWhile(Boolean doWhile) {
        this.doWhile = doWhile;
    }

    public void setCopy(Boolean copy) {
        this.copy = copy;
    }

    public String toString() {
        return "Loop[" + this.getExpression() + " -> " + this.getOutputs() + "]";
    }

    @Override
    public String getLabel() {
        return "loop[" + this.getExpression() + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor output = this.createChildProcessor(routeContext, true);
        boolean isCopy = this.getCopy() != null && this.getCopy() != false;
        boolean isWhile = this.getDoWhile() != null && this.getDoWhile() != false;
        Predicate predicate = null;
        Expression expression = null;
        if (isWhile) {
            predicate = this.getExpression().createPredicate(routeContext);
        } else {
            expression = this.getExpression().createExpression(routeContext);
        }
        return new LoopProcessor(output, expression, predicate, isCopy);
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }
}

