/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.war.internal.WebAppVisitor;
import org.ops4j.pax.web.extender.war.internal.model.WebAppConstraintMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppCookieConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppErrorPage;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilter;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilterMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppInitParam;
import org.ops4j.pax.web.extender.war.internal.model.WebAppJspConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppJspServlet;
import org.ops4j.pax.web.extender.war.internal.model.WebAppListener;
import org.ops4j.pax.web.extender.war.internal.model.WebAppLoginConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppMimeMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppSecurityRole;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServlet;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServletContainerInitializer;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServletMapping;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class WebApp {
    static final Comparator<WebAppServlet> WEB_APP_SERVLET_COMPARATOR = (servlet1, servlet2) -> servlet1.getLoadOnStartup() - servlet2.getLoadOnStartup();
    private int deploymentState;
    private URL webXmlURL;
    private String displayName;
    private String contextName;
    private String rootPath;
    private String sessionTimeout;
    private Bundle bundle;
    private HttpContext httpContext;
    private final Map<String, WebAppServlet> servlets = new HashMap<String, WebAppServlet>();
    private final Map<String, Set<WebAppServletMapping>> servletMappings = new HashMap<String, Set<WebAppServletMapping>>();
    private final Map<String, WebAppFilter> filters = new LinkedHashMap<String, WebAppFilter>();
    private final Map<String, Set<WebAppFilterMapping>> filterMappings = new HashMap<String, Set<WebAppFilterMapping>>();
    private final List<String> orderedFilters = new ArrayList<String>();
    private final Set<WebAppInitParam> contextParams;
    private final Set<WebAppMimeMapping> mimeMappings;
    private final List<WebAppListener> listeners = new ArrayList<WebAppListener>();
    private final List<WebAppErrorPage> errorPages = new ArrayList<WebAppErrorPage>();
    private final List<String> welcomeFiles;
    private final List<String> virtualHostList;
    private final List<String> connectorList;
    private final List<WebAppConstraintMapping> constraintsMapping;
    private final List<WebAppSecurityRole> securityRoles;
    private final List<WebAppLoginConfig> loginConfig;
    private boolean metaDataComplete = false;
    private final List<WebAppServletContainerInitializer> servletContainerInitializers;
    private URL jettyWebXmlURL;
    private List<URL> webFragments;
    private boolean hasDependencies;
    private List<String> sessionTrackingModes;
    private WebAppCookieConfig sessionCookieConfig;
    private WebAppJspConfig jspConfigDescriptor;

    public WebApp() {
        this.contextParams = new HashSet<WebAppInitParam>();
        this.mimeMappings = new HashSet<WebAppMimeMapping>();
        this.welcomeFiles = new ArrayList<String>();
        this.constraintsMapping = new ArrayList<WebAppConstraintMapping>();
        this.securityRoles = new ArrayList<WebAppSecurityRole>();
        this.loginConfig = new ArrayList<WebAppLoginConfig>();
        this.virtualHostList = new ArrayList<String>();
        this.connectorList = new ArrayList<String>();
        this.servletContainerInitializers = new ArrayList<WebAppServletContainerInitializer>();
        this.sessionTrackingModes = new ArrayList<String>();
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    private WebAppInitParam getWebAppInitParam(String name) {
        for (WebAppInitParam p : this.contextParams) {
            if (!name.equals(p.getParamName())) continue;
            return p;
        }
        return null;
    }

    public void setContextName(String contextName) {
        NullArgumentException.validateNotNull(contextName, "Context name");
        this.contextName = contextName;
        WebAppInitParam prev = this.getWebAppInitParam("webapp.context");
        if (prev != null) {
            this.contextParams.remove(prev);
        }
        WebAppInitParam initParam = new WebAppInitParam();
        initParam.setParamName("webapp.context");
        initParam.setParamValue(contextName);
        this.contextParams.add(initParam);
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setRootPath(String rootPath) {
        NullArgumentException.validateNotNull(rootPath, "Root Path");
        this.rootPath = rootPath;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setSessionTimeout(String minutes) {
        this.sessionTimeout = minutes;
    }

    public String getSessionTimeout() {
        return this.sessionTimeout;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public void addServlet(WebAppServlet servlet) {
        NullArgumentException.validateNotNull(servlet, "Servlet");
        NullArgumentException.validateNotNull(servlet.getServletName(), "Servlet name");
        if (servlet instanceof WebAppJspServlet) {
            NullArgumentException.validateNotNull(((WebAppJspServlet)servlet).getJspPath(), "JSP-path");
        } else {
            NullArgumentException.validateNotNull(servlet.getServletClassName(), "Servlet class");
        }
        this.servlets.put(servlet.getServletName(), servlet);
        for (WebAppServletMapping mapping : this.getServletMappings(servlet.getServletName())) {
            servlet.addUrlPattern(mapping.getUrlPattern());
        }
    }

    public void addServletMapping(WebAppServletMapping servletMapping) {
        NullArgumentException.validateNotNull(servletMapping, "Servlet mapping");
        NullArgumentException.validateNotNull(servletMapping.getServletName(), "Servlet name");
        NullArgumentException.validateNotNull(servletMapping.getUrlPattern(), "Url pattern");
        Set<WebAppServletMapping> webAppServletMappings = this.servletMappings.get(servletMapping.getServletName());
        if (webAppServletMappings == null) {
            webAppServletMappings = new HashSet<WebAppServletMapping>();
            this.servletMappings.put(servletMapping.getServletName(), webAppServletMappings);
        }
        webAppServletMappings.add(servletMapping);
        WebAppServlet servlet = this.servlets.get(servletMapping.getServletName());
        if (servlet != null) {
            servlet.addUrlPattern(servletMapping.getUrlPattern());
        }
    }

    public List<WebAppServletMapping> getServletMappings(String servletName) {
        Set<WebAppServletMapping> webAppServletMappings = this.servletMappings.get(servletName);
        if (webAppServletMappings == null) {
            return new ArrayList<WebAppServletMapping>();
        }
        return new ArrayList<WebAppServletMapping>(webAppServletMappings);
    }

    public void addFilter(WebAppFilter filter) {
        NullArgumentException.validateNotNull(filter, "Filter");
        NullArgumentException.validateNotNull(filter.getFilterName(), "Filter name");
        NullArgumentException.validateNotNull(filter.getFilterClass(), "Filter class");
        this.filters.put(filter.getFilterName(), filter);
        for (WebAppFilterMapping mapping : this.getFilterMappings(filter.getFilterName())) {
            if (mapping.getUrlPattern() != null && mapping.getUrlPattern().trim().length() > 0) {
                filter.addUrlPattern(mapping.getUrlPattern());
            }
            if (mapping.getServletName() == null || mapping.getServletName().trim().length() <= 0) continue;
            filter.addServletName(mapping.getServletName());
        }
    }

    public void addFilterMapping(WebAppFilterMapping filterMapping) {
        Set<WebAppFilterMapping> webAppFilterMappings;
        NullArgumentException.validateNotNull(filterMapping, "Filter mapping");
        NullArgumentException.validateNotNull(filterMapping.getFilterName(), "Filter name");
        String filterName = filterMapping.getFilterName();
        if (!this.orderedFilters.contains(filterName)) {
            this.orderedFilters.add(filterName);
        }
        if ((webAppFilterMappings = this.filterMappings.get(filterName)) == null) {
            webAppFilterMappings = new HashSet<WebAppFilterMapping>();
            this.filterMappings.put(filterName, webAppFilterMappings);
        }
        webAppFilterMappings.add(filterMapping);
        WebAppFilter filter = this.filters.get(filterName);
        if (filter != null) {
            if (filterMapping.getUrlPattern() != null && filterMapping.getUrlPattern().trim().length() > 0) {
                filter.addUrlPattern(filterMapping.getUrlPattern());
            }
            if (filterMapping.getServletName() != null && filterMapping.getServletName().trim().length() > 0) {
                filter.addServletName(filterMapping.getServletName());
            }
            if (filterMapping.getDispatcherTypes() != null && !filterMapping.getDispatcherTypes().isEmpty()) {
                for (DispatcherType dispatcherType : filterMapping.getDispatcherTypes()) {
                    filter.addDispatcherType(dispatcherType);
                }
            }
        }
    }

    public List<WebAppFilterMapping> getFilterMappings(String filterName) {
        Set<WebAppFilterMapping> webAppFilterMappings = this.filterMappings.get(filterName);
        if (webAppFilterMappings == null) {
            return new ArrayList<WebAppFilterMapping>();
        }
        return new ArrayList<WebAppFilterMapping>(webAppFilterMappings);
    }

    public void addListener(WebAppListener listener) {
        NullArgumentException.validateNotNull(listener, "Listener");
        NullArgumentException.validateNotNull(listener.getListenerClass(), "Listener class");
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void addErrorPage(WebAppErrorPage errorPage) {
        NullArgumentException.validateNotNull(errorPage, "Error page");
        if (errorPage.getErrorCode() == null && errorPage.getExceptionType() == null) {
            throw new NullPointerException("At least one of error type or exception code must be set");
        }
        this.errorPages.add(errorPage);
    }

    public void addWelcomeFile(String welcomeFile) {
        NullArgumentException.validateNotEmpty(welcomeFile, "Welcome file");
        this.welcomeFiles.add(welcomeFile);
    }

    public String[] getWelcomeFiles() {
        return this.welcomeFiles.toArray(new String[this.welcomeFiles.size()]);
    }

    public void addContextParam(WebAppInitParam contextParam) {
        NullArgumentException.validateNotNull(contextParam, "Context param");
        NullArgumentException.validateNotNull(contextParam.getParamName(), "Context param name");
        NullArgumentException.validateNotNull(contextParam.getParamValue(), "Context param value");
        this.contextParams.add(contextParam);
    }

    public WebAppInitParam[] getContextParams() {
        return this.contextParams.toArray(new WebAppInitParam[this.contextParams.size()]);
    }

    public void addMimeMapping(WebAppMimeMapping mimeMapping) {
        NullArgumentException.validateNotNull(mimeMapping, "Mime mapping");
        NullArgumentException.validateNotNull(mimeMapping.getExtension(), "Mime mapping extension");
        NullArgumentException.validateNotNull(mimeMapping.getMimeType(), "Mime mapping type");
        this.mimeMappings.add(mimeMapping);
    }

    public void addConstraintMapping(WebAppConstraintMapping constraintMapping) {
        NullArgumentException.validateNotNull(constraintMapping, "constraint mapping");
        this.constraintsMapping.add(constraintMapping);
    }

    public WebAppConstraintMapping[] getConstraintMappings() {
        return this.constraintsMapping.toArray(new WebAppConstraintMapping[this.constraintsMapping.size()]);
    }

    public void addSecurityRole(WebAppSecurityRole securityRole) {
        NullArgumentException.validateNotNull(securityRole, "Security Role");
        this.securityRoles.add(securityRole);
    }

    public WebAppSecurityRole[] getSecurityRoles() {
        return this.securityRoles.toArray(new WebAppSecurityRole[this.securityRoles.size()]);
    }

    public void addLoginConfig(WebAppLoginConfig webApploginConfig) {
        NullArgumentException.validateNotNull(webApploginConfig, "Login Config");
        NullArgumentException.validateNotNull(webApploginConfig.getAuthMethod(), "Login Config Authorization Method");
        this.loginConfig.add(webApploginConfig);
    }

    public WebAppLoginConfig[] getLoginConfigs() {
        return this.loginConfig.toArray(new WebAppLoginConfig[this.loginConfig.size()]);
    }

    public WebAppMimeMapping[] getMimeMappings() {
        return this.mimeMappings.toArray(new WebAppMimeMapping[this.mimeMappings.size()]);
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public void accept(WebAppVisitor visitor) {
        visitor.visit(this);
        for (WebAppListener webAppListener : this.listeners) {
            visitor.visit(webAppListener);
        }
        if (!this.filters.isEmpty()) {
            ArrayList<WebAppFilter> remainingFilters = new ArrayList<WebAppFilter>(this.filters.values());
            for (String filterName : this.orderedFilters) {
                WebAppFilter filter = this.filters.get(filterName);
                visitor.visit(filter);
                remainingFilters.remove(filter);
            }
            for (WebAppFilter filter : remainingFilters) {
                visitor.visit(filter);
            }
        }
        if (!this.servlets.isEmpty()) {
            for (WebAppServlet webAppServlet : this.getSortedWebAppServlet()) {
                visitor.visit(webAppServlet);
            }
        }
        if (!this.constraintsMapping.isEmpty()) {
            for (WebAppConstraintMapping webAppConstraintMapping : this.constraintsMapping) {
                visitor.visit(webAppConstraintMapping);
            }
        }
        for (WebAppErrorPage webAppErrorPage : this.errorPages) {
            visitor.visit(webAppErrorPage);
        }
        visitor.end();
    }

    private Collection<WebAppServlet> getSortedWebAppServlet() {
        ArrayList<WebAppServlet> webAppServlets = new ArrayList<WebAppServlet>(this.servlets.values());
        Collections.sort(webAppServlets, WEB_APP_SERVLET_COMPARATOR);
        return webAppServlets;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{displayName=" + this.displayName + ",contextName=" + this.contextName + ",m_httpContext=" + this.httpContext + "}";
    }

    public URL getWebXmlURL() {
        return this.webXmlURL;
    }

    public void setWebXmlURL(URL webXmlURL) {
        this.webXmlURL = webXmlURL;
    }

    public void setJettyWebXmlURL(URL jettyWebXmlURL) {
        this.jettyWebXmlURL = jettyWebXmlURL;
    }

    public URL getJettyWebXmlURL() {
        return this.jettyWebXmlURL;
    }

    public boolean getHasDependencies() {
        return this.hasDependencies;
    }

    public void setHasDependencies(boolean hasDependencies) {
        this.hasDependencies = hasDependencies;
    }

    public void setVirtualHostList(List<String> virtualHostList) {
        this.virtualHostList.clear();
        this.virtualHostList.addAll(virtualHostList);
    }

    public List<String> getVirtualHostList() {
        return this.virtualHostList;
    }

    public void setConnectorList(List<String> connectorList) {
        this.connectorList.clear();
        this.connectorList.addAll(connectorList);
    }

    public List<String> getConnectorList() {
        return this.connectorList;
    }

    public int getDeploymentState() {
        return this.deploymentState;
    }

    public void setDeploymentState(int deploymentState) {
        this.deploymentState = deploymentState;
    }

    public void setMetaDataComplete(boolean metaDataComplete) {
        this.metaDataComplete = metaDataComplete;
    }

    public boolean getMetaDataComplete() {
        return this.metaDataComplete;
    }

    public WebAppServlet findServlet(String servletName) {
        if (this.servlets.containsKey(servletName)) {
            return this.servlets.get(servletName);
        }
        Collection<WebAppServlet> values = this.servlets.values();
        for (WebAppServlet webAppServlet : values) {
            String servletClassName = webAppServlet.getServletClassName();
            if (!servletName.equals(servletClassName)) continue;
            return webAppServlet;
        }
        return null;
    }

    public WebAppFilter findFilter(String filterName) {
        if (this.filters.containsKey(filterName)) {
            return this.filters.get(filterName);
        }
        return null;
    }

    public void addServletContainerInitializer(WebAppServletContainerInitializer servletContainerInitializer) {
        NullArgumentException.validateNotNull(servletContainerInitializer, "ServletContainerInitializer");
        this.servletContainerInitializers.add(servletContainerInitializer);
    }

    public List<WebAppServletContainerInitializer> getServletContainerInitializers() {
        return this.servletContainerInitializers;
    }

    public List<URL> getWebFragments() {
        return this.webFragments;
    }

    public void setWebFragments(List<URL> webFragments) {
        this.webFragments = webFragments;
    }

    public void addSessionTrackingMode(String sessionTrackingMode) {
        NullArgumentException.validateNotNull(sessionTrackingMode, "session tracking mode");
        this.sessionTrackingModes.add(sessionTrackingMode);
    }

    public List<String> getSessionTrackingModes() {
        return this.sessionTrackingModes;
    }

    public void setSessionCookieConfig(WebAppCookieConfig sessionCookieConfig) {
        this.sessionCookieConfig = sessionCookieConfig;
    }

    public void setJspConfigDescriptor(WebAppJspConfig webAppJspConfig) {
        this.jspConfigDescriptor = webAppJspConfig;
    }

    public WebAppJspConfig getJspConfigDescriptor() {
        return this.jspConfigDescriptor;
    }

    public WebAppCookieConfig getSessionCookieConfig() {
        return this.sessionCookieConfig;
    }
}

