/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.lists.rest;

import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.lists.UserList;
import org.apache.unomi.services.UserListService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@Produces(value={"application/json"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
public class UserListServiceEndPoint {
    private static final Logger logger = LoggerFactory.getLogger((String)UserListServiceEndPoint.class.getName());
    private UserListService userListService;

    public UserListServiceEndPoint() {
        logger.info("Initializing user list service endpoint...");
    }

    @WebMethod(exclude=true)
    public void setUserListService(UserListService userListService) {
        this.userListService = userListService;
    }

    @GET
    @Path(value="/")
    public PartialList<Metadata> getListMetadatas() {
        return this.userListService.getListMetadatas(0, 50, null);
    }

    @POST
    @Path(value="/query")
    public PartialList<Metadata> getListMetadatas(Query query) {
        return this.userListService.getListMetadatas(query);
    }

    @GET
    @Path(value="/{listId}")
    public UserList load(@PathParam(value="listId") String listId) {
        return this.userListService.load(listId);
    }

    @POST
    @Path(value="/")
    public void save(UserList list) {
        this.userListService.save(list);
    }

    @DELETE
    @Path(value="/{listId}")
    public void delete(@PathParam(value="listId") String listId) {
        this.userListService.delete(listId);
    }
}

