/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.features.shell;

import java.util.List;
import java.util.Map;
import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.cellar.core.shell.CellarCommandSupport;
import org.apache.karaf.cellar.core.shell.completer.AllGroupsCompleter;
import org.apache.karaf.cellar.features.ClusterFeaturesEvent;
import org.apache.karaf.cellar.features.FeatureState;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.command.completers.AllFeatureCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cluster", name="feature-uninstall", description="Uninstall a feature from a cluster group")
@Service
public class UninstallFeatureCommand
extends CellarCommandSupport {
    @Argument(index=0, name="group", description="The cluster group name", required=true, multiValued=false)
    @Completion(value=AllGroupsCompleter.class)
    String groupName;
    @Argument(index=1, name="features", description="The name and version of the features to uninstall. A feature id looks like name/version. The version is optional.", required=true, multiValued=true)
    @Completion(value=AllFeatureCompleter.class)
    List<String> features;
    @Option(name="-r", aliases={"--no-auto-refresh"}, description="Do not automatically refresh bundles", required=false, multiValued=false)
    boolean noRefresh;
    @Reference
    private EventProducer eventProducer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            System.err.println("Cluster event producer is OFF for this node");
            return null;
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            Map clusterFeatures = this.clusterManager.getMap("org.apache.karaf.cellar.features." + this.groupName);
            CellarSupport support = new CellarSupport();
            support.setGroupManager(this.groupManager);
            support.setClusterManager(this.clusterManager);
            support.setConfigurationAdmin(this.configurationAdmin);
            for (String feature : this.features) {
                String[] split = feature.split("/");
                String name = split[0];
                String version = null;
                if (split.length == 2) {
                    version = split[1];
                }
                FeatureState found = null;
                String foundKey = null;
                for (String k : clusterFeatures.keySet()) {
                    FeatureState f = (FeatureState)clusterFeatures.get(k);
                    foundKey = k;
                    if (version == null) {
                        if (!f.getName().equals(name)) continue;
                        found = f;
                        break;
                    }
                    if (!f.getName().equals(name) || !f.getVersion().equals(version)) continue;
                    found = f;
                    break;
                }
                if (found == null) {
                    if (version == null) {
                        throw new IllegalArgumentException("Feature " + name + " doesn't exist in cluster group " + this.groupName);
                    }
                    throw new IllegalArgumentException("Feature " + name + "/" + version + " doesn't exist in cluster group " + this.groupName);
                }
                if (!support.isAllowed(group, "feature", found.getName(), EventType.OUTBOUND).booleanValue()) {
                    System.err.println("Feature " + found.getName() + " is blocked outbound for cluster group " + this.groupName);
                    continue;
                }
                found.setInstalled(false);
                clusterFeatures.put(foundKey, found);
                ClusterFeaturesEvent event = new ClusterFeaturesEvent(found.getName(), found.getVersion(), this.noRefresh, false, false, false, FeatureEvent.EventType.FeatureUninstalled);
                event.setSourceGroup(group);
                this.eventProducer.produce((Event)event);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return null;
    }

    public EventProducer getEventProducer() {
        return this.eventProducer;
    }

    public void setEventProducer(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }
}

