/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;
import org.apache.camel.impl.cloud.DefaultServiceDiscovery;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public class StaticServiceDiscovery
extends DefaultServiceDiscovery {
    private final List<ServiceDefinition> services;

    public StaticServiceDiscovery() {
        this.services = new ArrayList<ServiceDefinition>();
    }

    public StaticServiceDiscovery(List<ServiceDefinition> servers) {
        this.services = new ArrayList<ServiceDefinition>(servers);
    }

    public void setServers(List<String> servers) {
        this.services.clear();
        servers.forEach(this::addServer);
    }

    public void addServers(String serviceName, List<String> servers) {
        for (String server : servers) {
            String host = StringHelper.before(server, ":");
            String port = StringHelper.after(server, ":");
            if (!ObjectHelper.isNotEmpty(host) || !ObjectHelper.isNotEmpty(port)) continue;
            this.addServer(serviceName, host, Integer.valueOf(port));
        }
    }

    public void setServers(String servers) {
        this.services.clear();
        this.addServer(servers);
    }

    public void addServer(ServiceDefinition server) {
        this.services.add(server);
    }

    public void addServer(String serverString) {
        String[] parts;
        for (String part : parts = serverString.split(",")) {
            String service = StringHelper.before(part, "@");
            if (service != null) {
                part = StringHelper.after(part, "@");
            }
            String host = StringHelper.before(part, ":");
            String port = StringHelper.after(part, ":");
            if (!ObjectHelper.isNotEmpty(host) || !ObjectHelper.isNotEmpty(port)) continue;
            this.addServer(service, host, Integer.valueOf(port));
        }
    }

    public void addServer(String host, int port) {
        this.addServer(null, host, port, null);
    }

    public void addServer(String name, String host, int port) {
        this.addServer(name, host, port, null);
    }

    public void addServer(String name, String host, int port, Map<String, String> meta) {
        this.services.add(new DefaultServiceDefinition(name, host, port, meta));
    }

    public void removeServer(String host, int port) {
        this.services.removeIf(s -> Objects.equals(host, s.getHost()) && port == s.getPort());
    }

    public void removeServer(String name, String host, int port) {
        this.services.removeIf(s -> Objects.equals(name, s.getName()) && Objects.equals(host, s.getHost()) && port == s.getPort());
    }

    @Override
    public List<ServiceDefinition> getServices(String name) {
        return Collections.unmodifiableList(this.services.stream().filter(s -> Objects.isNull(s.getName()) || Objects.equals(name, s.getName())).collect(Collectors.toList()));
    }

    public static StaticServiceDiscovery forServices(Collection<ServiceDefinition> definitions) {
        StaticServiceDiscovery discovery = new StaticServiceDiscovery();
        for (ServiceDefinition definition : definitions) {
            discovery.addServer(definition);
        }
        return discovery;
    }

    public static StaticServiceDiscovery forServices(ServiceDefinition ... definitions) {
        StaticServiceDiscovery discovery = new StaticServiceDiscovery();
        for (ServiceDefinition definition : definitions) {
            discovery.addServer(definition);
        }
        return discovery;
    }
}

