/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.turbine;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.RoleManager;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.model.turbine.TurbineAccessControlList;
import org.apache.fulcrum.security.model.turbine.TurbineModelManager;
import org.apache.fulcrum.security.model.turbine.entity.TurbineRole;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUserGroupRole;
import org.apache.fulcrum.security.util.FulcrumSecurityException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.RoleSet;

public class TurbineAccessControlListImpl
implements TurbineAccessControlList {
    private static final long serialVersionUID = 2678947159949477950L;
    private Map<Group, RoleSet> roleSets;
    private Map<Group, PermissionSet> permissionSets;
    private Group globalGroup;
    private GroupManager groupManager;
    private GroupSet groupSet = new GroupSet();
    private RoleSet roleSet = new RoleSet();
    private PermissionSet permissionSet = new PermissionSet();
    private transient Logger logger;

    public TurbineAccessControlListImpl(Set<? extends TurbineUserGroupRole> turbineUserGroupRoleSet, GroupManager groupManager, RoleManager roleManager, TurbineModelManager modelManager, Logger logger) throws FulcrumSecurityException {
        this.roleSets = new HashMap<Group, RoleSet>();
        this.permissionSets = new HashMap<Group, PermissionSet>();
        this.groupManager = groupManager;
        this.logger = logger;
        for (TurbineUserGroupRole turbineUserGroupRole : turbineUserGroupRoleSet) {
            Group group = turbineUserGroupRole.getGroup();
            if (this.logger != null && this.groupManager != null && group.getClass() != this.groupManager.getGroupInstance().getClass()) {
                this.logger.warn("Turbine group classes do not match, some lookup might fail, check in componentConfiguration.xml. Expected class: " + this.groupManager.getGroupInstance().getClass() + ", actual class: " + group.getClass());
            }
            this.groupSet.add(group);
            Role role = turbineUserGroupRole.getRole();
            if (!this.roleSet.containsId(role.getId())) {
                if (roleManager != null) {
                    role = roleManager.getRoleById(role.getId());
                }
                this.roleSet.add(role);
            } else {
                role = (Role)this.roleSet.getById(role.getId());
            }
            if (this.roleSets.containsKey(group)) {
                this.roleSets.get(group).add(role);
            } else {
                RoleSet rs = new RoleSet();
                rs.add(role);
                this.roleSets.put(group, rs);
            }
            if (!(role instanceof TurbineRole)) continue;
            PermissionSet ps = ((TurbineRole)role).getPermissions();
            this.permissionSet.add(ps);
            if (this.permissionSets.containsKey(group)) {
                this.permissionSets.get(group).add(ps);
                continue;
            }
            this.permissionSets.put(group, ps);
        }
        if (modelManager != null) {
            this.globalGroup = modelManager.getGlobalGroup();
        }
    }

    @Override
    public RoleSet getRoles(Group group) {
        if (group == null) {
            return null;
        }
        return this.roleSets.get(group);
    }

    @Override
    public RoleSet getRoles() {
        return this.getRoles(this.globalGroup);
    }

    @Override
    public PermissionSet getPermissions(Group group) {
        if (group == null) {
            return null;
        }
        return this.permissionSets.get(group);
    }

    @Override
    public PermissionSet getPermissions() {
        return this.getPermissions(this.globalGroup);
    }

    @Override
    public boolean hasRole(Role role, Group group) {
        RoleSet set = this.getRoles(group);
        if (set == null || role == null) {
            return false;
        }
        return set.contains(role);
    }

    @Override
    public boolean hasRole(Role role, GroupSet groupset) {
        if (role == null) {
            return false;
        }
        for (Group group : groupset) {
            RoleSet roles = this.getRoles(group);
            if (roles == null || !roles.contains(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRole(String roleName, String groupName) {
        try {
            return this.hasRole((Role)this.roleSet.getByName(roleName), (Group)this.groupSet.getByName(groupName));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasRole(String rolename, GroupSet groupset) {
        try {
            return this.hasRole((Role)this.roleSet.getByName(rolename), groupset);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasRole(Role role) {
        return this.hasRole(role, this.globalGroup);
    }

    @Override
    public boolean hasRole(String role) {
        try {
            return this.hasRole((Role)this.roleSet.getByName(role));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasPermission(Permission permission, Group group) {
        PermissionSet set = this.getPermissions(group);
        if (set == null || permission == null) {
            return false;
        }
        return set.contains(permission);
    }

    @Override
    public boolean hasPermission(Permission permission, GroupSet groupset) {
        if (permission == null) {
            return false;
        }
        for (Group group : groupset) {
            PermissionSet permissions = this.getPermissions(group);
            if (permissions == null || !permissions.contains(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPermission(String permission, String group) {
        try {
            return this.hasPermission((Permission)this.permissionSet.getByName(permission), (Group)this.groupSet.getByName(group));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasPermission(String permission, Group group) {
        try {
            return this.hasPermission((Permission)this.permissionSet.getByName(permission), group);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasPermission(String permissionName, GroupSet groupset) {
        Permission permission;
        try {
            permission = (Permission)this.permissionSet.getByName(permissionName);
        }
        catch (Exception e) {
            return false;
        }
        if (permission == null) {
            return false;
        }
        for (Group group : groupset) {
            PermissionSet permissions = this.getPermissions(group);
            if (permissions == null || !permissions.contains(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return this.hasPermission(permission, this.globalGroup);
    }

    @Override
    public boolean hasPermission(String permission) {
        try {
            return this.hasPermission((Permission)this.permissionSet.getByName(permission));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Group[] getAllGroups() {
        try {
            return this.groupManager != null ? this.groupManager.getAllGroups().toArray((A[])new Group[0]) : new Group[]{};
        }
        catch (FulcrumSecurityException e) {
            return new Group[0];
        }
    }

    @Override
    public GroupSet getGroupSet() {
        return this.groupSet;
    }
}

