/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.util.TurbineException;

public class JobQueue<J extends JobEntry> {
    private Vector<J> queue = new Vector(10);

    public J getNext() {
        if (this.queue.size() > 0) {
            return (J)((JobEntry)this.queue.elementAt(0));
        }
        return null;
    }

    public J getJob(J je) {
        int index = -1;
        if (je != null) {
            index = this.queue.indexOf(je);
        }
        if (index < 0) {
            return null;
        }
        return (J)((JobEntry)this.queue.elementAt(index));
    }

    public Vector<J> list() {
        if (this.queue != null && this.queue.size() > 0) {
            return (Vector)this.queue.clone();
        }
        return null;
    }

    public synchronized void add(J je) {
        this.queue.addElement(je);
        this.sortQueue();
    }

    public synchronized void batchLoad(List<J> jobEntries) {
        if (jobEntries != null) {
            this.queue.addAll(jobEntries);
            this.sortQueue();
        }
    }

    public synchronized void remove(J je) {
        this.queue.removeElement(je);
        this.sortQueue();
    }

    public synchronized void modify(J je) throws TurbineException {
        this.remove(je);
        je.calcRunTime();
        this.add(je);
        this.sortQueue();
    }

    public synchronized void updateQueue(J je) throws TurbineException {
        je.calcRunTime();
        this.sortQueue();
    }

    private void sortQueue() {
        Comparator aComparator = (o1, o2) -> {
            Long time1 = o1.getNextRuntime();
            Long time2 = o2.getNextRuntime();
            return time1.compareTo(time2);
        };
        Collections.sort(this.queue, aComparator);
    }
}

