/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.services.BaseService;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.InstantiationException;
import org.apache.turbine.services.Service;
import org.apache.turbine.services.ServiceBroker;
import org.apache.turbine.services.TurbineServiceProvider;

public abstract class BaseServiceBroker
implements ServiceBroker {
    private final Map<String, Class<?>> mapping = new LinkedHashMap();
    private final Hashtable<String, Service> services = new Hashtable();
    private Configuration configuration;
    public static final String SERVICE_PREFIX = "services.";
    public static final String CLASSNAME_SUFFIX = ".classname";
    private final Hashtable<String, Object> serviceObjects = new Hashtable();
    private static Log log = LogFactory.getLog(BaseServiceBroker.class);
    private String applicationRoot;
    private final Hashtable<String, Service> serviceProviderInstanceMap = new Hashtable();

    protected BaseServiceBroker() {
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void init() throws InitializationException {
        this.initMapping();
        this.initServices(false);
    }

    public void setServiceObject(String name, Object value) {
        this.serviceObjects.put(name, value);
    }

    public Object getServiceObject(String name) {
        return this.serviceObjects.get(name);
    }

    private boolean checkForInterface(Class<?> checkIfc, Class<?>[] interfaces) {
        for (Class<?> ifc : interfaces) {
            if (ifc == checkIfc) {
                return true;
            }
            Class<?>[] subInterfaces = ifc.getInterfaces();
            if (!this.checkForInterface(checkIfc, subInterfaces)) continue;
            return true;
        }
        return false;
    }

    protected void initMapping() throws InitializationException {
        LinkedHashMap<String, String> earlyInitFlags = new LinkedHashMap<String, String>();
        Iterator keys = this.configuration.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String[] keyParts = StringUtils.split((String)key, (String)".");
            if (keyParts.length != 3 || !(keyParts[0] + ".").equals(SERVICE_PREFIX) || !("." + keyParts[2]).equals(CLASSNAME_SUFFIX)) continue;
            String serviceKey = keyParts[1];
            log.info((Object)("Added Mapping for Service: " + serviceKey));
            if (this.mapping.containsKey(serviceKey)) continue;
            String className = this.configuration.getString(key);
            try {
                Class<?> clazz = Class.forName(className);
                this.mapping.put(serviceKey, clazz);
                if (!this.checkForInterface(TurbineServiceProvider.class, clazz.getInterfaces())) continue;
                log.info((Object)("Found a TurbineServiceProvider: " + serviceKey + " - initializing it early"));
                earlyInitFlags.put(SERVICE_PREFIX + serviceKey + ".earlyInit", "true");
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (OutOfMemoryError t) {
                throw t;
            }
            catch (ClassNotFoundException e) {
                throw new InitializationException("Class " + className + " is unavailable. Check your jars and classes.", e);
            }
            catch (NoClassDefFoundError e) {
                throw new InitializationException("Class " + className + " is unavailable. Check your jars and classes.", e);
            }
        }
        for (Map.Entry entry : earlyInitFlags.entrySet()) {
            this.configuration.setProperty((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean isRegistered(String serviceName) {
        return this.services.get(serviceName) != null;
    }

    public Iterator<String> getServiceNames() {
        return this.mapping.keySet().iterator();
    }

    public Iterator<String> getServiceNames(String prefix) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>(this.mapping.keySet());
        Iterator key = keys.iterator();
        while (key.hasNext()) {
            if (((String)key.next()).startsWith(prefix)) continue;
            key.remove();
        }
        return keys.iterator();
    }

    @Override
    public synchronized void initService(String name) throws InitializationException {
        Service instance = this.getServiceInstance(name);
        if (!instance.getInit()) {
            instance.init();
        }
    }

    public void initServices() {
        try {
            this.initServices(false);
        }
        catch (InstantiationException notThrown) {
            log.debug((Object)"Caught non fatal exception", (Throwable)notThrown);
        }
        catch (InitializationException notThrown) {
            log.debug((Object)"Caught non fatal exception", (Throwable)notThrown);
        }
    }

    public void initServices(boolean report) throws InstantiationException, InitializationException {
        if (report) {
            Iterator<String> names = this.getServiceNames();
            while (names.hasNext()) {
                this.doInitService(names.next());
            }
        } else {
            Iterator<String> names = this.getServiceNames();
            while (names.hasNext()) {
                try {
                    this.doInitService(names.next());
                }
                catch (InstantiationException e) {
                    log.error((Object)e);
                }
                catch (InitializationException e) {
                    log.error((Object)e);
                }
            }
        }
        log.info((Object)"Finished initializing all services!");
    }

    private void doInitService(String name) throws InstantiationException, InitializationException {
        if (this.getConfiguration(name).getBoolean("earlyInit", false)) {
            log.info((Object)("Start Initializing service (early): " + name));
            this.initService(name);
            log.info((Object)("Finish Initializing service (early): " + name));
        }
    }

    @Override
    public synchronized void shutdownService(String name) {
        try {
            Service service = this.getServiceInstance(name);
            if (service != null && service.getInit()) {
                service.shutdown();
                if (service.getInit() && service instanceof BaseService) {
                    ((BaseService)service).setInit(false);
                }
            }
        }
        catch (InstantiationException e) {
            log.error((Object)("Shutdown of a nonexistent Service '" + name + "' was requested"), (Throwable)e);
        }
    }

    @Override
    public void shutdownServices() {
        log.info((Object)"Shutting down all services!");
        String serviceName2 = null;
        ArrayList<String> reverseServicesList = new ArrayList<String>();
        Iterator<String> serviceNames = this.getServiceNames();
        while (serviceNames.hasNext()) {
            serviceName2 = serviceNames.next();
            reverseServicesList.add(0, serviceName2);
        }
        for (String serviceName2 : reverseServicesList) {
            log.info((Object)("Shutting down service: " + serviceName2));
            this.shutdownService(serviceName2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getService(String name) throws InstantiationException {
        if (this.isLocalService(name)) {
            try {
                Service service = this.getServiceInstance(name);
                if (!service.getInit()) {
                    Class<?> clazz = service.getClass();
                    synchronized (clazz) {
                        if (!service.getInit()) {
                            log.info((Object)("Start Initializing service (late): " + name));
                            service.init();
                            log.info((Object)("Finish Initializing service (late): " + name));
                        }
                    }
                }
                if (!service.getInit()) {
                    throw new InitializationException("init() failed to initialize service " + name);
                }
                return service;
            }
            catch (InitializationException e) {
                throw new InstantiationException("Service " + name + " failed to initialize", e);
            }
        }
        if (this.isNonLocalService(name)) {
            return this.getNonLocalService(name);
        }
        throw new InstantiationException("ServiceBroker: unknown service " + name + " requested");
    }

    protected Service getServiceInstance(String name) throws InstantiationException {
        Service service = this.services.get(name);
        if (service == null) {
            if (!this.isLocalService(name)) {
                throw new InstantiationException("ServiceBroker: unknown service " + name + " requested");
            }
            try {
                Class<?> clazz = this.mapping.get(name);
                try {
                    service = (Service)clazz.newInstance();
                    if (service instanceof TurbineServiceProvider) {
                        this.serviceProviderInstanceMap.put(name, service);
                    }
                }
                catch (ClassCastException e) {
                    throw new InstantiationException("Class " + clazz + " doesn't implement the Service interface", e);
                }
                catch (ThreadDeath t) {
                    throw t;
                }
                catch (OutOfMemoryError t) {
                    throw t;
                }
                catch (Throwable t) {
                    throw new InstantiationException("Failed to instantiate " + clazz, t);
                }
            }
            catch (InstantiationException e) {
                throw new InstantiationException("Failed to instantiate service " + name, e);
            }
            service.setServiceBroker(this);
            service.setName(name);
            this.services.put(name, service);
        }
        return service;
    }

    @Override
    public Configuration getConfiguration(String name) {
        return this.configuration.subset(SERVICE_PREFIX + name);
    }

    public void setApplicationRoot(String applicationRoot) {
        this.applicationRoot = applicationRoot;
    }

    public String getApplicationRoot() {
        return this.applicationRoot;
    }

    protected boolean isLocalService(String name) {
        return this.mapping.containsKey(name);
    }

    protected boolean isNonLocalService(String name) {
        String serviceName = null;
        TurbineServiceProvider turbineServiceProvider = null;
        Enumeration<String> list = this.serviceProviderInstanceMap.keys();
        while (list.hasMoreElements()) {
            serviceName = list.nextElement();
            turbineServiceProvider = (TurbineServiceProvider)this.getService(serviceName);
            if (!turbineServiceProvider.exists(name)) continue;
            return true;
        }
        return false;
    }

    protected Object getNonLocalService(String name) throws InstantiationException {
        String serviceName = null;
        TurbineServiceProvider turbineServiceProvider = null;
        Enumeration<String> list = this.serviceProviderInstanceMap.keys();
        while (list.hasMoreElements()) {
            serviceName = list.nextElement();
            turbineServiceProvider = (TurbineServiceProvider)this.getService(serviceName);
            if (!turbineServiceProvider.exists(name)) continue;
            return turbineServiceProvider.get(name);
        }
        throw new InstantiationException("ServiceBroker: unknown non-local service " + name + " requested");
    }
}

