/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.interceptor.baseservice;

import java.io.File;
import java.util.HashSet;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.Reconfigurable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorContext;
import org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorService;
import org.apache.fulcrum.yaafi.framework.util.StringUtils;

public class BaseInterceptorServiceImpl
extends AbstractLogEnabled
implements AvalonInterceptorService,
Contextualizable,
Reconfigurable {
    private static final String WILDCARD = "*";
    private HashSet serviceSet = new HashSet();
    private boolean isEnabled;
    private String serviceName;
    private ServiceManager serviceManager;
    private File serviceApplicationDir;
    private File serviceTempDir;
    private ClassLoader classLoader;

    public void contextualize(Context context) throws ContextException {
        this.serviceName = (String)context.get((Object)"urn:avalon:name");
        this.serviceApplicationDir = (File)context.get((Object)"urn:avalon:home");
        this.serviceTempDir = (File)context.get((Object)"urn:avalon:temp");
        this.classLoader = (ClassLoader)context.get((Object)"urn:avalon:classloader");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.isEnabled = configuration.getChild("isEnabled").getValueAsBoolean(false);
        Configuration[] serviceConfigList = configuration.getChild("services").getChildren("service");
        if (serviceConfigList.length == 0) {
            this.getServiceSet().add(WILDCARD);
        } else {
            for (int i = 0; i < serviceConfigList.length; ++i) {
                String name = serviceConfigList[i].getAttribute("name", null);
                String shorthand = serviceConfigList[i].getAttribute("shorthand", null);
                if (!StringUtils.isEmpty(name)) {
                    this.getServiceSet().add(name);
                }
                if (StringUtils.isEmpty(shorthand)) continue;
                this.getServiceSet().add(shorthand);
            }
        }
    }

    public void reconfigure(Configuration configuration) throws ConfigurationException {
        this.getServiceSet().clear();
    }

    @Override
    public void onEntry(AvalonInterceptorContext avalonInterceptorContext) {
    }

    @Override
    public void onError(AvalonInterceptorContext avalonInterceptorContext, Throwable t) {
    }

    @Override
    public void onExit(AvalonInterceptorContext avalonInterceptorContext, Object result) {
    }

    protected boolean isEnabled() {
        return this.isEnabled;
    }

    protected boolean isServiceMonitored(AvalonInterceptorContext avalonInterceptorContext) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.getServiceSet().contains(WILDCARD)) {
            return true;
        }
        if (this.getServiceSet().contains(avalonInterceptorContext.getServiceName())) {
            return true;
        }
        return this.getServiceSet().contains(avalonInterceptorContext.getServiceShorthand());
    }

    protected File getServiceApplicationDir() {
        return this.serviceApplicationDir;
    }

    protected ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    protected String getServiceName() {
        return this.serviceName;
    }

    protected File getServiceTempDir() {
        return this.serviceTempDir;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected File makeAbsoluteFile(String name) {
        File result = new File(name);
        if (!result.isAbsolute()) {
            result = new File(this.getServiceApplicationDir(), name);
        }
        return result;
    }

    private HashSet getServiceSet() {
        return this.serviceSet;
    }
}

