/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.model.XmlField;
import org.apache.fulcrum.intake.validator.BooleanValidator;

public class BooleanField
extends Field<Boolean> {
    private static final long serialVersionUID = 6689670469518374083L;

    public BooleanField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    @Override
    public void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        this.defaultValue = Boolean.valueOf(prop);
    }

    @Override
    public void setEmptyValue(String prop) {
        this.emptyValue = null;
        if (prop == null) {
            return;
        }
        this.emptyValue = Boolean.valueOf(prop);
    }

    @Override
    protected Object getSafeEmptyValue() {
        if (this.isMultiValued) {
            return new boolean[0];
        }
        return null == this.getEmptyValue() ? Boolean.FALSE : (Boolean)this.getEmptyValue();
    }

    @Override
    protected String getDefaultValidator() {
        return BooleanValidator.class.getName();
    }

    @Override
    protected void doSetValue() {
        if (this.isMultiValued) {
            Boolean[] inputs = this.parser.getBooleanObjects(this.getKey());
            boolean[] values = new boolean[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                values[i] = inputs[i] == null ? ((Boolean)this.getEmptyValue()).booleanValue() : inputs[i].booleanValue();
            }
            this.setTestValue(values);
        } else {
            this.setTestValue(this.parser.getBooleanObject(this.getKey(), (Boolean)this.getEmptyValue()));
        }
    }

    public boolean booleanValue() {
        boolean result = false;
        try {
            result = (Boolean)this.getValue();
        }
        catch (Exception e) {
            this.log.error("Error getting boolean value " + this.getValue(), (Throwable)e);
        }
        return result;
    }
}

