/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.security;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.om.security.Group;
import org.apache.turbine.util.security.SecuritySet;

public class GroupSet
extends SecuritySet<Group> {
    private static final long serialVersionUID = -80412911083063489L;

    public GroupSet() {
    }

    public GroupSet(Collection<Group> groups) {
        this.add(groups);
    }

    public boolean add(Group group) {
        boolean res = this.contains(group);
        this.nameMap.put(group.getName(), group);
        this.idMap.put(group.getIdAsObj(), group);
        return res;
    }

    public boolean add(Collection<Group> groups) {
        boolean res = false;
        for (Group g : groups) {
            res |= this.add(g);
        }
        return res;
    }

    public boolean add(GroupSet groupSet) {
        boolean res = false;
        for (Group g : groupSet) {
            res |= this.add(g);
        }
        return res;
    }

    public boolean remove(Group group) {
        boolean res = this.contains(group);
        this.nameMap.remove(group.getName());
        this.idMap.remove(group.getIdAsObj());
        return res;
    }

    public boolean contains(Group group) {
        return this.nameMap.containsValue(group);
    }

    public Group getGroupByName(String groupName) {
        return StringUtils.isNotEmpty((String)groupName) ? (Group)this.nameMap.get(groupName) : null;
    }

    public Group getGroupById(int groupId) {
        return groupId != 0 ? (Group)this.idMap.get(new Integer(groupId)) : null;
    }

    public Group[] getGroupsArray() {
        return this.getSet().toArray(new Group[0]);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("GroupSet: ");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Group g = (Group)it.next();
            sb.append('[');
            sb.append(g.getName());
            sb.append(" -> ");
            sb.append(g.getIdAsObj());
            sb.append(']');
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

