/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.util.RunData;

public class TurbineConfig
implements ServletConfig,
ServletContext,
Initializable,
Disposable {
    public static final String CONFIGURATION_PATH_KEY = "configuration";
    public static final String PROPERTIES_PATH_KEY = "properties";
    public static final String PROPERTIES_PATH_DEFAULT = "/WEB-INF/conf/TurbineResources.properties";
    protected File root;
    protected Map<String, Object> attributes;
    protected Map<String, String> initParams;
    private Turbine turbine;
    private final Log log = LogFactory.getLog(this.getClass());

    public TurbineConfig(String path, Map<String, Object> attributes, Map<String, String> initParams) {
        this.root = new File(path);
        this.attributes = attributes;
        this.initParams = initParams;
    }

    public TurbineConfig(String path, Map<String, String> initParams) {
        this(path, new HashMap<String, Object>(0), initParams);
    }

    public TurbineConfig(String path, String properties) {
        this(path, new HashMap<String, String>(1));
        this.initParams.put(PROPERTIES_PATH_KEY, properties);
    }

    public void initialize() {
        try {
            this.turbine = new Turbine();
            this.turbine.init(this);
        }
        catch (Exception e) {
            this.log.error((Object)"TurbineConfig: Initialization failed", (Throwable)e);
        }
    }

    public void init(RunData data) {
        if (this.turbine != null) {
            this.turbine.init(data);
        }
    }

    public void dispose() {
        if (this.turbine != null) {
            this.turbine.destroy();
        }
    }

    public Turbine getTurbine() {
        return this.turbine;
    }

    public ServletContext getServletContext() {
        return this;
    }

    public String getRealPath(String path) {
        String result = null;
        File f = new File(this.root, path);
        if (this.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("TurbineConfig.getRealPath: path '");
            sb.append(path);
            sb.append("' translated to '");
            sb.append(f.getPath());
            sb.append("' ");
            sb.append(f.exists() ? "" : "not ");
            sb.append("found");
            this.log.debug((Object)sb.toString());
        }
        if (f.exists()) {
            result = f.getPath();
        } else {
            this.log.error((Object)("getRealPath(\"" + path + "\") is undefined, returning null"));
        }
        return result;
    }

    public String getInitParameter(String name) {
        return this.initParams.get(name);
    }

    public Enumeration getInitParameterNames() {
        return new Vector<String>(this.initParams.keySet()).elements();
    }

    public String getServletName() {
        return "Turbine";
    }

    public String getServletContextName() {
        return "Turbine";
    }

    public String getContextPath() {
        return "/turbine";
    }

    public URL getResource(String s) throws MalformedURLException {
        return new URL("file://" + this.getRealPath(s));
    }

    public InputStream getResourceAsStream(String s) {
        try {
            FileInputStream fis = new FileInputStream(this.getRealPath(s));
            return new BufferedInputStream(fis);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Deprecated
    public void log(Exception e, String m) {
        this.log.info((Object)m, (Throwable)e);
    }

    public void log(String m) {
        this.log.info((Object)m);
    }

    public void log(String m, Throwable t) {
        this.log.info((Object)m, t);
    }

    public Object getAttribute(String s) {
        return this.attributes.get(s);
    }

    public Enumeration getAttributeNames() {
        return new Vector<String>(this.attributes.keySet()).elements();
    }

    public ServletContext getContext(String s) {
        throw new UnsupportedOperationException();
    }

    public int getMajorVersion() {
        throw new UnsupportedOperationException();
    }

    public String getMimeType(String s) {
        throw new UnsupportedOperationException();
    }

    public int getMinorVersion() {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getNamedDispatcher(String s) {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        throw new UnsupportedOperationException();
    }

    public Set getResourcePaths(String s) {
        throw new UnsupportedOperationException();
    }

    public String getServerInfo() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Servlet getServlet(String s) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Enumeration getServletNames() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Enumeration getServlets() {
        throw new UnsupportedOperationException();
    }

    public void removeAttribute(String s) {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(String s, Object o) {
        throw new UnsupportedOperationException();
    }
}

