/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.ldap;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.om.security.Group;
import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.om.security.TurbineGroup;
import org.apache.turbine.om.security.TurbinePermission;
import org.apache.turbine.om.security.TurbineRole;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.security.BaseSecurityService;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.services.security.ldap.LDAPSecurityConstants;
import org.apache.turbine.services.security.ldap.LDAPUserManager;
import org.apache.turbine.util.security.AccessControlList;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.EntityExistsException;
import org.apache.turbine.util.security.GroupSet;
import org.apache.turbine.util.security.PermissionSet;
import org.apache.turbine.util.security.RoleSet;
import org.apache.turbine.util.security.UnknownEntityException;

public class LDAPSecurityService
extends BaseSecurityService {
    private static Log log = LogFactory.getLog(LDAPSecurityService.class);

    @Override
    public AccessControlList getACL(User user) throws DataBackendException, UnknownEntityException {
        if (!TurbineSecurity.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getName() + "' does not exist");
        }
        try {
            Hashtable<Group, RoleSet> roles = new Hashtable<Group, RoleSet>();
            Hashtable<Group, PermissionSet> permissions = new Hashtable<Group, PermissionSet>();
            this.lockShared();
            for (Group group : this.getAllGroups()) {
                RoleSet groupRoles = this.getRoles(user, group);
                roles.put(group, groupRoles);
                PermissionSet groupPermissions = new PermissionSet();
                for (Role role : groupRoles) {
                    PermissionSet rolePermissions = this.getPermissions(role);
                    groupPermissions.add(rolePermissions);
                }
                permissions.put(group, groupPermissions);
            }
            AccessControlList accessControlList = this.getAclInstance(roles, permissions);
            return accessControlList;
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to build ACL for user '" + user.getName() + "'", e);
        }
        finally {
            this.unlockShared();
        }
    }

    @Override
    public synchronized void grant(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        try {
            this.lockExclusive();
            String userName = user.getName();
            String roleName = role.getName();
            String groupName = group.getName();
            if (!this.accountExists(user)) {
                throw new UnknownEntityException("User '" + userName + "' does not exist");
            }
            if (!this.checkExists(role)) {
                throw new UnknownEntityException("Role '" + roleName + "' does not exist");
            }
            if (!this.checkExists(group)) {
                throw new UnknownEntityException("Group '" + groupName + "' does not exist");
            }
            String dn = "turbineGroupName=" + groupName + "," + LDAPSecurityConstants.getNameAttribute() + "=" + userName + "," + LDAPSecurityConstants.getBaseSearch();
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(new BasicAttribute("turbineRoleName", roleName));
            attrs.put(new BasicAttribute("objectClass", "turbineUserGroup"));
            attrs.put(new BasicAttribute("turbineUserUniqueId", userName));
            try {
                ctx.bind(dn, null, (Attributes)attrs);
            }
            catch (NameAlreadyBoundException ex) {
                attrs = new BasicAttributes();
                attrs.put(new BasicAttribute("turbineRoleName", roleName));
                ctx.modifyAttributes(dn, 1, (Attributes)attrs);
            }
        }
        catch (NamingException ex) {
            throw new DataBackendException("NamingException caught", ex);
        }
        finally {
            this.unlockExclusive();
        }
    }

    @Override
    public synchronized void revoke(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        try {
            this.lockExclusive();
            String userName = user.getName();
            String roleName = role.getName();
            String groupName = group.getName();
            if (!this.accountExists(user)) {
                throw new UnknownEntityException("User '" + userName + "' does not exist");
            }
            if (!this.checkExists(role)) {
                throw new UnknownEntityException("Role '" + roleName + "' does not exist");
            }
            if (!this.checkExists(group)) {
                throw new UnknownEntityException("Group '" + groupName + "' does not exist");
            }
            String dn = "turbineGroupName=" + groupName + "," + LDAPSecurityConstants.getNameAttribute() + "=" + userName + "," + LDAPSecurityConstants.getBaseSearch();
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(new BasicAttribute("turbineRoleName", roleName));
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            ctx.modifyAttributes(dn, 3, (Attributes)attrs);
        }
        catch (NamingException ex) {
            throw new DataBackendException("NamingException caught", ex);
        }
        finally {
            this.unlockExclusive();
        }
    }

    @Override
    public synchronized void grant(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        try {
            this.lockExclusive();
            String roleName = role.getName();
            String permName = permission.getName();
            if (!this.checkExists(role)) {
                throw new UnknownEntityException("Role '" + roleName + "' does not exist");
            }
            if (!this.checkExists(permission)) {
                throw new UnknownEntityException("Permission '" + permName + "' does not exist");
            }
            String dn = "turbineRoleName=" + roleName + "," + LDAPSecurityConstants.getBaseSearch();
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(new BasicAttribute("turbinePermissionName", permName));
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            ctx.modifyAttributes(dn, 1, (Attributes)attrs);
        }
        catch (NamingException ex) {
            throw new DataBackendException("NamingException caught", ex);
        }
        finally {
            this.unlockExclusive();
        }
    }

    @Override
    public synchronized void revoke(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        try {
            this.lockExclusive();
            String roleName = role.getName();
            String permName = permission.getName();
            if (!this.checkExists(role)) {
                throw new UnknownEntityException("Role '" + roleName + "' does not exist");
            }
            if (!this.checkExists(permission)) {
                throw new UnknownEntityException("Permission '" + permName + "' does not exist");
            }
            String dn = "turbineRoleName=" + roleName + "," + LDAPSecurityConstants.getBaseSearch();
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(new BasicAttribute("turbinePermissionName", permName));
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            ctx.modifyAttributes(dn, 3, (Attributes)attrs);
        }
        catch (NamingException ex) {
            throw new DataBackendException("NamingException caught", ex);
        }
        finally {
            this.unlockExclusive();
        }
    }

    public Group getNewGroup(String groupName) {
        return new TurbineGroup(groupName);
    }

    public Role getNewRole(String roleName) {
        return new TurbineRole(roleName);
    }

    public Permission getNewPermission(String permissionName) {
        return new TurbinePermission(permissionName);
    }

    @Override
    public GroupSet getGroups(Object criteria) throws DataBackendException {
        Vector<Group> groups = new Vector<Group>();
        try {
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            String baseSearch = LDAPSecurityConstants.getBaseSearch();
            String filter = "(objectclass=turbineGroup)";
            SearchControls ctls = new SearchControls();
            NamingEnumeration<SearchResult> answer = ctx.search(baseSearch, filter, ctls);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attribs = sr.getAttributes();
                Attribute attr = attribs.get("turbineGroupName");
                if (attr == null || attr.get() == null) continue;
                Group group = this.getNewGroup(attr.get().toString());
                groups.add(group);
            }
        }
        catch (NamingException ex) {
            throw new DataBackendException("NamingException caught", ex);
        }
        return new GroupSet(groups);
    }

    private RoleSet getRoles(User user, Group group) throws DataBackendException {
        Vector<Role> roles = new Vector<Role>(0);
        try {
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            String baseSearch = LDAPSecurityConstants.getBaseSearch();
            String filter = "(& ";
            filter = filter + "(objectclass=turbineUserGroup)";
            filter = filter + "(turbineUserUniqueId=" + user.getName() + ")";
            filter = filter + "(turbineGroupName=" + group.getName() + ")";
            filter = filter + ")";
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            NamingEnumeration<SearchResult> answer = ctx.search(baseSearch, filter, ctls);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attribs = sr.getAttributes();
                Attribute attr = attribs.get("turbineRoleName");
                if (attr != null) {
                    NamingEnumeration<?> values = attr.getAll();
                    while (values.hasMore()) {
                        Role role = this.getNewRole(values.next().toString());
                        roles.add(role);
                    }
                    continue;
                }
                log.error((Object)"Role doesn't have a name");
            }
        }
        catch (NamingException ex) {
            throw new DataBackendException("NamingException caught:", ex);
        }
        return new RoleSet(roles);
    }

    @Override
    public RoleSet getRoles(Object criteria) throws DataBackendException {
        Vector<Role> roles = new Vector<Role>(0);
        try {
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            String baseSearch = LDAPSecurityConstants.getBaseSearch();
            String filter = "(objectclass=turbineRole)";
            SearchControls ctls = new SearchControls();
            NamingEnumeration<SearchResult> answer = ctx.search(baseSearch, filter, ctls);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attribs = sr.getAttributes();
                Attribute attr = attribs.get("turbineRoleName");
                if (attr != null && attr.get() != null) {
                    Role role = this.getNewRole(attr.get().toString());
                    roles.add(role);
                    continue;
                }
                log.error((Object)"Role doesn't have a name");
            }
        }
        catch (NamingException ex) {
            throw new DataBackendException("NamingException caught", ex);
        }
        return new RoleSet(roles);
    }

    @Override
    public PermissionSet getPermissions(Object criteria) throws DataBackendException {
        Vector<Permission> permissions = new Vector<Permission>();
        try {
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            String baseSearch = LDAPSecurityConstants.getBaseSearch();
            String filter = "(objectClass=turbinePermission)";
            SearchControls ctls = new SearchControls();
            NamingEnumeration<SearchResult> answer = ctx.search(baseSearch, filter, ctls);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attribs = sr.getAttributes();
                Attribute attr = attribs.get("turbinePermissionName");
                if (attr != null && attr.get() != null) {
                    Permission perm = this.getNewPermission(attr.get().toString());
                    permissions.add(perm);
                    continue;
                }
                log.error((Object)"Permission doesn't have a name");
            }
        }
        catch (NamingException ex) {
            throw new DataBackendException("The LDAP server specified is unavailable", ex);
        }
        return new PermissionSet(permissions);
    }

    @Override
    public PermissionSet getPermissions(Role role) throws DataBackendException, UnknownEntityException {
        Hashtable<String, Permission> permissions = new Hashtable<String, Permission>();
        try {
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            String baseSearch = LDAPSecurityConstants.getBaseSearch();
            String filter = "(& ";
            filter = filter + "(objectClass=turbineRole)";
            filter = filter + "(turbineRoleName=" + role.getName() + ")";
            filter = filter + ")";
            SearchControls ctls = new SearchControls();
            NamingEnumeration<SearchResult> answer = ctx.search(baseSearch, filter, ctls);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attribs = sr.getAttributes();
                Attribute attr = attribs.get("turbinePermissionName");
                if (attr == null) continue;
                NamingEnumeration<?> values = attr.getAll();
                while (values.hasMore()) {
                    String permName = values.next().toString();
                    Permission perm = this.getNewPermission(permName);
                    permissions.put(perm.getName(), perm);
                }
            }
        }
        catch (NamingException ex) {
            throw new DataBackendException("The LDAP server specified is unavailable", ex);
        }
        return new PermissionSet(permissions.values());
    }

    @Override
    public void saveGroup(Group group) throws DataBackendException, UnknownEntityException {
    }

    @Override
    public void saveRole(Role role) throws DataBackendException, UnknownEntityException {
    }

    @Override
    public void savePermission(Permission permission) throws DataBackendException, UnknownEntityException {
    }

    @Override
    public synchronized Group addGroup(Group group) throws DataBackendException, EntityExistsException {
        try {
            this.lockExclusive();
            String groupName = group.getName();
            if (this.checkExists(group)) {
                throw new EntityExistsException("Group '" + groupName + "' already exists");
            }
            String dn = "turbineGroupName=" + groupName + "," + LDAPSecurityConstants.getBaseSearch();
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(new BasicAttribute("objectClass", "turbineGroup"));
            attrs.put(new BasicAttribute("turbineGroupName", groupName));
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            ctx.bind(dn, null, (Attributes)attrs);
            this.getAllGroups().add(group);
            Group group2 = group;
            return group2;
        }
        catch (NamingException ex) {
            throw new DataBackendException("NamingException caught", ex);
        }
        finally {
            this.unlockExclusive();
        }
    }

    @Override
    public synchronized Role addRole(Role role) throws DataBackendException, EntityExistsException {
        try {
            this.lockExclusive();
            String roleName = role.getName();
            if (this.checkExists(role)) {
                throw new EntityExistsException("Role '" + roleName + "' already exists");
            }
            String dn = "turbineRoleName=" + roleName + "," + LDAPSecurityConstants.getBaseSearch();
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(new BasicAttribute("objectClass", "turbineRole"));
            attrs.put(new BasicAttribute("turbineRoleName", roleName));
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            ctx.bind(dn, null, (Attributes)attrs);
            this.getAllRoles().add(role);
            Role role2 = role;
            return role2;
        }
        catch (NamingException ex) {
            throw new DataBackendException("NamingException caught", ex);
        }
        finally {
            this.unlockExclusive();
        }
    }

    @Override
    public synchronized Permission addPermission(Permission permission) throws DataBackendException, EntityExistsException {
        try {
            this.lockExclusive();
            String permName = permission.getName();
            if (this.checkExists(permission)) {
                throw new EntityExistsException("Permission '" + permName + "' already exists");
            }
            String dn = "turbinePermissionName=" + permName + "," + LDAPSecurityConstants.getBaseSearch();
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(new BasicAttribute("objectClass", "turbinePermission"));
            attrs.put(new BasicAttribute("turbinePermissionName", permName));
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            ctx.bind(dn, null, (Attributes)attrs);
            this.getAllPermissions().add(permission);
            Permission permission2 = permission;
            return permission2;
        }
        catch (NamingException ex) {
            throw new DataBackendException("NamingException caught", ex);
        }
        finally {
            this.unlockExclusive();
        }
    }

    @Override
    public synchronized void removeGroup(Group group) throws DataBackendException, UnknownEntityException {
        try {
            this.lockExclusive();
            String groupName = group.getName();
            if (!this.checkExists(group)) {
                throw new UnknownEntityException("Group '" + groupName + "' does not exist");
            }
            String dn = "turbineGroupName=" + groupName + "," + LDAPSecurityConstants.getBaseSearch();
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            ctx.unbind(dn);
            this.getAllGroups().remove(group);
        }
        catch (NamingException ex) {
            throw new DataBackendException("NamingException caught", ex);
        }
        finally {
            this.unlockExclusive();
        }
    }

    @Override
    public synchronized void removeRole(Role role) throws DataBackendException, UnknownEntityException {
        try {
            this.lockExclusive();
            String roleName = role.getName();
            if (!this.checkExists(role)) {
                throw new UnknownEntityException("Role '" + roleName + "' does not exist");
            }
            String dn = "turbineRoleName=" + roleName + "," + LDAPSecurityConstants.getBaseSearch();
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            ctx.unbind(dn);
            this.getAllRoles().remove(role);
        }
        catch (NamingException ex) {
            throw new DataBackendException("NamingException caught", ex);
        }
        finally {
            this.unlockExclusive();
        }
    }

    @Override
    public synchronized void removePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        try {
            this.lockExclusive();
            String permName = permission.getName();
            if (!this.checkExists(permission)) {
                throw new UnknownEntityException("Permission '" + permName + "' does not exist");
            }
            String dn = "turbinePermissionName=" + permName + "," + LDAPSecurityConstants.getBaseSearch();
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            ctx.unbind(dn);
            this.getAllPermissions().remove(permission);
        }
        catch (NamingException ex) {
            throw new DataBackendException("NamingException caught", ex);
        }
        finally {
            this.unlockExclusive();
        }
    }

    @Override
    public synchronized void renameGroup(Group group, String name) throws DataBackendException, UnknownEntityException {
    }

    @Override
    public synchronized void renameRole(Role role, String name) throws DataBackendException, UnknownEntityException {
    }

    @Override
    public synchronized void renamePermission(Permission permission, String name) throws DataBackendException, UnknownEntityException {
    }

    @Override
    public void revokeAll(User user) throws DataBackendException, UnknownEntityException {
        for (Group group : this.getAllGroups()) {
            for (Role role : this.getRoles(user, group)) {
                this.revoke(user, group, role);
            }
        }
    }

    @Override
    public void revokeAll(Role role) throws DataBackendException, UnknownEntityException {
        PermissionSet permissions = this.getPermissions(role);
        for (Permission perm : permissions) {
            this.revoke(role, perm);
        }
    }

    public void revokeAll(Group group) throws DataBackendException, UnknownEntityException {
        for (User user : this.getUserList(new Object())) {
            for (Role role : this.getRoles(user, group)) {
                this.revoke(user, group, role);
            }
        }
    }

    public boolean checkExists(Role role) throws DataBackendException {
        RoleSet roleSet = this.getRoles(new Object());
        return roleSet.contains(role);
    }

    public boolean checkExists(Group group) throws DataBackendException {
        GroupSet groupSet = this.getGroups(new Object());
        return groupSet.contains(group);
    }

    public boolean checkExists(Permission permission) throws DataBackendException {
        PermissionSet permissionSet = this.getPermissions(new Object());
        return permissionSet.contains(permission);
    }

    @Override
    public GroupSet getAllGroups() throws DataBackendException {
        return null;
    }

    @Override
    public PermissionSet getAllPermissions() throws DataBackendException {
        return null;
    }

    @Override
    public RoleSet getAllRoles() throws DataBackendException {
        return null;
    }

    @Override
    public List getUserList(Object criteria) throws DataBackendException {
        return null;
    }
}

