/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.TorqueException;
import org.apache.torque.util.Criteria;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.services.schedule.JobEntryPeer;
import org.apache.turbine.services.schedule.JobQueue;
import org.apache.turbine.services.schedule.ScheduleService;
import org.apache.turbine.services.schedule.WorkerThread;
import org.apache.turbine.util.TurbineException;

public class TurbineSchedulerService
extends TurbineBaseService
implements ScheduleService {
    protected static Log log = LogFactory.getLog((String)"scheduler");
    protected JobQueue scheduleQueue = null;
    protected boolean enabled = false;
    protected MainLoop mainLoop = null;
    protected Thread thread = null;

    @Override
    public void init() throws InitializationException {
        try {
            this.setEnabled(this.getConfiguration().getBoolean("enabled", true));
            this.scheduleQueue = new JobQueue();
            this.mainLoop = new MainLoop();
            List<JobEntry> jobs = JobEntryPeer.doSelect(new Criteria());
            if (jobs != null && jobs.size() > 0) {
                Iterator<JobEntry> it = jobs.iterator();
                while (it.hasNext()) {
                    it.next().calcRunTime();
                }
                this.scheduleQueue.batchLoad(jobs);
                this.restart();
            }
            this.setInit(true);
        }
        catch (Exception e) {
            String errorMessage = "Could not initialize the scheduler service";
            log.error((Object)errorMessage, (Throwable)e);
            throw new InitializationException(errorMessage, e);
        }
    }

    @Deprecated
    public void init(ServletConfig config) throws InitializationException {
        this.init();
    }

    @Override
    public void shutdown() {
        if (this.getThread() != null) {
            this.getThread().interrupt();
        }
    }

    @Override
    public JobEntry getJob(int oid) throws TurbineException {
        try {
            JobEntry je = JobEntryPeer.retrieveByPK(oid);
            return this.scheduleQueue.getJob(je);
        }
        catch (TorqueException e) {
            String errorMessage = "Error retrieving job from persistent storage.";
            log.error((Object)errorMessage, (Throwable)e);
            throw new TurbineException(errorMessage, e);
        }
    }

    @Override
    public void addJob(JobEntry je) throws TurbineException {
        this.updateJob(je);
    }

    @Override
    public void removeJob(JobEntry je) throws TurbineException {
        try {
            Criteria c = new Criteria().add(JobEntryPeer.JOB_ID, (Object)je.getPrimaryKey());
            JobEntryPeer.doDelete(c);
            this.scheduleQueue.remove(je);
            this.restart();
        }
        catch (Exception e) {
            String errorMessage = "Problem removing Scheduled Job: " + je.getTask();
            log.error((Object)errorMessage, (Throwable)e);
            throw new TurbineException(errorMessage, e);
        }
    }

    @Override
    public void updateJob(JobEntry je) throws TurbineException {
        try {
            je.calcRunTime();
            if (je.isNew()) {
                this.scheduleQueue.add(je);
            } else {
                this.scheduleQueue.modify(je);
            }
            je.save();
            this.restart();
        }
        catch (Exception e) {
            String errorMessage = "Problem updating Scheduled Job: " + je.getTask();
            log.error((Object)errorMessage, (Throwable)e);
            throw new TurbineException(errorMessage, e);
        }
    }

    @Override
    public List<JobEntry> listJobs() {
        return this.scheduleQueue.list();
    }

    protected void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public synchronized void startScheduler() {
        this.setEnabled(true);
        this.restart();
    }

    @Override
    public synchronized void stopScheduler() {
        log.info((Object)"Stopping job scheduler");
        Thread thread = this.getThread();
        if (thread != null) {
            thread.interrupt();
        }
        this.enabled = false;
    }

    public synchronized Thread getThread() {
        return this.thread;
    }

    protected synchronized void clearThread() {
        this.thread = null;
    }

    public synchronized void restart() {
        if (this.enabled) {
            log.info((Object)"Starting job scheduler");
            if (this.thread == null) {
                this.thread = new Thread((Runnable)this.mainLoop, "SchedulerService");
                this.thread.setDaemon(true);
                this.thread.start();
            } else {
                this.notify();
            }
        }
    }

    protected synchronized JobEntry nextJob() throws TurbineException {
        try {
            while (!Thread.interrupted()) {
                JobEntry je = this.scheduleQueue.getNext();
                if (je == null) {
                    this.wait();
                    continue;
                }
                long now = System.currentTimeMillis();
                long when = je.getNextRuntime();
                if (when > now) {
                    this.wait(when - now);
                    continue;
                }
                this.scheduleQueue.updateQueue(je);
                return je;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected class MainLoop
    implements Runnable {
        protected MainLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String taskName = null;
            try {
                JobEntry je;
                while (TurbineSchedulerService.this.enabled && (je = TurbineSchedulerService.this.nextJob()) != null) {
                    taskName = je.getTask();
                    WorkerThread wt = new WorkerThread(je);
                    Thread helper = new Thread(wt);
                    helper.start();
                }
            }
            catch (Exception e) {
                log.error((Object)("Error running a Scheduled Job: " + taskName), (Throwable)e);
                TurbineSchedulerService.this.enabled = false;
            }
            finally {
                TurbineSchedulerService.this.clearThread();
            }
        }
    }
}

