/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.pipeline;

import java.io.IOException;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.PageLoader;
import org.apache.turbine.pipeline.AbstractValve;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.pipeline.ValveContext;
import org.apache.turbine.services.assemblerbroker.TurbineAssemblerBroker;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class ExecutePageValve
extends AbstractValve {
    private TemplateService templateService;
    private PageLoader pageLoader;

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this.templateService = TurbineTemplate.getService();
        this.pageLoader = (PageLoader)TurbineAssemblerBroker.getLoader("page");
    }

    @Override
    public void invoke(PipelineData pipelineData, ValveContext context) throws IOException, TurbineException {
        try {
            this.executePage(pipelineData);
        }
        catch (Exception e) {
            throw new TurbineException(e);
        }
        context.invokeNext(pipelineData);
    }

    protected void executePage(PipelineData pipelineData) throws Exception {
        String defaultPage;
        RunData data = this.getRunData(pipelineData);
        String string = defaultPage = this.templateService == null ? null : this.templateService.getDefaultPageName(data);
        if (defaultPage == null) {
            defaultPage = Turbine.getConfiguration().getString("page.default", "DefaultPage");
        }
        this.pageLoader.exec(pipelineData, defaultPage);
    }
}

