/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.actions.sessionvalidator;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.actions.sessionvalidator.SessionValidator;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class TemplateSecureSessionValidator
extends SessionValidator {
    private static Log log = LogFactory.getLog(TemplateSecureSessionValidator.class);

    @Override
    @Deprecated
    public void doPerform(RunData data) throws TurbineException {
        Configuration conf = Turbine.getConfiguration();
        data.populate();
        if (data.getUser() == null) {
            log.debug((Object)"Fixing up empty User Object!");
            data.setUser(TurbineSecurity.getAnonymousUser());
            data.save();
        }
        if (!data.getUser().hasLoggedIn()) {
            log.debug((Object)"User is not logged in!");
            if (StringUtils.isEmpty((String)data.getMessage())) {
                data.setMessage(conf.getString("login.message"));
            }
            String loginTemplate = conf.getString("template.login");
            log.debug((Object)("Sending User to the Login Screen (" + loginTemplate + ")"));
            data.getTemplateInfo().setScreenTemplate(loginTemplate);
            data.setAction(null);
        }
        log.debug((Object)"Login Check finished!");
        if (!data.hasScreen() && StringUtils.isEmpty((String)data.getTemplateInfo().getScreenTemplate())) {
            String template = conf.getString("template.homepage");
            if (StringUtils.isNotEmpty((String)template)) {
                data.getTemplateInfo().setScreenTemplate(template);
            } else {
                data.setScreen(conf.getString("screen.homepage"));
            }
        }
        if (data.getParameters().containsKey((Object)"_session_access_counter") && !TurbineSecurity.isAnonymousUser(data.getUser()) && data.getParameters().getInt("_session_access_counter") < (Integer)data.getUser().getTemp("_session_access_counter") - 1) {
            if (data.getTemplateInfo().getScreenTemplate() != null) {
                data.getUser().setTemp("prev_template", data.getTemplateInfo().getScreenTemplate().replace('/', ','));
                data.getTemplateInfo().setScreenTemplate(conf.getString("template.invalidstate"));
            } else {
                data.getUser().setTemp("prev_screen", data.getScreen().replace('/', ','));
                data.setScreen(conf.getString("screen.invalidstate"));
            }
            data.getUser().setTemp("prev_parameters", data.getParameters());
            data.setAction("");
        }
        if (data.getTemplateInfo().getScreenTemplate() != null) {
            data.setScreen(null);
        }
    }

    @Override
    public void doPerform(PipelineData pipelineData) throws TurbineException {
        RunData data = this.getRunData(pipelineData);
        this.doPerform(data);
    }
}

